/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.server.AbstractDBSupportImpl;
import de.willuhn.jameica.messaging.BootMessage;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.I18N;
import java.io.File;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.text.MessageFormat;

public class DBSupportPostgreSQLImpl
extends AbstractDBSupportImpl {
    @Override
    public String getJdbcDriver() {
        return HBCIDBService.SETTINGS.getString("database.driver.postgresql.jdbcdriver", "org.postgresql.Driver");
    }

    @Override
    public String getJdbcPassword() {
        return this.getEncrypted("database.driver.postgresql.password");
    }

    @Override
    public String getJdbcUrl() {
        return HBCIDBService.SETTINGS.getString("database.driver.postgresql.jdbcurl", "jdbc:postgresql://localhost:5432/hibiscus");
    }

    @Override
    public String getJdbcUsername() {
        return HBCIDBService.SETTINGS.getString("database.driver.postgresql.username", "hibiscus");
    }

    @Override
    public void execute(Connection conn, File sqlScript) throws RemoteException {
        if (sqlScript == null) {
            return;
        }
        File f = new File(sqlScript.getParent(), String.valueOf(this.getScriptPrefix()) + sqlScript.getName());
        if (f.exists()) {
            I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
            String text = i18n.tr("Bei der Verwendung von PostgreSQL werden Datenbank-Updates nicht automatisch ausgefuehrt. Bitte fuehren Sie das folgende SQL-Script manuell aus:\n{0}", f.getAbsolutePath());
            BootMessage msg = new BootMessage(text);
            msg.setTitle(i18n.tr("Hinweis zur Verwendung von PostgreSQL"));
            Application.getMessagingFactory().getMessagingQueue("jameica.boot").queueMessage((Message)msg);
        }
    }

    @Override
    public String getScriptPrefix() throws RemoteException {
        return "postgresql-";
    }

    @Override
    public String getSQLTimestamp(String content) throws RemoteException {
        return MessageFormat.format("({0}::timestamp)", content);
    }

    @Override
    public boolean getInsertWithID() throws RemoteException {
        return false;
    }

    @Override
    public int getTransactionIsolationLevel() throws RemoteException {
        return 2;
    }
}

