/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.EinnahmeAusgabeZeitraum;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.I18N;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.rmi.RemoteException;
import java.util.Date;

public class EinnahmeAusgabe
implements EinnahmeAusgabeZeitraum {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private Konto konto;
    private String text;
    private double anfangssaldo;
    private double einnahmen;
    private double ausgaben;
    private double endsaldo;
    private Date startdatum;
    private Date enddatum;
    private boolean isSumme = false;
    private boolean anfangsSaldoDurchUmsatzGesetzt = false;

    public EinnahmeAusgabe() {
    }

    public EinnahmeAusgabe(Konto k) throws RemoteException {
        this.konto = k;
        this.text = k.getLongName();
    }

    public void addUmsatz(Umsatz umsatz) throws RemoteException {
        if (!this.konto.equals((GenericObject)umsatz.getKonto())) {
            throw new IllegalStateException("programming error - account mismatch");
        }
        if (this.startdatum != null && umsatz.getDatum().before(this.startdatum)) {
            throw new IllegalStateException("programming error - wrong interval chosen");
        }
        if (this.enddatum != null && umsatz.getDatum().after(this.enddatum)) {
            throw new IllegalStateException("programming error - wrong interval chosen");
        }
        if (!this.anfangsSaldoDurchUmsatzGesetzt) {
            this.anfangsSaldoDurchUmsatzGesetzt = true;
            this.anfangssaldo = umsatz.getSaldo() - umsatz.getBetrag();
        }
        this.endsaldo = umsatz.getSaldo();
        if (umsatz.getBetrag() > 0.0) {
            this.einnahmen += umsatz.getBetrag();
        } else {
            this.ausgaben += -umsatz.getBetrag();
        }
    }

    public Konto getKonto() {
        return this.konto;
    }

    @Override
    public String getText() {
        return this.isSumme ? i18n.tr("Summe") : this.text;
    }

    public double getAnfangssaldo() {
        return this.anfangssaldo;
    }

    public void setAnfangssaldo(double anfangssaldo) {
        this.anfangssaldo = anfangssaldo;
    }

    @Override
    public double getEinnahmen() {
        return this.einnahmen;
    }

    public void setEinnahmen(double einnahmen) {
        this.einnahmen = einnahmen;
    }

    @Override
    public double getAusgaben() {
        return this.ausgaben;
    }

    public void setAusgaben(double ausgaben) {
        this.ausgaben = ausgaben;
    }

    public double getEndsaldo() {
        return this.endsaldo;
    }

    public void setEndsaldo(double endsaldo) {
        this.endsaldo = endsaldo;
    }

    @Override
    public Date getStartdatum() {
        return this.startdatum;
    }

    public void setStartdatum(Date startdatum) {
        this.startdatum = startdatum;
    }

    @Override
    public Date getEnddatum() {
        return this.enddatum;
    }

    public void setEnddatum(Date enddatum) {
        this.enddatum = enddatum;
    }

    public double getDifferenz() {
        BigDecimal va = new BigDecimal(this.anfangssaldo);
        BigDecimal vin = new BigDecimal(this.einnahmen);
        BigDecimal vout = new BigDecimal(this.ausgaben);
        BigDecimal ve = new BigDecimal(this.endsaldo);
        return va.add(vin).subtract(vout).subtract(ve).setScale(2, RoundingMode.HALF_EVEN).doubleValue();
    }

    public boolean hasDiff() {
        return Math.abs(this.getDifferenz()) >= 0.01;
    }

    public double getPlusminus() {
        return this.einnahmen - this.ausgaben;
    }

    public boolean isSumme() {
        return this.isSumme;
    }

    public void setIsSumme(boolean b) {
        this.isSumme = b;
    }

    public boolean equals(GenericObject arg0) throws RemoteException {
        return arg0 == this;
    }

    public Object getAttribute(String arg0) throws RemoteException {
        try {
            return BeanUtil.invoke((Object)this, (String)BeanUtil.toGetMethod((String)arg0), null);
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RemoteException("unable to get value for attribute " + arg0, e);
        }
    }

    public String[] getAttributeNames() throws RemoteException {
        return new String[]{"text", "anfangssaldo", "einnahmen", "ausgaben", "endsaldo", "startdatum", "enddatum"};
    }

    public String getID() throws RemoteException {
        return null;
    }

    public String getPrimaryAttribute() throws RemoteException {
        return "text";
    }

    public String toString() {
        return String.valueOf(this.text) + ":" + this.anfangssaldo + ":" + this.einnahmen + ":" + this.ausgaben + ":" + this.endsaldo + ":" + this.getPlusminus() + ":" + this.getDifferenz();
    }
}

