/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.GenericObjectNode;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.jameica.hbci.rmi.EinnahmeAusgabeZeitraum;
import de.willuhn.jameica.hbci.server.EinnahmeAusgabe;
import de.willuhn.jameica.util.DateUtil;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;

public class EinnahmeAusgabeTreeNode
implements EinnahmeAusgabeZeitraum,
GenericObjectNode {
    private Date startdatum;
    private Date enddatum;
    private List<EinnahmeAusgabe> children;

    public EinnahmeAusgabeTreeNode(Date from, Date to, List<EinnahmeAusgabe> children) {
        this.startdatum = from;
        this.enddatum = to;
        this.children = children;
    }

    @Override
    public Date getStartdatum() {
        return this.startdatum;
    }

    @Override
    public Date getEnddatum() {
        return this.enddatum;
    }

    public boolean equals(GenericObject arg0) throws RemoteException {
        return this == arg0;
    }

    @Override
    public String getText() {
        return String.valueOf(DateUtil.DEFAULT_FORMAT.format(this.startdatum)) + " - " + DateUtil.DEFAULT_FORMAT.format(this.enddatum);
    }

    @Override
    public double getAusgaben() {
        if (this.children == null || this.children.size() == 0) {
            return 0.0;
        }
        double sum = 0.0;
        for (EinnahmeAusgabe e : this.children) {
            if (e.isSumme()) continue;
            sum += e.getAusgaben();
        }
        return sum;
    }

    @Override
    public double getEinnahmen() {
        if (this.children == null || this.children.size() == 0) {
            return 0.0;
        }
        double sum = 0.0;
        for (EinnahmeAusgabe e : this.children) {
            if (e.isSumme()) continue;
            sum += e.getEinnahmen();
        }
        return sum;
    }

    public Object getAttribute(String arg0) throws RemoteException {
        if ("text".equals(arg0)) {
            return this.getText();
        }
        if ("startdatum".equals(arg0)) {
            return this.startdatum;
        }
        if ("enddatum".equals(arg0)) {
            return this.enddatum;
        }
        if ("children".equals(arg0)) {
            return this.children;
        }
        return null;
    }

    public String[] getAttributeNames() throws RemoteException {
        return new String[]{"text", "startdatum", "enddatum", "children"};
    }

    public String getID() throws RemoteException {
        return null;
    }

    public String getPrimaryAttribute() throws RemoteException {
        return "text";
    }

    public GenericIterator getChildren() throws RemoteException {
        return PseudoIterator.fromArray((GenericObject[])this.children.toArray(new EinnahmeAusgabe[0]));
    }

    public GenericObjectNode getParent() throws RemoteException {
        return null;
    }

    public GenericIterator getPath() throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public GenericIterator getPossibleParents() throws RemoteException {
        throw new UnsupportedOperationException();
    }

    public boolean hasChild(GenericObjectNode arg0) throws RemoteException {
        if (!(arg0 instanceof EinnahmeAusgabe)) {
            return false;
        }
        return this.children.contains((EinnahmeAusgabe)arg0);
    }
}

