/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.datasource.db.DBServiceImpl;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.datasource.rmi.DBObject;
import de.willuhn.datasource.rmi.ObjectNotFoundException;
import de.willuhn.datasource.rmi.ResultSetExtractor;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.DBSupport;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.server.DBSupportH2Impl;
import de.willuhn.jameica.hbci.server.HBCIUpdateProvider;
import de.willuhn.jameica.hbci.server.VersionUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.sql.version.UpdateProvider;
import de.willuhn.sql.version.Updater;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.MultipleClassLoader;
import de.willuhn.util.ProgressMonitor;
import java.io.File;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class HBCIDBServiceImpl
extends DBServiceImpl
implements HBCIDBService {
    private DBSupport driver = null;

    public HBCIDBServiceImpl() throws RemoteException {
        this(SETTINGS.getString("database.driver", DBSupportH2Impl.class.getName()));
    }

    public HBCIDBServiceImpl(String driverClass) throws RemoteException {
        BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        MultipleClassLoader cl = Application.getPluginLoader().getManifest(HBCI.class).getClassLoader();
        this.setClassloader((ClassLoader)cl);
        this.setClassFinder(cl.getClassFinder());
        if (driverClass == null) {
            throw new RemoteException("no driver given");
        }
        Logger.info((String)("loading database driver: " + driverClass));
        try {
            Class c = cl.load(driverClass);
            this.driver = (DBSupport)service.get(c);
        }
        catch (Throwable t) {
            throw new RemoteException("unable to load database driver " + driverClass, t);
        }
    }

    public String getName() throws RemoteException {
        I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
        return i18n.tr("Datenbank-Service f\u00fcr Hibiscus");
    }

    protected boolean getAutoCommit() throws RemoteException {
        return SETTINGS.getBoolean("autocommit", super.getAutoCommit());
    }

    protected String getJdbcDriver() throws RemoteException {
        return this.driver.getJdbcDriver();
    }

    protected String getJdbcPassword() throws RemoteException {
        return this.driver.getJdbcPassword();
    }

    protected String getJdbcUrl() throws RemoteException {
        return this.driver.getJdbcUrl();
    }

    protected String getJdbcUsername() throws RemoteException {
        return this.driver.getJdbcUsername();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void checkConsistency() throws RemoteException, ApplicationException {
        block9: {
            Logger.info((String)"determine current database version");
            version = null;
            try {
                version = VersionUtil.getVersion(this, "db");
                Logger.info((String)("current database version: " + version.getVersion()));
            }
            catch (RemoteException re) {
                cause = re.getCause();
                if (!(cause instanceof SQLException)) {
                    throw re;
                }
                Logger.warn((String)"unable to determine database version - database probably empty, recreating");
                Logger.write((Level)Level.DEBUG, (String)"stacktrace for debugging purpose", (Throwable)re);
                try {
                    this.install();
                    version = VersionUtil.getVersion(this, "db");
                    Logger.info((String)("current database version: " + version.getVersion()));
                }
                catch (RemoteException re2) {
                    Logger.error((String)"unable to recreate database", (Throwable)re2);
                    throw re;
                }
            }
            try {
                Logger.info((String)"init update provider");
                provider = new HBCIUpdateProvider(this.getConnection(), version);
                updater = new Updater((UpdateProvider)provider, "iso-8859-1");
                updater.execute();
                Logger.info((String)"updates finished");
                break block9;
            }
            catch (Exception e) {
                t /* !! */  = e;
                i = 0;
                ** while (i < 10)
            }
lbl-1000:
            // 1 sources

            {
                if (t /* !! */  == null) break;
                if (t /* !! */  instanceof SQLException && (code = (se = (SQLException)t /* !! */ ).getErrorCode()) == 90131) {
                    Logger.error((String)"found buggy h2 driver, update jameica first", (Throwable)e);
                    i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
                    throw new ApplicationException(i18n.tr("Bitte aktualisiere erst Jameica auf Version 2.8.2 oder h\u00f6her"));
                }
                t /* !! */  = t /* !! */ .getCause();
                ++i;
                continue;
            }
lbl40:
            // 2 sources

            throw new ApplicationException((Throwable)e);
        }
    }

    protected Connection getConnection() throws RemoteException {
        try {
            return super.getConnection();
        }
        catch (RemoteException re) {
            Application.getMessagingFactory().getMessagingQueue("jameica.error").sendMessage((Message)new QueryMessage((Object)re));
            throw re;
        }
    }

    @Override
    public int executeUpdate(String query, String ... params) throws RemoteException {
        if (!this.isStarted()) {
            throw new RemoteException("db service not started");
        }
        Connection conn = this.getConnection();
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(query);
            if (params != null) {
                int i = 0;
                while (i < params.length) {
                    String o = params[i];
                    if (o == null) {
                        ps.setNull(i + 1, 0);
                    } else {
                        ps.setObject(i + 1, params[i]);
                    }
                    ++i;
                }
            }
            int count = ps.executeUpdate();
            conn.commit();
            int n = count;
            return n;
        }
        catch (SQLException e) {
            Logger.error((String)"error while executing sql update", (Throwable)e);
            Application.getMessagingFactory().getMessagingQueue("jameica.error").sendMessage((Message)new QueryMessage((Object)e));
            throw new RemoteException("error while executing sql update: " + e.getMessage(), e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t2) {
                    Logger.error((String)"error while closing statement", (Throwable)t2);
                }
            }
        }
    }

    public <T extends DBObject> DBIterator<T> createList(Class<? extends DBObject> arg0) throws RemoteException {
        try {
            return super.createList(arg0);
        }
        catch (RemoteException re) {
            Application.getMessagingFactory().getMessagingQueue("jameica.error").sendMessage((Message)new QueryMessage((Object)re));
            throw re;
        }
    }

    public <T extends DBObject> T createObject(Class<? extends DBObject> arg0, String arg1) throws RemoteException {
        try {
            return (T)super.createObject(arg0, arg1);
        }
        catch (ObjectNotFoundException ofe) {
            throw ofe;
        }
        catch (RemoteException re) {
            Application.getMessagingFactory().getMessagingQueue("jameica.error").sendMessage((Message)new QueryMessage((Object)re));
            throw re;
        }
    }

    public Object execute(String arg0, Object[] arg1, ResultSetExtractor arg2) throws RemoteException {
        try {
            return super.execute(arg0, arg1, arg2);
        }
        catch (RemoteException re) {
            Application.getMessagingFactory().getMessagingQueue("jameica.error").sendMessage((Message)new QueryMessage((Object)re));
            throw re;
        }
    }

    @Override
    public void install() throws RemoteException {
        I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
        ProgressMonitor monitor = Application.getCallback().getStartupMonitor();
        monitor.setStatusText(i18n.tr("Installiere Hibiscus"));
        Manifest mf = Application.getPluginLoader().getPlugin(HBCI.class).getManifest();
        File file = new File(String.valueOf(mf.getPluginDir()) + File.separator + "sql", "create.sql");
        this.driver.execute(this.getConnection(), file);
    }

    @Override
    public String getSQLTimestamp(String content) throws RemoteException {
        return this.driver.getSQLTimestamp(content);
    }

    protected boolean getInsertWithID() throws RemoteException {
        return this.driver.getInsertWithID();
    }

    protected void checkConnection(Connection conn) throws SQLException {
        try {
            this.driver.checkConnection(conn);
        }
        catch (RemoteException re) {
            throw new SQLException(re.getMessage());
        }
        super.checkConnection(conn);
    }

    protected int getTransactionIsolationLevel() throws RemoteException {
        return this.driver.getTransactionIsolationLevel();
    }

    @Override
    public DBSupport getDriver() throws RemoteException {
        return this.driver;
    }
}

