/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.Version;
import de.willuhn.jameica.plugin.AbstractPlugin;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.plugin.PluginResources;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.sql.version.UpdateProvider;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.ProgressMonitor;
import java.io.File;
import java.rmi.RemoteException;
import java.sql.Connection;

public class HBCIUpdateProvider
implements UpdateProvider {
    private Version version = null;
    private Connection conn = null;
    private Manifest manifest = null;
    private PluginResources res = null;

    protected HBCIUpdateProvider(Connection conn, Version version) {
        this.conn = conn;
        this.version = version;
        AbstractPlugin p = (AbstractPlugin)Application.getPluginLoader().getPlugin(HBCI.class);
        this.manifest = p.getManifest();
        this.res = p.getResources();
    }

    public synchronized Connection getConnection() throws ApplicationException {
        return this.conn;
    }

    public int getCurrentVersion() throws ApplicationException {
        try {
            return this.version.getVersion();
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to read current version number");
            throw new ApplicationException(this.res.getI18N().tr("Fehler beim Ermitteln der aktuellen Versionsnummer"));
        }
    }

    public ProgressMonitor getProgressMonitor() {
        return Application.getController().getApplicationCallback().getStartupMonitor();
    }

    public File getUpdatePath() throws ApplicationException {
        return new File(this.manifest.getPluginDir(), "updates");
    }

    public void setNewVersion(int newVersion) throws ApplicationException {
        int current = this.getCurrentVersion();
        try {
            Logger.info((String)("applying new version [" + this.version.getName() + "]: " + newVersion));
            this.version.setVersion(newVersion);
            this.version.store();
        }
        catch (Exception e) {
            try {
                this.version.setVersion(current);
            }
            catch (Exception e2) {
                Logger.error((String)"unable to rollback version", (Throwable)e2);
            }
            if (e instanceof ApplicationException) {
                throw (ApplicationException)((Object)e);
            }
            Logger.error((String)"unable to read current version number", (Throwable)e);
            throw new ApplicationException(this.res.getI18N().tr("Fehler beim Ermitteln der aktuellen Versionsnummer"));
        }
    }

    public PluginResources getResources() {
        return this.res;
    }
}

