/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.rmi.HibiscusAddress;
import de.willuhn.jameica.hbci.server.AbstractHibiscusDBObject;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;

public class HibiscusAddressImpl
extends AbstractHibiscusDBObject
implements HibiscusAddress {
    private static final transient I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    protected String getTableName() {
        return "empfaenger";
    }

    public String getPrimaryAttribute() throws RemoteException {
        return "name";
    }

    protected void insertCheck() throws ApplicationException {
        try {
            String name = this.getName();
            if (name == null || name.length() == 0) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie einen Namen ein."));
            }
            HBCIProperties.checkLength(name, HBCIProperties.HBCI_TRANSFER_NAME_MAXLENGTH);
            boolean haveAccount = false;
            String kn = this.getKontonummer();
            if (kn != null && kn.length() > 0) {
                HBCIProperties.checkChars(kn, HBCIProperties.HBCI_KTO_VALIDCHARS);
                HBCIProperties.checkLength(kn, HBCIProperties.HBCI_KTO_MAXLENGTH_SOFT);
                String blz = this.getBlz();
                if (blz == null || blz.length() == 0) {
                    throw new ApplicationException(i18n.tr("Bitte geben Sie eine BLZ ein."));
                }
                HBCIProperties.checkChars(blz, HBCIProperties.HBCI_BLZ_VALIDCHARS);
                if (!Settings.getKontoCheckExcludeAddressbook() && !HBCIProperties.checkAccountCRC(blz, kn)) {
                    throw new ApplicationException(i18n.tr("Ung\u00fcltige BLZ/Kontonummer. Bitte pr\u00fcfen Sie Ihre Eingaben."));
                }
                haveAccount = true;
            }
            String iban = this.getIban();
            String bic = this.getBic();
            String bank = this.getBank();
            if (iban != null && iban.length() > 0) {
                HBCIProperties.checkLength(iban, HBCIProperties.HBCI_IBAN_MAXLENGTH);
                HBCIProperties.checkChars(iban, HBCIProperties.HBCI_IBAN_VALIDCHARS);
                HBCIProperties.checkIBAN(iban);
                haveAccount = true;
            }
            if (bic != null && bic.length() > 0) {
                HBCIProperties.checkBIC(bic);
            }
            if (bank != null && bank.length() > 0) {
                HBCIProperties.checkLength(bank, HBCIProperties.HBCI_SEPATRANSFER_USAGE_MAXLENGTH);
            }
            if (!haveAccount) {
                throw new ApplicationException("Geben Sie bitte eine Kontonummer/BLZ oder IBAN ein");
            }
        }
        catch (RemoteException e) {
            Logger.error((String)"error while checking empfaenger", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler bei der Pr\u00fcfung des Empf\u00e4ngers"));
        }
    }

    protected void updateCheck() throws ApplicationException {
        this.insertCheck();
    }

    @Override
    public String getKontonummer() throws RemoteException {
        return (String)this.getAttribute("kontonummer");
    }

    @Override
    public String getBlz() throws RemoteException {
        return (String)this.getAttribute("blz");
    }

    @Override
    public String getName() throws RemoteException {
        return (String)this.getAttribute("name");
    }

    @Override
    public void setKontonummer(String kontonummer) throws RemoteException {
        this.setAttribute("kontonummer", kontonummer);
    }

    @Override
    public void setBlz(String blz) throws RemoteException {
        this.setAttribute("blz", blz);
    }

    @Override
    public void setName(String name) throws RemoteException {
        this.setAttribute("name", name);
    }

    @Override
    public String getKommentar() throws RemoteException {
        return (String)this.getAttribute("kommentar");
    }

    @Override
    public void setKommentar(String kommentar) throws RemoteException {
        this.setAttribute("kommentar", kommentar);
    }

    @Override
    public String getBank() throws RemoteException {
        return (String)this.getAttribute("bank");
    }

    @Override
    public void setBank(String name) throws RemoteException {
        this.setAttribute("bank", name);
    }

    @Override
    public String getBic() throws RemoteException {
        return (String)this.getAttribute("bic");
    }

    @Override
    public void setBic(String bic) throws RemoteException {
        this.setAttribute("bic", bic);
    }

    @Override
    public String getIban() throws RemoteException {
        return (String)this.getAttribute("iban");
    }

    @Override
    public void setIban(String iban) throws RemoteException {
        this.setAttribute("iban", iban);
    }

    @Override
    public String getKategorie() throws RemoteException {
        return (String)this.getAttribute("kategorie");
    }

    @Override
    public void setKategorie(String kategorie) throws RemoteException {
        this.setAttribute("kategorie", kategorie);
    }
}

