/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import org.apache.commons.lang.StringUtils;

public enum InstantPaymentStatus {
    STATUS1(1, true, "in Terminierung"),
    STATUS2(2, false, "abgelehnt von erster Inkassostelle"),
    STATUS3(3, true, "in Bearbeitung"),
    STATUS4(4, true, "Creditoren-seitig verarbeitet, Buchung veranlasst"),
    STATUS5(5, true, "R-Transaktion wurde veranlasst"),
    STATUS6(6, false, "Auftrag fehlgeschagen"),
    STATUS7(7, true, "Auftrag ausgef\u00fchrt; Geld f\u00fcr den Zahlungsempf\u00e4nger verf\u00fcgbar"),
    STATUS8(8, false, "Abgelehnt durch Zahlungsdienstleister des Zahlers"),
    STATUS9(9, false, "Abgelehnt durch Zahlungsdienstleister des Zahlungsempf\u00e4ngers");

    private static final I18N i18n;
    private int status = 0;
    private boolean success = false;
    private String description = null;

    static {
        i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    }

    private InstantPaymentStatus(int status, boolean success, String description) {
        this.status = status;
        this.success = success;
        this.description = description;
    }

    public int getStatus() {
        return this.status;
    }

    public String getDescription() {
        return i18n.tr(this.description);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public static InstantPaymentStatus determine(String status) {
        if (StringUtils.trimToNull((String)status) == null) {
            return null;
        }
        try {
            int i = Integer.parseInt(status);
            InstantPaymentStatus[] instantPaymentStatusArray = InstantPaymentStatus.values();
            int n = instantPaymentStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                InstantPaymentStatus s = instantPaymentStatusArray[n2];
                if (s.status == i) {
                    return s;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Logger.error((String)("got invalid status code for sepa instant payment " + status), (Throwable)e);
        }
        return null;
    }
}

