/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.datasource.rmi.ResultSetExtractor;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.rmi.AuslandsUeberweisung;
import de.willuhn.jameica.hbci.rmi.Dauerauftrag;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Kontoauszug;
import de.willuhn.jameica.hbci.rmi.Lastschrift;
import de.willuhn.jameica.hbci.rmi.Protokoll;
import de.willuhn.jameica.hbci.rmi.SammelLastschrift;
import de.willuhn.jameica.hbci.rmi.SammelUeberweisung;
import de.willuhn.jameica.hbci.rmi.SepaDauerauftrag;
import de.willuhn.jameica.hbci.rmi.SepaLastschrift;
import de.willuhn.jameica.hbci.rmi.SepaSammelLastschrift;
import de.willuhn.jameica.hbci.rmi.SepaSammelUeberweisung;
import de.willuhn.jameica.hbci.rmi.Ueberweisung;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.rmi.UmsatzTyp;
import de.willuhn.jameica.hbci.server.AbstractHibiscusDBObject;
import de.willuhn.jameica.hbci.server.Cache;
import de.willuhn.jameica.hbci.server.UmsatzUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.zip.CRC32;
import org.apache.commons.lang.StringUtils;

public class KontoImpl
extends AbstractHibiscusDBObject
implements Konto {
    private static final transient I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    protected String getTableName() {
        return "konto";
    }

    public String getPrimaryAttribute() throws RemoteException {
        return "kontonummer";
    }

    protected void insertCheck() throws ApplicationException {
        try {
            if (StringUtils.trimToNull((String)this.getName()) == null) {
                throw new ApplicationException(i18n.tr("Bitten geben Sie den Namen des Kontoinhabers ein."));
            }
            HBCIProperties.checkLength(this.getName(), HBCIProperties.HBCI_TRANSFER_NAME_MAXLENGTH);
            if (this.getKontonummer() == null || this.getKontonummer().length() == 0) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie eine Kontonummer ein."));
            }
            if (this.getBLZ() == null || this.getBLZ().length() == 0) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie eine Bankleitzahl ein."));
            }
            HBCIProperties.checkChars(this.getBLZ(), HBCIProperties.HBCI_BLZ_VALIDCHARS);
            HBCIProperties.checkChars(this.getKontonummer(), HBCIProperties.HBCI_KTO_VALIDCHARS);
            HBCIProperties.checkLength(this.getKontonummer(), HBCIProperties.HBCI_KTO_MAXLENGTH_SOFT);
            HBCIProperties.checkLength(this.getUnterkonto(), HBCIProperties.HBCI_ID_MAXLENGTH);
            if (this.getKundennummer() == null || this.getKundennummer().length() == 0) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie Ihre Kundenkennung ein."));
            }
            if (this.getWaehrung() == null || this.getWaehrung().length() != 3) {
                this.setWaehrung(HBCIProperties.CURRENCY_DEFAULT_DE);
            }
            if (!HBCIProperties.checkAccountCRC(this.getBLZ(), this.getKontonummer())) {
                throw new ApplicationException(i18n.tr("Ung\u00fcltige BLZ/Kontonummer. Bitte pr\u00fcfen Sie Ihre Eingaben."));
            }
            String iban = this.getIban();
            String bic = this.getBic();
            if (iban != null && iban.length() > 0) {
                HBCIProperties.checkLength(iban, HBCIProperties.HBCI_IBAN_MAXLENGTH);
                HBCIProperties.checkChars(iban, HBCIProperties.HBCI_IBAN_VALIDCHARS);
                HBCIProperties.checkIBAN(iban);
            }
            if (bic != null && bic.length() > 0) {
                HBCIProperties.checkBIC(bic);
            }
        }
        catch (RemoteException e) {
            Logger.error((String)"error while insertcheck", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler bei der Pr\u00fcfung der Daten"));
        }
    }

    protected void updateCheck() throws ApplicationException {
        this.insertCheck();
    }

    @Override
    public String getKontonummer() throws RemoteException {
        return (String)this.getAttribute("kontonummer");
    }

    @Override
    public String getBLZ() throws RemoteException {
        return (String)this.getAttribute("blz");
    }

    @Override
    public String getName() throws RemoteException {
        return (String)this.getAttribute("name");
    }

    @Override
    public String getPassportClass() throws RemoteException {
        return (String)this.getAttribute("passport_class");
    }

    @Override
    public String getBackendClass() throws RemoteException {
        return (String)this.getAttribute("backend_class");
    }

    @Override
    public Integer getAccountType() throws RemoteException {
        return (Integer)this.getAttribute("acctype");
    }

    @Override
    public void setKontonummer(String kontonummer) throws RemoteException {
        this.setAttribute("kontonummer", kontonummer);
    }

    @Override
    public void setBLZ(String blz) throws RemoteException {
        this.setAttribute("blz", blz);
    }

    @Override
    public void setName(String name) throws RemoteException {
        this.setAttribute("name", name);
    }

    @Override
    public void setPassportClass(String passport) throws RemoteException {
        this.setAttribute("passport_class", passport);
    }

    @Override
    public void setBackendClass(String backend) throws RemoteException {
        this.setAttribute("backend_class", backend);
    }

    @Override
    public void setAccountType(Integer i) throws RemoteException {
        this.setAttribute("acctype", i);
    }

    @Override
    public void delete() throws RemoteException, ApplicationException {
        if (this.isNewObject()) {
            return;
        }
        Cache.clear(Konto.class);
        try {
            this.transactionBegin();
            DBIterator list = this.getUmsaetze();
            Umsatz um = null;
            while (list.hasNext()) {
                um = (Umsatz)list.next();
                um.delete();
            }
            list = this.getUmsatzTypen();
            UmsatzTyp ut = null;
            while (list.hasNext()) {
                ut = (UmsatzTyp)list.next();
                ut.setKonto(null);
                ut.store();
            }
            list = this.getKontoauszuege();
            Kontoauszug az = null;
            while (list.hasNext()) {
                az = (Kontoauszug)list.next();
                az.delete();
            }
            list = this.getDauerauftraege();
            Dauerauftrag da = null;
            while (list.hasNext()) {
                da = (Dauerauftrag)list.next();
                da.delete();
            }
            list = this.getSepaDauerauftraege();
            SepaDauerauftrag sda = null;
            while (list.hasNext()) {
                sda = (SepaDauerauftrag)list.next();
                sda.delete();
            }
            list = this.getLastschriften();
            Lastschrift ls = null;
            while (list.hasNext()) {
                ls = (Lastschrift)list.next();
                ls.delete();
            }
            list = this.getSammelLastschriften();
            SammelLastschrift sls = null;
            while (list.hasNext()) {
                sls = (SammelLastschrift)list.next();
                sls.delete();
            }
            list = this.getUeberweisungen();
            Ueberweisung u = null;
            while (list.hasNext()) {
                u = (Ueberweisung)list.next();
                u.delete();
            }
            list = this.getSammelUeberweisungen();
            SammelUeberweisung su = null;
            while (list.hasNext()) {
                su = (SammelUeberweisung)list.next();
                su.delete();
            }
            list = this.getAuslandsUeberweisungen();
            AuslandsUeberweisung au = null;
            while (list.hasNext()) {
                au = (AuslandsUeberweisung)list.next();
                au.delete();
            }
            list = this.getSepaLastschriften();
            SepaLastschrift sl = null;
            while (list.hasNext()) {
                sl = (SepaLastschrift)list.next();
                sl.delete();
            }
            list = this.getSepaSammelLastschriften();
            SepaSammelLastschrift ssl = null;
            while (list.hasNext()) {
                ssl = (SepaSammelLastschrift)list.next();
                ssl.delete();
            }
            list = this.getSepaSammelUeberweisungen();
            SepaSammelUeberweisung ssu = null;
            while (list.hasNext()) {
                ssu = (SepaSammelUeberweisung)list.next();
                ssu.delete();
            }
            list = this.getProtokolle();
            Protokoll p = null;
            while (list.hasNext()) {
                p = (Protokoll)list.next();
                p.delete();
            }
            super.delete();
            this.transactionCommit();
        }
        catch (ApplicationException | RemoteException e) {
            this.transactionRollback();
            throw e;
        }
    }

    @Override
    public String getWaehrung() throws RemoteException {
        return (String)this.getAttribute("waehrung");
    }

    @Override
    public void setWaehrung(String waehrung) throws RemoteException {
        this.setAttribute("waehrung", waehrung);
    }

    @Override
    public String getKundennummer() throws RemoteException {
        return (String)this.getAttribute("kundennummer");
    }

    @Override
    public void setKundennummer(String kundennummer) throws RemoteException {
        this.setAttribute("kundennummer", kundennummer);
    }

    @Override
    public double getSaldo() throws RemoteException {
        Double d = (Double)this.getAttribute("saldo");
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    @Override
    public double getSaldoAvailable() throws RemoteException {
        Double d = (Double)this.getAttribute("saldo_available");
        if (d == null) {
            return Double.NaN;
        }
        return d;
    }

    @Override
    public java.util.Date getSaldoDatum() throws RemoteException {
        return (java.util.Date)this.getAttribute("saldo_datum");
    }

    @Override
    public void reset() throws RemoteException {
        this.setAttribute("saldo_datum", null);
        this.setAttribute("saldo", null);
        this.setAttribute("saldo_available", null);
    }

    @Override
    public DBIterator getUmsaetze() throws RemoteException {
        return this.getUmsaetze(-1);
    }

    @Override
    public DBIterator getUmsaetze(int days) throws RemoteException {
        DBIterator list = UmsatzUtil.getUmsaetzeBackwards();
        list.addFilter("konto_id = " + this.getID());
        if (days > 0) {
            long d = (long)days * 24L * 60L * 60L * 1000L;
            java.util.Date start = DateUtil.startOfDay((java.util.Date)new java.util.Date(System.currentTimeMillis() - d));
            list.addFilter("datum >= ?", new Object[]{new Date(start.getTime())});
        }
        return list;
    }

    @Override
    public DBIterator getUmsaetze(java.util.Date start, java.util.Date end) throws RemoteException {
        DBIterator list = UmsatzUtil.getUmsaetzeBackwards();
        list.addFilter("konto_id = " + this.getID());
        if (start != null) {
            list.addFilter("datum >= ?", new Object[]{new Date(DateUtil.startOfDay((java.util.Date)start).getTime())});
        }
        if (end != null) {
            list.addFilter("datum <= ?", new Object[]{new Date(DateUtil.endOfDay((java.util.Date)end).getTime())});
        }
        return list;
    }

    @Override
    public DBIterator getUeberweisungen() throws RemoteException {
        HBCIDBService service = (HBCIDBService)this.getService();
        DBIterator list = service.createList(Ueberweisung.class);
        list.addFilter("konto_id = " + this.getID());
        list.setOrder("ORDER BY " + service.getSQLTimestamp("termin") + " DESC");
        return list;
    }

    @Override
    public DBIterator getUmsatzTypen() throws RemoteException {
        HBCIDBService service = (HBCIDBService)this.getService();
        DBIterator list = service.createList(UmsatzTyp.class);
        list.addFilter("konto_id = " + this.getID());
        list.setOrder("ORDER BY COALESCE(nummer,''),name");
        return list;
    }

    @Override
    public DBIterator getAuslandsUeberweisungen() throws RemoteException {
        HBCIDBService service = (HBCIDBService)this.getService();
        DBIterator list = service.createList(AuslandsUeberweisung.class);
        list.addFilter("konto_id = " + this.getID());
        list.setOrder("ORDER BY " + service.getSQLTimestamp("termin") + " DESC");
        return list;
    }

    @Override
    public DBIterator getSepaLastschriften() throws RemoteException {
        HBCIDBService service = (HBCIDBService)this.getService();
        DBIterator list = service.createList(SepaLastschrift.class);
        list.addFilter("konto_id = " + this.getID());
        list.setOrder("ORDER BY " + service.getSQLTimestamp("termin") + " DESC");
        return list;
    }

    @Override
    public DBIterator getSepaSammelLastschriften() throws RemoteException {
        DBIterator list = this.getService().createList(SepaSammelLastschrift.class);
        list.addFilter("konto_id = " + this.getID());
        return list;
    }

    @Override
    public DBIterator getSepaSammelUeberweisungen() throws RemoteException {
        DBIterator list = this.getService().createList(SepaSammelUeberweisung.class);
        list.addFilter("konto_id = " + this.getID());
        return list;
    }

    @Override
    public DBIterator getDauerauftraege() throws RemoteException {
        DBIterator list = this.getService().createList(Dauerauftrag.class);
        list.addFilter("konto_id = " + this.getID());
        return list;
    }

    @Override
    public DBIterator getSepaDauerauftraege() throws RemoteException {
        DBIterator list = this.getService().createList(SepaDauerauftrag.class);
        list.addFilter("konto_id = " + this.getID());
        return list;
    }

    @Override
    public DBIterator getLastschriften() throws RemoteException {
        DBIterator list = this.getService().createList(Lastschrift.class);
        list.addFilter("konto_id = " + this.getID());
        return list;
    }

    @Override
    public DBIterator getSammelLastschriften() throws RemoteException {
        DBIterator list = this.getService().createList(SammelLastschrift.class);
        list.addFilter("konto_id = " + this.getID());
        return list;
    }

    @Override
    public DBIterator getSammelUeberweisungen() throws RemoteException {
        DBIterator list = this.getService().createList(SammelUeberweisung.class);
        list.addFilter("konto_id = " + this.getID());
        return list;
    }

    @Override
    public DBIterator getKontoauszuege() throws RemoteException {
        DBIterator list = this.getService().createList(Kontoauszug.class);
        list.addFilter("konto_id = " + this.getID());
        return list;
    }

    @Override
    public String getBezeichnung() throws RemoteException {
        return (String)this.getAttribute("bezeichnung");
    }

    @Override
    public void setBezeichnung(String bezeichnung) throws RemoteException {
        this.setAttribute("bezeichnung", bezeichnung);
    }

    @Override
    public DBIterator getProtokolle() throws RemoteException {
        HBCIDBService service = (HBCIDBService)this.getService();
        DBIterator list = service.createList(Protokoll.class);
        list.addFilter("konto_id = " + this.getID());
        list.setOrder("ORDER BY " + service.getSQLTimestamp("datum") + " DESC");
        return list;
    }

    public void insert() throws RemoteException, ApplicationException {
        super.insert();
        this.addToProtokoll(i18n.tr("Konto angelegt"), 1);
    }

    @Override
    public void store() throws RemoteException, ApplicationException {
        if (this.hasChanged()) {
            this.addToProtokoll(i18n.tr("Konto-Eigenschaften aktualisiert"), 1);
        }
        super.store();
        Cache.clear(Konto.class);
    }

    @Override
    public final void addToProtokoll(String kommentar, int protokollTyp) throws RemoteException {
        if (kommentar == null || kommentar.length() == 0 || this.getID() == null) {
            return;
        }
        try {
            Protokoll entry = (Protokoll)this.getService().createObject(Protokoll.class, null);
            entry.setKonto(this);
            entry.setKommentar(kommentar);
            entry.setTyp(protokollTyp);
            entry.store();
        }
        catch (Exception e) {
            Logger.error((String)"error while writing protocol", (Throwable)e);
        }
    }

    public Object getAttribute(String arg0) throws RemoteException {
        if ("numumsaetze".equals(arg0)) {
            return this.getNumUmsaetze();
        }
        boolean extralong = "extralongname".equals(arg0);
        if ("longname".equals(arg0) || extralong) {
            String bez = this.getBezeichnung();
            String blz = this.getBLZ();
            String kto = this.getKontonummer();
            String iban = this.getIban();
            String bic = this.getBic();
            boolean haveBic = bic != null && bic.length() > 0;
            boolean haveIban = iban != null && iban.length() > 0;
            String name = null;
            try {
                name = HBCIProperties.getNameForBank(haveBic ? bic : blz);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (name == null) {
                String string = name = haveBic ? String.valueOf(i18n.tr("BIC")) + ": " + bic : String.valueOf(i18n.tr("BLZ")) + ": " + blz;
            }
            if (haveIban) {
                kto = extralong ? HBCIProperties.formatIban(iban) : StringUtils.abbreviateMiddle((String)iban, (String)"..", (int)14);
            }
            String k = i18n.tr(haveIban ? "IBAN" : "Kto.");
            if (bez != null && bez.length() > 0) {
                return String.valueOf(bez) + ", " + k + " " + kto + " [" + name + "]";
            }
            return String.valueOf(k) + " " + kto + " [" + name + "]";
        }
        return super.getAttribute(arg0);
    }

    @Override
    public long getChecksum() throws RemoteException {
        String s = String.valueOf(this.getBLZ()) + this.getKontonummer() + this.getKundennummer() + this.getUnterkonto();
        CRC32 crc = new CRC32();
        crc.update(s.getBytes());
        return crc.getValue();
    }

    @Override
    public void setSaldo(double saldo) throws RemoteException {
        this.setAttribute("saldo", Double.isNaN(saldo) ? null : Double.valueOf(saldo));
        this.setAttribute("saldo_datum", new java.util.Date());
    }

    @Override
    public void setSaldoAvailable(double saldo) throws RemoteException {
        this.setAttribute("saldo_available", Double.isNaN(saldo) ? null : Double.valueOf(saldo));
    }

    @Override
    public int getNumUmsaetze() throws RemoteException {
        ResultSetExtractor rs;
        if (this.isNewObject()) {
            return 0;
        }
        String sql = "select count(id) from umsatz where konto_id = " + this.getID();
        HBCIDBService service = (HBCIDBService)this.getService();
        Integer i = (Integer)service.execute(sql, new Object[0], rs = new ResultSetExtractor(){

            public Object extract(ResultSet rs) throws RemoteException, SQLException {
                if (rs.next()) {
                    return rs.getInt(1);
                }
                return 0;
            }
        });
        return i == null ? 0 : i;
    }

    @Override
    public String getLongName() throws RemoteException {
        return (String)this.getAttribute("longname");
    }

    @Override
    public String getUnterkonto() throws RemoteException {
        return (String)this.getAttribute("unterkonto");
    }

    @Override
    public void setUnterkonto(String unterkonto) throws RemoteException {
        this.setAttribute("unterkonto", unterkonto);
    }

    @Override
    public String getKommentar() throws RemoteException {
        return (String)this.getAttribute("kommentar");
    }

    @Override
    public void setKommentar(String kommentar) throws RemoteException {
        this.setAttribute("kommentar", kommentar);
    }

    @Override
    public int getFlags() throws RemoteException {
        Integer i = (Integer)this.getAttribute("flags");
        return i == null ? 0 : i;
    }

    @Override
    public boolean hasFlag(int flag) throws RemoteException {
        return (this.getFlags() & flag) == flag;
    }

    @Override
    public void setFlags(int flags) throws RemoteException {
        if (flags < 0) {
            return;
        }
        this.setAttribute("flags", flags);
    }

    @Override
    public String getBic() throws RemoteException {
        return (String)this.getAttribute("bic");
    }

    @Override
    public void setBic(String bic) throws RemoteException {
        this.setAttribute("bic", bic);
    }

    @Override
    public String getIban() throws RemoteException {
        return (String)this.getAttribute("iban");
    }

    @Override
    public void setIban(String iban) throws RemoteException {
        this.setAttribute("iban", iban);
    }

    @Override
    public String getKategorie() throws RemoteException {
        return (String)this.getAttribute("kategorie");
    }

    @Override
    public void setKategorie(String kategorie) throws RemoteException {
        this.setAttribute("kategorie", kategorie);
    }
}

