/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.datasource.rmi.ResultSetExtractor;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.dialogs.CamtSetupDialog;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.server.BPDUtil;
import de.willuhn.jameica.hbci.server.UmsatzUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.TypedProperties;
import java.rmi.RemoteException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class KontoUtil {
    public static Konto find(String kontonummer, String blz) throws RemoteException {
        return KontoUtil.find(kontonummer, blz, -1);
    }

    public static Konto find(String kontonummer, String blz, int flag) throws RemoteException {
        if (kontonummer == null || kontonummer.length() == 0) {
            return null;
        }
        if (blz == null || blz.length() == 0) {
            return null;
        }
        if (kontonummer.startsWith("0")) {
            kontonummer = kontonummer.replaceAll("^0{1,}", "");
        }
        if (kontonummer.length() == 0) {
            return null;
        }
        HBCIDBService service = Settings.getDBService();
        DBIterator konten = service.createList(Konto.class);
        konten.addFilter("kontonummer like ?", new Object[]{"%" + kontonummer});
        konten.addFilter("blz = ?", new Object[]{blz});
        while (konten.hasNext()) {
            Konto konto = (Konto)konten.next();
            if (flag != 0 ? flag > 0 && !konto.hasFlag(flag) : konto.getFlags() != 0) continue;
            String kTest = konto.getKontonummer();
            if (kTest == null || kTest.length() == 0) continue;
            if (kTest.startsWith("0")) {
                kTest = kTest.replaceAll("^0{1,}", "");
            }
            if (!kTest.equals(kontonummer)) continue;
            return konto;
        }
        return null;
    }

    public static boolean useCamt(Konto k, boolean ask) {
        block14: {
            block13: {
                block12: {
                    block11: {
                        BPDUtil.Support support;
                        block10: {
                            if (k == null) {
                                Logger.warn((String)"unable to check if CAMT is supported, no account given");
                                return false;
                            }
                            Logger.debug((String)"checking if account supports CAMT");
                            support = BPDUtil.getSupport(k, BPDUtil.Query.UmsatzCamt);
                            if (support != null) break block10;
                            Logger.debug((String)"unable to determine CAMT support");
                            return false;
                        }
                        if (support.isSupported()) break block11;
                        Logger.debug((String)"account does not support CAMT");
                        return false;
                    }
                    String value = StringUtils.trimToNull((String)MetaKey.UMSATZ_CAMT.get(k));
                    if (value != null) {
                        Logger.debug((String)("CAMT usage configured as: " + value));
                        return Boolean.valueOf(value);
                    }
                    if (k.getNumUmsaetze() != 0) break block12;
                    Logger.debug((String)"account does not have bookings yet, auto-activating CAMT");
                    MetaKey.UMSATZ_CAMT.set(k, Boolean.TRUE.toString());
                    return true;
                }
                if (ask) break block13;
                Logger.debug((String)"CAMT support available but not yet activated");
                return false;
            }
            if (!Application.inServerMode()) break block14;
            Logger.debug((String)"running in server mode, user cannot be asked if CAMT shall be used");
            return false;
        }
        try {
            Logger.debug((String)"asking user if CAMT shall be used");
            CamtSetupDialog d = new CamtSetupDialog(k);
            Boolean b = (Boolean)d.open();
            Logger.debug((String)("user answered for CAMT: " + b));
            return b != null ? b : false;
        }
        catch (OperationCanceledException oce) {
            Logger.debug((String)"operation cancelled");
            return false;
        }
        catch (Exception e) {
            Logger.error((String)"unable to check if account supports CAMT", (Throwable)e);
            return false;
        }
    }

    public static int getUmsaetzeTimeRange(Konto k, boolean askForCamtIfPossible) {
        TypedProperties bpd;
        if (k == null) {
            Logger.warn((String)"unable to get time range from BPD, no account given");
            return -1;
        }
        boolean usingCamt = KontoUtil.useCamt(k, askForCamtIfPossible);
        BPDUtil.Support support = BPDUtil.getSupport(k, usingCamt ? BPDUtil.Query.UmsatzCamt : BPDUtil.Query.Umsatz);
        TypedProperties typedProperties = bpd = support != null && support.isSupported() ? support.getBpd() : null;
        if (bpd == null) {
            Logger.debug((String)"unable to get BPD");
            return 0;
        }
        int timeRange = bpd.getInt("timerange", 0);
        if (timeRange > 0) {
            Logger.debug((String)("time range from BPD for " + (usingCamt ? "KUmsZeitCamt" : "KUmsZeit") + ": " + timeRange));
        }
        return timeRange;
    }

    public static Konto findByIBAN(String iban) throws RemoteException {
        return KontoUtil.findByIBAN(iban, -1);
    }

    public static Konto findByIBAN(String iban, int flag) throws RemoteException {
        if ((iban = StringUtils.trimToNull((String)iban)) == null) {
            return null;
        }
        HBCIDBService service = Settings.getDBService();
        DBIterator konten = service.createList(Konto.class);
        konten.addFilter("lower(iban) = ?", new Object[]{iban.toLowerCase()});
        while (konten.hasNext()) {
            Konto konto = (Konto)konten.next();
            if (flag == 0 ? konto.getFlags() != 0 : flag > 0 && !konto.hasFlag(flag)) continue;
            return konto;
        }
        return null;
    }

    public static double getAnfangsSaldo(Konto konto, java.util.Date datum) throws RemoteException {
        Umsatz u;
        Date start = datum != null ? new Date(DateUtil.startOfDay((java.util.Date)datum).getTime()) : null;
        DBIterator list = UmsatzUtil.getUmsaetze();
        list.addFilter("konto_id = " + konto.getID());
        if (start != null) {
            list.addFilter("datum >= ?", new Object[]{start});
        }
        while (list.hasNext()) {
            u = (Umsatz)list.next();
            if (u.hasFlag(2)) continue;
            return u.getSaldo() - u.getBetrag();
        }
        list = UmsatzUtil.getUmsaetzeBackwards();
        list.addFilter("konto_id = " + konto.getID());
        if (start != null) {
            list.addFilter("datum < ?", new Object[]{start});
        }
        while (list.hasNext()) {
            u = (Umsatz)list.next();
            if (u.hasFlag(2)) continue;
            return u.getSaldo();
        }
        return konto.getSaldo();
    }

    public static double getEndSaldo(Konto konto, java.util.Date datum) throws RemoteException {
        Umsatz u;
        Date end = datum != null ? new Date(DateUtil.endOfDay((java.util.Date)datum).getTime()) : null;
        DBIterator list = UmsatzUtil.getUmsaetzeBackwards();
        list.addFilter("konto_id = " + konto.getID());
        if (end != null) {
            list.addFilter("datum <= ?", new Object[]{end});
        }
        while (list.hasNext()) {
            u = (Umsatz)list.next();
            if (u.hasFlag(2)) continue;
            return u.getSaldo();
        }
        list = UmsatzUtil.getUmsaetze();
        list.addFilter("konto_id = " + konto.getID());
        if (end != null) {
            list.addFilter("datum > ?", new Object[]{end});
        }
        while (list.hasNext()) {
            u = (Umsatz)list.next();
            if (u.hasFlag(2)) continue;
            return u.getSaldo() - u.getBetrag();
        }
        return konto.getSaldo();
    }

    public static double getAusgaben(Konto konto, java.util.Date from, java.util.Date to, boolean onlyBooked) throws RemoteException {
        return KontoUtil.getSumme(konto, from, to, true, onlyBooked);
    }

    public static double getEinnahmen(Konto konto, java.util.Date from, java.util.Date to, boolean onlyBooked) throws RemoteException {
        return KontoUtil.getSumme(konto, from, to, false, onlyBooked);
    }

    public static List<String> getGroups() throws RemoteException {
        return (List)Settings.getDBService().execute("select kategorie from konto where kategorie is not null and kategorie != '' group by kategorie order by LOWER(kategorie)", null, new ResultSetExtractor(){

            public Object extract(ResultSet rs) throws RemoteException, SQLException {
                ArrayList<String> list = new ArrayList<String>();
                while (rs.next()) {
                    list.add(rs.getString(1));
                }
                return list;
            }
        });
    }

    private static double getSumme(Konto konto, java.util.Date from, java.util.Date to, boolean ausgaben, boolean onlyBooked) throws RemoteException {
        if (konto.isNewObject()) {
            return 0.0;
        }
        ArrayList<Date> params = new ArrayList<Date>();
        String sql = "select SUM(betrag) from umsatz where konto_id = " + konto.getID() + " and betrag " + (ausgaben ? "<" : ">") + " 0";
        if (onlyBooked) {
            sql = String.valueOf(sql) + " and (flags is null or flags < 2)";
        }
        if (from != null) {
            params.add(new Date(DateUtil.startOfDay((java.util.Date)from).getTime()));
            sql = String.valueOf(sql) + " and datum >= ? ";
        }
        if (to != null) {
            params.add(new Date(DateUtil.startOfDay((java.util.Date)to).getTime()));
            sql = String.valueOf(sql) + " and datum <= ? ";
        }
        HBCIDBService service = Settings.getDBService();
        ResultSetExtractor rs = new ResultSetExtractor(){

            public Object extract(ResultSet rs) throws RemoteException, SQLException {
                if (rs.next()) {
                    return rs.getDouble(1);
                }
                return 0.0;
            }
        };
        Double d = (Double)service.execute(sql, params.toArray(), rs);
        return d == null ? 0.0 : Math.abs(d);
    }

    public static List<Konto> getKonten(KontoFilter filter) throws RemoteException {
        DBIterator it = Settings.getDBService().createList(Konto.class);
        it.setOrder("ORDER BY LOWER(kategorie), blz, kontonummer, bezeichnung");
        ArrayList<Konto> l = new ArrayList<Konto>();
        while (it.hasNext()) {
            Konto k = (Konto)it.next();
            if (filter != null && !filter.accept(k)) continue;
            l.add(k);
        }
        return l;
    }

    public static String toString(Konto k) {
        try {
            return k != null ? (String)k.getAttribute("extralongname") : "";
        }
        catch (RemoteException re) {
            Logger.error((String)"cannot format account name", (Throwable)re);
            return "";
        }
    }
}

