/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.io.FileCopy;
import de.willuhn.io.IOUtil;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.messaging.MessagingAvailableConsumer;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.messaging.ObjectDeletedMessage;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Kontoauszug;
import de.willuhn.jameica.hbci.server.BPDUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.VelocityService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.TypedProperties;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.kapott.hbci.GV_Result.GVRKontoauszug;

public class KontoauszugPdfUtil {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final String CHANNEL = "hibiscus.kontoauszuege";

    public static File getFile(Kontoauszug ka) throws ApplicationException {
        if (ka == null) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie den zu \u00f6ffnenden Kontoauszug"));
        }
        try {
            String path = StringUtils.trimToNull((String)ka.getPfad());
            String name = StringUtils.trimToNull((String)ka.getDateiname());
            if (path != null && name != null) {
                File file = new File(path, name);
                Logger.info((String)("trying to open pdf file from: " + file));
                if (!file.exists()) {
                    Logger.error((String)("file does not exist (anymore): " + file));
                    throw new ApplicationException(i18n.tr("Datei \"{0}\" existiert nicht mehr. Wurde sie gel\u00f6scht?", file.getAbsolutePath()));
                }
                if (!file.canRead()) {
                    Logger.error((String)("cannot read file: " + file));
                    throw new ApplicationException(i18n.tr("Datei \"{0}\" nicht lesbar", file.getAbsolutePath()));
                }
                return file;
            }
            String uuid = StringUtils.trimToNull((String)ka.getUUID());
            Logger.info((String)("trying to open pdf file using messaging, uuid: " + uuid));
            if (uuid == null) {
                throw new ApplicationException(i18n.tr("Ablageort des Kontoauszuges unbekannt"));
            }
            QueryMessage qm = new QueryMessage(uuid, null);
            Application.getMessagingFactory().getMessagingQueue("jameica.messaging.get").sendSyncMessage((Message)qm);
            byte[] data = (byte[])qm.getData();
            if (data == null) {
                Logger.error((String)("got no data from messaging for uuid: " + uuid));
                throw new ApplicationException(i18n.tr("Datei existiert nicht mehr im Archiv. Wurde sie gel\u00f6scht?"));
            }
            Logger.info((String)("got " + data.length + " bytes from messaging for uuid: " + uuid));
            File file = File.createTempFile("kontoauszug-" + RandomStringUtils.randomAlphanumeric((int)5), ".pdf");
            file.deleteOnExit();
            BufferedOutputStream os = null;
            try {
                os = new BufferedOutputStream(new FileOutputStream(file));
                IOUtil.copy((InputStream)new ByteArrayInputStream(data), (OutputStream)os);
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{os});
                throw throwable;
            }
            IOUtil.close((Closeable[])new Closeable[]{os});
            Logger.info((String)("copied messaging data into temp file: " + file));
            return file;
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)"unable to open file", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim \u00d6ffnen des Kontoauszuges: {0}", e.getMessage()));
        }
    }

    public static void store(Kontoauszug ka, File target) throws ApplicationException {
        if (ka == null) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie den zu speichernden Kontoauszug"));
        }
        if (target == null) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie die Zieldatei aus"));
        }
        try {
            String path = StringUtils.trimToNull((String)ka.getPfad());
            String name = StringUtils.trimToNull((String)ka.getDateiname());
            if (path != null && name != null) {
                File file = new File(path, name);
                Logger.info((String)("trying to open pdf file from: " + file));
                if (!file.exists()) {
                    Logger.error((String)("file does not exist (anymore): " + file));
                    throw new ApplicationException(i18n.tr("Datei \"{0}\" existiert nicht mehr. Wurde sie gel\u00f6scht?", file.getAbsolutePath()));
                }
                if (!file.canRead()) {
                    Logger.error((String)("cannot read file: " + file));
                    throw new ApplicationException(i18n.tr("Datei \"{0}\" nicht lesbar", file.getAbsolutePath()));
                }
                FileCopy.copy((File)file, (File)target, (boolean)true);
                Logger.info((String)("copied " + file + " to " + target));
                return;
            }
            String uuid = StringUtils.trimToNull((String)ka.getUUID());
            Logger.info((String)("trying to open pdf file using messaging, uuid: " + uuid));
            if (uuid == null) {
                throw new ApplicationException(i18n.tr("Ablageort des Kontoauszuges unbekannt"));
            }
            QueryMessage qm = new QueryMessage(uuid, null);
            Application.getMessagingFactory().getMessagingQueue("jameica.messaging.get").sendSyncMessage((Message)qm);
            byte[] data = (byte[])qm.getData();
            if (data == null) {
                Logger.error((String)("got no data from messaging for uuid: " + uuid));
                throw new ApplicationException(i18n.tr("Datei existiert nicht mehr im Archiv. Wurde sie gel\u00f6scht?"));
            }
            Logger.info((String)("got " + data.length + " bytes from messaging for uuid: " + uuid));
            BufferedOutputStream os = null;
            try {
                os = new BufferedOutputStream(new FileOutputStream(target));
                IOUtil.copy((InputStream)new ByteArrayInputStream(data), (OutputStream)os);
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{os});
                throw throwable;
            }
            IOUtil.close((Closeable[])new Closeable[]{os});
            Logger.info((String)("copied messaging data into file: " + target));
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)"unable to open file", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim \u00d6ffnen des Kontoauszuges: {0}", e.getMessage()));
        }
    }

    public static void receive(Kontoauszug k, byte[] data) throws RemoteException, ApplicationException {
        if (k == null) {
            throw new ApplicationException(i18n.tr("Kein Kontoauszug angegeben"));
        }
        if (data == null || data.length == 0) {
            throw new ApplicationException(i18n.tr("Kein Daten angegeben"));
        }
        Konto konto = k.getKonto();
        if (konto == null) {
            throw new ApplicationException(i18n.tr("Kein Konto angegeben"));
        }
        if (MessagingAvailableConsumer.haveMessaging() && Boolean.parseBoolean(MetaKey.KONTOAUSZUG_STORE_MESSAGING.get(konto))) {
            QueryMessage qm = new QueryMessage(CHANNEL, (Object)data);
            Application.getMessagingFactory().getMessagingQueue("jameica.messaging.put").sendSyncMessage((Message)qm);
            k.setUUID(qm.getData().toString());
            k.store();
            Logger.info((String)("stored account statement data in messaging archive [id: " + k.getID() + ", uuid: " + k.getUUID() + "]"));
            return;
        }
        String path = KontoauszugPdfUtil.createPath(konto, k);
        try {
            File file = new File(path).getCanonicalFile();
            Logger.info((String)("storing account statement data in file [id: " + k.getID() + ", file: " + file + "]"));
            File dir = file.getParentFile();
            if (!dir.exists()) {
                Logger.info((String)("auto-creating parent dir: " + dir));
                if (!dir.mkdirs()) {
                    throw new ApplicationException(i18n.tr("Erstellen des Ordners fehlgeschlagen. Ordner-Berechtigungen korrekt?"));
                }
            }
            if (!dir.canWrite()) {
                throw new ApplicationException(i18n.tr("Kein Schreibzugriff in {0}", dir.toString()));
            }
            BufferedOutputStream os = null;
            try {
                File target = file;
                int i = 0;
                while (i < 10000) {
                    if (!target.exists()) break;
                    target = KontoauszugPdfUtil.indexedFile(file, ++i);
                }
                os = new BufferedOutputStream(new FileOutputStream(target));
                ((OutputStream)os).write(data);
                k.setPfad(target.getParent());
                k.setDateiname(target.getName());
                k.store();
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{os});
                throw throwable;
            }
            IOUtil.close((Closeable[])new Closeable[]{os});
        }
        catch (IOException e) {
            Logger.error((String)("unable to store account statement data in file: " + path), (Throwable)e);
            throw new ApplicationException(i18n.tr("Speichern des Kontoauszuges fehlgeschlagen: {0}", e.getMessage()));
        }
    }

    private static File indexedFile(File f, int i) {
        String name = f.getName();
        int dot = name.lastIndexOf(46);
        name = String.valueOf(name.substring(0, dot)) + "-" + String.format("%05d", i) + name.substring(dot);
        return new File(f.getParentFile(), name);
    }

    public static String createPath(Konto k, Kontoauszug ka) throws RemoteException, ApplicationException {
        if (k == null) {
            throw new ApplicationException(i18n.tr("Kein Konto angegeben"));
        }
        String path = MetaKey.KONTOAUSZUG_STORE_PATH.get(k);
        String folder = MetaKey.KONTOAUSZUG_TEMPLATE_PATH.get(k);
        String name = MetaKey.KONTOAUSZUG_TEMPLATE_NAME.get(k);
        return KontoauszugPdfUtil.createPath(k, ka, path, folder, name);
    }

    public static boolean testPath(Konto k, String folder, String name) throws RemoteException, ApplicationException {
        String s = KontoauszugPdfUtil.createPath(k, null, null, folder, name, true);
        return !s.contains("{") && !s.contains("}") && !s.contains("$");
    }

    public static String createPath(Konto k, Kontoauszug ka, String path, String folder, String name) throws RemoteException, ApplicationException {
        return KontoauszugPdfUtil.createPath(k, ka, path, folder, name, false);
    }

    private static String createPath(Konto k, Kontoauszug ka, String path, String folder, String name, boolean test) throws RemoteException, ApplicationException {
        if (k == null) {
            throw new ApplicationException(i18n.tr("Kein Konto angegeben"));
        }
        HashMap<String, String> ctx = new HashMap<String, String>();
        String iban = StringUtils.trimToNull((String)k.getIban());
        if (iban == null) {
            iban = StringUtils.trimToEmpty((String)k.getKontonummer());
        }
        ctx.put("iban", iban.replaceAll(" ", ""));
        String bic = StringUtils.trimToNull((String)k.getBic());
        if (bic == null) {
            bic = StringUtils.trimToEmpty((String)k.getBLZ());
        }
        ctx.put("bic", bic.replaceAll(" ", ""));
        Calendar cal = Calendar.getInstance();
        if (ka != null) {
            if (ka.getErstellungsdatum() != null) {
                cal.setTime(ka.getErstellungsdatum());
            } else if (ka.getAusfuehrungsdatum() != null) {
                cal.setTime(ka.getAusfuehrungsdatum());
            }
        }
        Integer i = ka != null && ka.getJahr() != null ? ka.getJahr() : null;
        ctx.put("jahr", i != null ? i.toString() : Integer.toString(cal.get(1)));
        ctx.put("monat", String.format("%02d", cal.get(2) + 1));
        ctx.put("tag", String.format("%02d", cal.get(5)));
        ctx.put("stunde", String.format("%02d", cal.get(11)));
        ctx.put("minute", String.format("%02d", cal.get(12)));
        Integer i2 = ka != null && ka.getNummer() != null ? ka.getNummer() : null;
        ctx.put("nummer", String.format("%03d", i2 != null ? i2 : 1));
        VelocityService velocity = (VelocityService)Application.getBootLoader().getBootable(VelocityService.class);
        StringBuilder sb = new StringBuilder();
        if (!test) {
            if (path == null || path.length() == 0) {
                path = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getWorkPath();
            }
            sb.append(path);
            if (!path.endsWith(File.separator)) {
                sb.append(File.separator);
            }
        }
        if (folder != null && folder.length() > 0) {
            try {
                folder = folder.replace("\\$", "\\\\$");
                folder = velocity.merge(folder, ctx);
            }
            catch (Exception e) {
                Logger.error((String)("folder template invalid: \"" + folder + "\""), (Throwable)e);
            }
            sb.append(folder);
            if (!folder.endsWith(File.separator)) {
                sb.append(File.separator);
            }
        }
        if (name == null || name.length() == 0 && ka != null) {
            name = ka.getDateiname();
        }
        if (name == null || name.length() == 0) {
            name = MetaKey.KONTOAUSZUG_TEMPLATE_NAME.getDefault();
        }
        try {
            name = velocity.merge(name, ctx);
        }
        catch (Exception e) {
            Logger.error((String)("name template invalid: \"" + name + "\""), (Throwable)e);
        }
        sb.append(name);
        GVRKontoauszug.Format f = GVRKontoauszug.Format.find((String)(ka != null ? ka.getFormat() : null));
        if (f == null) {
            f = GVRKontoauszug.Format.PDF;
        }
        sb.append(".");
        sb.append(f.getExtention());
        return sb.toString();
    }

    public static GenericIterator<Kontoauszug> getUnread() throws RemoteException {
        HBCIDBService service = Settings.getDBService();
        DBIterator it = service.createList(Kontoauszug.class);
        it.addFilter("gelesen_am is null");
        it.setOrder("order by " + service.getSQLTimestamp("erstellungsdatum") + " desc");
        return it;
    }

    public static GenericIterator<Kontoauszug> getList(Object konto, java.util.Date from, java.util.Date to, boolean unread, boolean inclusive) throws RemoteException {
        Date t;
        HBCIDBService service = Settings.getDBService();
        DBIterator it = service.createList(Kontoauszug.class);
        boolean haveFrom = from != null;
        boolean haveTo = to != null;
        Date f = haveFrom ? new Date(DateUtil.startOfDay((java.util.Date)from).getTime()) : null;
        Date date = t = haveTo ? new Date(DateUtil.endOfDay((java.util.Date)to).getTime()) : null;
        if (inclusive && (haveFrom || haveTo)) {
            if (haveFrom && haveTo) {
                it.addFilter("((von >= ? AND von <= ?) OR (bis >= ? AND bis <= ?) OR (von <= ? AND bis >= ?) OR (erstellungsdatum >= ? AND erstellungsdatum <= ?) OR (von IS NULL AND bis IS NULL AND erstellungsdatum IS NULL AND ausgefuehrt_am >= ? AND ausgefuehrt_am <= ?))", new Object[]{f, t, f, t, f, t, f, t, f, t});
            } else if (haveFrom) {
                it.addFilter("((bis >= ? OR erstellungsdatum >= ?) OR (bis IS NULL AND erstellungsdatum IS NULL AND ausgefuehrt_am >= ?))", new Object[]{f, f, f});
            } else if (haveTo) {
                it.addFilter("((von <= ? OR erstellungsdatum <= ?) OR (bis IS NULL AND erstellungsdatum IS NULL AND ausgefuehrt_am <= ?))", new Object[]{t, t, t});
            }
        } else {
            if (haveFrom) {
                it.addFilter("(von >= ? OR erstellungsdatum >= ? OR (von IS NULL AND erstellungsdatum IS NULL AND ausgefuehrt_am >= ?))", new Object[]{f, f, f});
            }
            if (haveTo) {
                it.addFilter("(bis <= ? OR erstellungsdatum <= ? OR (bis IS NULL AND erstellungsdatum IS NULL AND ausgefuehrt_am <= ?))", new Object[]{t, t, t});
            }
        }
        if (konto != null && konto instanceof Konto) {
            it.addFilter("konto_id = " + ((Konto)konto).getID());
        } else if (konto != null && konto instanceof String) {
            it.addFilter("konto_id in (select id from konto where kategorie = ?)", new Object[]{(String)konto});
        }
        if (unread) {
            it.addFilter("gelesen_am is null");
        }
        it.setOrder("order by jahr desc, nummer desc, " + service.getSQLTimestamp("erstellungsdatum") + " desc, " + service.getSQLTimestamp("von") + " desc, " + service.getSQLTimestamp("ausgefuehrt_am") + " desc");
        return it;
    }

    public static Kontoauszug getNewestWithNumber(Konto k) throws RemoteException {
        HBCIDBService service = Settings.getDBService();
        DBIterator it = service.createList(Kontoauszug.class);
        it.addFilter("konto_id = " + k.getID());
        it.addFilter("nummer is not null");
        it.setOrder("order by jahr desc, nummer desc, " + service.getSQLTimestamp("erstellungsdatum") + " desc, " + service.getSQLTimestamp("von") + " desc, " + service.getSQLTimestamp("ausgefuehrt_am") + " desc");
        return it.hasNext() ? (Kontoauszug)it.next() : null;
    }

    public static void delete(boolean deleteFiles, Kontoauszug ... list) {
        block18: {
            if (list == null || list.length == 0) {
                return;
            }
            Kontoauszug tx = null;
            int count = 0;
            try {
                Kontoauszug[] kontoauszugArray = list;
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    Kontoauszug k = kontoauszugArray[n2];
                    if (tx == null) {
                        tx = k;
                        tx.transactionBegin();
                    }
                    if (deleteFiles) {
                        String uuid = k.getUUID();
                        if (uuid != null && uuid.length() > 0) {
                            QueryMessage qm = new QueryMessage(uuid, null);
                            Application.getMessagingFactory().getMessagingQueue("jameica.messaging.del").sendSyncMessage((Message)qm);
                        } else {
                            String pfad = k.getPfad();
                            String name = k.getDateiname();
                            if (pfad == null || pfad.length() == 0 || name == null || name.length() == 0) {
                                Logger.warn((String)"filename or path missing for account statements, skipping");
                            } else {
                                File file = new File(pfad, name);
                                if (file.exists() && file.canWrite()) {
                                    if (!file.delete()) {
                                        Logger.warn((String)("deleting of file failed: " + file));
                                    }
                                } else {
                                    Logger.info((String)("file does not exist, skipping: " + file));
                                }
                            }
                        }
                    }
                    Konto konto = k.getKonto();
                    konto.addToProtokoll(i18n.tr("Elektronischen Kontoauszug gel\u00f6scht"), 1);
                    String id = k.getID();
                    k.delete();
                    Application.getMessagingFactory().sendMessage((Message)new ObjectDeletedMessage((GenericObject)k, id));
                    ++count;
                    ++n2;
                }
                if (tx != null) {
                    tx.transactionCommit();
                }
                if (count == 1) {
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Kontoauszug gel\u00f6scht."), 0));
                } else {
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("{0} Kontoausz\u00fcge gel\u00f6scht.", Integer.toString(count)), 0));
                }
            }
            catch (Exception e) {
                Logger.error((String)"deleting account statements failed", (Throwable)e);
                if (tx == null) break block18;
                try {
                    tx.transactionRollback();
                }
                catch (RemoteException re) {
                    Logger.error((String)"tx rollback failed", (Throwable)re);
                }
            }
        }
    }

    public static void markRead(boolean read, Kontoauszug ... list) {
        block13: {
            if (list == null || list.length == 0) {
                return;
            }
            Kontoauszug tx = null;
            try {
                Kontoauszug[] kontoauszugArray = list;
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    Kontoauszug k = kontoauszugArray[n2];
                    if (!k.isNewObject()) {
                        java.util.Date d;
                        if (tx == null) {
                            tx = k;
                            tx.transactionBegin();
                        }
                        if ((d = k.getGelesenAm()) == null && !read) {
                            Logger.info((String)("account statement already marked as unread, skipping [id: " + k.getID() + "]"));
                        } else if (d != null && read) {
                            Logger.info((String)("account statement already marked as read, skipping [id: " + k.getID() + ", date: " + d + "]"));
                        } else {
                            d = read ? new java.util.Date() : null;
                            Logger.info((String)("mark account statements as " + (read ? "read" : "unread") + " [id: " + k.getID() + ", date: " + d + "]"));
                            k.setGelesenAm(d);
                            k.store();
                            Application.getMessagingFactory().sendMessage((Message)new ObjectChangedMessage((GenericObject)k));
                        }
                    }
                    ++n2;
                }
                if (tx != null) {
                    tx.transactionCommit();
                }
            }
            catch (Exception e) {
                Logger.error((String)"marking account statements as read failed", (Throwable)e);
                if (tx == null) break block13;
                try {
                    tx.transactionRollback();
                }
                catch (RemoteException re) {
                    Logger.error((String)"tx rollback failed", (Throwable)re);
                }
            }
        }
    }

    public static boolean supported(Konto k) {
        if (k == null) {
            Logger.warn((String)"no account given");
            return false;
        }
        try {
            Logger.debug((String)("checking HKEKP/HKEKA support for account: " + (k != null ? k.getIban() : "<none>")));
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to determine iban");
        }
        BPDUtil.Support support = BPDUtil.getSupport(k, BPDUtil.Query.KontoauszugPdf);
        if (support != null && support.isSupported()) {
            Logger.debug((String)"HKEKP supported");
            return true;
        }
        boolean ignoreSupport = false;
        try {
            ignoreSupport = Boolean.parseBoolean(MetaKey.KONTOAUSZUG_IGNORE_FORMAT.get(k));
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to determine account meta key value", (Throwable)re);
        }
        support = BPDUtil.getSupport(k, BPDUtil.Query.Kontoauszug);
        if (support == null || !support.getBpdSupport()) {
            return KontoauszugPdfUtil.conditionalSupport("HKEKA not supported according to BPD", ignoreSupport);
        }
        if (!support.getUpdSupport()) {
            return KontoauszugPdfUtil.conditionalSupport("HKEKA not supported according to UPD", ignoreSupport);
        }
        TypedProperties props = support.getBpd();
        if (props == null || props.size() == 0) {
            return KontoauszugPdfUtil.conditionalSupport("no BPD cache data found for HKEKA", ignoreSupport);
        }
        List<GVRKontoauszug.Format> formats = KontoauszugPdfUtil.getFormats(props);
        if (formats.size() == 0) {
            return KontoauszugPdfUtil.conditionalSupport("BPD cache contains no information regarding supported formats of HKEKA", ignoreSupport);
        }
        if (formats.contains(GVRKontoauszug.Format.PDF)) {
            Logger.debug((String)"HKEKA with PDF supported");
            return true;
        }
        return KontoauszugPdfUtil.conditionalSupport("HKEKA does not support PDF according to BPD", ignoreSupport);
    }

    public static List<GVRKontoauszug.Format> getFormats(TypedProperties bpd) {
        String format;
        ArrayList<GVRKontoauszug.Format> result = new ArrayList<GVRKontoauszug.Format>();
        if (bpd == null || bpd.size() == 0) {
            return result;
        }
        String[] formats = bpd.getList("format", null);
        if ((formats == null || formats.length == 0) && (format = bpd.getProperty("format", null)) != null) {
            formats = new String[]{format};
        }
        if (formats == null || formats.length == 0) {
            return result;
        }
        String[] stringArray = formats;
        int n = formats.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            GVRKontoauszug.Format gf = GVRKontoauszug.Format.find((String)f);
            if (gf != null) {
                result.add(gf);
            }
            ++n2;
        }
        return result;
    }

    private static boolean conditionalSupport(String reason, boolean ignoreSupport) {
        Logger.debug((String)(String.valueOf(reason) + " - support forced: " + ignoreSupport));
        return ignoreSupport;
    }

    public static String toString(Kontoauszug k) throws RemoteException {
        if (k == null) {
            return "";
        }
        java.util.Date von = k.getVon();
        java.util.Date bis = k.getBis();
        if (von != null && bis != null) {
            return i18n.tr("Kontoauszug {0} - {1}", new String[]{HBCI.DATEFORMAT.format(von), HBCI.DATEFORMAT.format(bis)});
        }
        Integer jahr = k.getJahr();
        Integer nr = k.getNummer();
        if (jahr != null && nr != null) {
            return i18n.tr("Kontoauszug {0}/{1}", new String[]{jahr.toString(), nr.toString()});
        }
        java.util.Date erstellt = k.getErstellungsdatum();
        return i18n.tr("Kontoauszug vom {0}", HBCI.DATEFORMAT.format(erstellt != null ? erstellt : k.getAusfuehrungsdatum()));
    }
}

