/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.Nachricht;
import de.willuhn.jameica.hbci.server.AbstractHibiscusDBObject;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;

public class NachrichtImpl
extends AbstractHibiscusDBObject
implements Nachricht {
    private static final transient I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    protected String getTableName() {
        return "systemnachricht";
    }

    public String getPrimaryAttribute() throws RemoteException {
        return "nachricht";
    }

    protected void insertCheck() throws ApplicationException {
        try {
            if (this.getBLZ() == null || this.getBLZ().length() == 0) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie eine Bankleitzahl ein"));
            }
            if (this.getNachricht() == null || this.getNachricht().length() == 0) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie einen Nachrichtentext ein"));
            }
        }
        catch (RemoteException e) {
            Logger.error((String)"error while checking system message", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim Speichern der System-Nachricht"));
        }
    }

    protected void updateCheck() throws ApplicationException {
        this.insertCheck();
    }

    @Override
    public String getBLZ() throws RemoteException {
        return (String)this.getAttribute("blz");
    }

    @Override
    public Date getDatum() throws RemoteException {
        return (Date)this.getAttribute("datum");
    }

    @Override
    public boolean isGelesen() throws RemoteException {
        Integer i = (Integer)this.getAttribute("gelesen");
        if (i == null) {
            return false;
        }
        return i == 1;
    }

    @Override
    public String getNachricht() throws RemoteException {
        return (String)this.getAttribute("nachricht");
    }

    @Override
    public void setBLZ(String blz) throws RemoteException {
        this.setAttribute("blz", blz);
    }

    @Override
    public void setDatum(Date datum) throws RemoteException {
        this.setAttribute("datum", datum);
    }

    @Override
    public void setGelesen(boolean b) throws RemoteException {
        this.setAttribute("gelesen", b ? 1 : 0);
    }

    @Override
    public void setNachricht(String nachricht) throws RemoteException {
        this.setAttribute("nachricht", nachricht);
    }

    @Override
    public void store() throws RemoteException, ApplicationException {
        if (this.getDatum() == null) {
            this.setDatum(new Date());
        }
        if (this.getAttribute("gelesen") == null) {
            this.setGelesen(false);
        }
        super.store();
    }
}

