/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Protokoll;
import de.willuhn.jameica.hbci.server.AbstractHibiscusDBObject;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;

public class ProtokollImpl
extends AbstractHibiscusDBObject
implements Protokoll {
    private static final transient I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    protected String getTableName() {
        return "protokoll";
    }

    public String getPrimaryAttribute() throws RemoteException {
        return "kommentar";
    }

    @Override
    public void store() throws RemoteException, ApplicationException {
        String k = this.getKommentar();
        if (k != null && k.length() > 1000) {
            this.setKommentar(k.substring(0, 999));
        }
        super.store();
    }

    protected void insertCheck() throws ApplicationException {
        try {
            if (this.getKonto() == null) {
                throw new ApplicationException(i18n.tr("Konto fehlt."));
            }
            if (this.getKommentar() == null || this.getKommentar().length() == 0) {
                throw new ApplicationException(i18n.tr("Kommentar fehlt."));
            }
            this.setTyp(this.getTyp());
            if (this.getDatum() == null) {
                this.setAttribute("datum", new Date());
            }
        }
        catch (RemoteException e) {
            Logger.error((String)"error while insert check", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim Speichern des Umsatz-Typs."));
        }
    }

    protected void updateCheck() throws ApplicationException {
        throw new ApplicationException(i18n.tr("Protokoll-Daten d\u00fcrfen nicht ge\u00e4ndert werden."));
    }

    protected Class getForeignObject(String field) throws RemoteException {
        if ("konto_id".equals(field)) {
            return Konto.class;
        }
        return null;
    }

    @Override
    public Konto getKonto() throws RemoteException {
        return (Konto)this.getAttribute("konto_id");
    }

    @Override
    public String getKommentar() throws RemoteException {
        return (String)this.getAttribute("kommentar");
    }

    @Override
    public Date getDatum() throws RemoteException {
        return (Date)this.getAttribute("datum");
    }

    @Override
    public int getTyp() throws RemoteException {
        Integer i = (Integer)this.getAttribute("typ");
        if (i == null) {
            return 0;
        }
        return i;
    }

    @Override
    public void setKonto(Konto konto) throws RemoteException {
        this.setAttribute("konto_id", konto);
    }

    @Override
    public void setKommentar(String kommentar) throws RemoteException {
        this.setAttribute("kommentar", kommentar);
    }

    @Override
    public void setTyp(int typ) throws RemoteException {
        if (typ != 2 && typ != 1) {
            typ = 0;
        }
        this.setAttribute("typ", typ);
    }
}

