/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;

public abstract class Range {
    private static final transient I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final Settings settings = new Settings(Range.class);
    private static final Range ALL = new All();
    private static final Range D_7 = new LastSevenDays();
    private static final Range D_30 = new LastThirtyDays();
    private static final Range D_90 = new LastNinetyDays();
    private static final Range LY_1 = new Last365Days();
    private static final Range LY_3 = new Last3Years();
    private static final Range LY_5 = new Last5Years();
    private static final Range LY_10 = new Last10Years();
    private static final Range W_THIS = new ThisWeek();
    private static final Range W_LAST = new LastWeek();
    private static final Range W_2LAS = new SecondLastWeek();
    private static final Range M_THIS = new ThisMonth();
    private static final Range M_LAST = new LastMonth();
    private static final Range M_2LAS = new SecondLastMonth();
    private static final Range M_12 = new Last12Months();
    private static final Range Q_THIS = new ThisQuarter();
    private static final Range Q_LAST = new LastQuarter();
    private static final Range Q_2LAS = new SecondLastQuarter();
    private static final Range Y_THIS = new ThisYear();
    private static final Range Y_LAST = new LastYear();
    private static final Range Y_2LAS = new SecondLastYear();
    private static final List<Range> KNOWN = Arrays.asList(D_7, D_30, D_90, LY_1, LY_3, LY_5, LY_10, W_THIS, W_LAST, W_2LAS, M_THIS, M_LAST, M_2LAS, M_12, Q_THIS, Q_LAST, Q_2LAS, Y_THIS, Y_LAST, Y_2LAS, ALL);
    private static final List<Range> DEFAULT = Arrays.asList(D_7, D_30, D_90, W_THIS, W_LAST, W_2LAS, M_THIS, M_LAST, M_2LAS, M_12, Q_THIS, Q_LAST, Q_2LAS, Y_THIS, Y_LAST, Y_2LAS, ALL);

    public static List<Range> getAllRanges(Category category) {
        ArrayList<Range> result = new ArrayList<Range>();
        result.addAll(Range.getCustomRanges(category));
        result.addAll(KNOWN);
        return result;
    }

    public static List<Range> getActiveRanges(Category category) {
        ArrayList<Range> result = new ArrayList<Range>();
        for (Range range : Range.getCustomRanges(category)) {
            if (!settings.getBoolean(String.valueOf(category.getId()) + "." + range.getId(), true)) continue;
            result.add(range);
        }
        for (Range range : KNOWN) {
            if (!settings.getBoolean(String.valueOf(category.getId()) + "." + range.getId(), DEFAULT.contains(range))) continue;
            result.add(range);
        }
        return result;
    }

    private static List<Range> getCustomRanges(Category category) {
        ArrayList<Range> result = new ArrayList<Range>();
        String[] stringArray = settings.getList(String.valueOf(category.getId()) + ".custom", new String[0]);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String uuid = stringArray[n2];
            result.add(new CustomRange(uuid));
            ++n2;
        }
        return result;
    }

    public static void deleteCustomRange(Category category, CustomRange range) {
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = settings.getList(String.valueOf(category.getId()) + ".custom", new String[0]);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String uuid = stringArray[n2];
            if (Objects.equals(uuid, range.uuid)) {
                range.delete();
            } else {
                result.add(uuid);
            }
            ++n2;
        }
        settings.setAttribute(String.valueOf(category.getId()) + "." + range.getId(), null);
        settings.setAttribute(String.valueOf(category.getId()) + ".custom", result.toArray(new String[result.size()]));
    }

    public static void saveCustomRange(Category category, CustomRange range) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(Arrays.asList(settings.getList(String.valueOf(category.getId()) + ".custom", new String[0])));
        if (!result.contains(range.uuid)) {
            result.add(range.uuid);
        }
        range.save();
        settings.setAttribute(String.valueOf(category.getId()) + ".custom", result.toArray(new String[result.size()]));
    }

    public static void setActiveRanges(Category category, List<Range> ranges) {
        for (Range range : Range.getAllRanges(category)) {
            settings.setAttribute(String.valueOf(category.getId()) + "." + range.getId(), ranges.contains(range));
        }
    }

    public static void resetActiveRanges(Category category) {
        for (Range range : Range.getAllRanges(category)) {
            settings.setAttribute(String.valueOf(category.getId()) + "." + range.getId(), DEFAULT.contains(range));
        }
    }

    public static Range byId(String name) {
        if (name == null) {
            return null;
        }
        for (Range r : KNOWN) {
            if (!r.getId().equals(name)) continue;
            return r;
        }
        return null;
    }

    public abstract Date getStart();

    public abstract Date getEnd();

    public String getId() {
        return this.getClass().getSimpleName();
    }

    protected Calendar createCalendar() {
        return Calendar.getInstance(Locale.GERMANY);
    }

    public static class All
    extends Range {
        @Override
        public Date getStart() {
            return null;
        }

        @Override
        public Date getEnd() {
            return null;
        }

        public String toString() {
            return i18n.tr("Alles");
        }
    }

    public static enum Category {
        ZAHLUNGSVERKEHR("zahlungsverkehr", i18n.tr("Zahlungsverkehr")),
        AUSWERTUNG("auswertung", i18n.tr("Auswertungen, Umsatzlisten und Kontoausz\u00fcge"));

        private String id = null;
        private String name = null;

        private Category(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class CustomRange
    extends Range {
        private String uuid = null;
        private int daysPast = 30;
        private int daysFuture = 30;
        private String name = i18n.tr("Benutzerdefinierter Zeitraum");

        public static CustomRange create() {
            return new CustomRange(UUID.randomUUID().toString());
        }

        private CustomRange(String uuid) {
            this.uuid = uuid;
            this.daysPast = settings.getInt(String.valueOf(this.uuid) + ".days.past", this.daysPast);
            this.daysFuture = settings.getInt(String.valueOf(this.uuid) + ".days.future", this.daysFuture);
            this.name = settings.getString(String.valueOf(this.uuid) + ".name", this.name);
        }

        @Override
        public String getId() {
            return this.uuid;
        }

        @Override
        public Date getStart() {
            Calendar cal = Calendar.getInstance();
            cal.add(5, -this.getDaysPast());
            return DateUtil.startOfDay((Date)cal.getTime());
        }

        public int getDaysPast() {
            return this.daysPast;
        }

        @Override
        public Date getEnd() {
            Calendar cal = Calendar.getInstance();
            cal.add(5, this.getDaysFuture());
            return DateUtil.endOfDay((Date)cal.getTime());
        }

        public int getDaysFuture() {
            return this.daysFuture;
        }

        public void setDaysPast(int days) {
            this.daysPast = days;
        }

        public void setDaysFuture(int days) {
            this.daysFuture = days;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CustomRange)) {
                return false;
            }
            return Objects.equals(this.uuid, ((CustomRange)obj).uuid);
        }

        private void delete() {
            Logger.info((String)("deleting custom range [name: " + this.name + "]"));
            settings.setAttribute(String.valueOf(this.uuid) + ".days.past", null);
            settings.setAttribute(String.valueOf(this.uuid) + ".days.future", null);
            settings.setAttribute(String.valueOf(this.uuid) + ".days.name", null);
        }

        private void save() {
            Logger.info((String)("saving custom range [name: " + this.name + "]"));
            settings.setAttribute(String.valueOf(this.uuid) + ".days.past", this.daysPast);
            settings.setAttribute(String.valueOf(this.uuid) + ".days.future", this.daysFuture);
            settings.setAttribute(String.valueOf(this.uuid) + ".name", this.name);
        }
    }

    public static class Last10Years
    extends LastYears {
        protected Last10Years() {
            super(10, "Letzte 10 Jahre");
        }
    }

    public static class Last12Months
    extends Range {
        @Override
        public Date getStart() {
            Calendar cal = this.createCalendar();
            cal.add(2, -12);
            cal.set(5, 1);
            return DateUtil.startOfDay((Date)cal.getTime());
        }

        @Override
        public Date getEnd() {
            Calendar cal = this.createCalendar();
            cal.set(5, cal.getActualMaximum(5));
            return DateUtil.endOfDay((Date)cal.getTime());
        }

        public String toString() {
            return i18n.tr("Monat: Letzte 12");
        }
    }

    public static class Last365Days
    extends LastYears {
        protected Last365Days() {
            super(1, "Letzte 365 Tage");
        }
    }

    public static class Last3Years
    extends LastYears {
        protected Last3Years() {
            super(3, "Letzte 3 Jahre");
        }
    }

    public static class Last5Years
    extends LastYears {
        protected Last5Years() {
            super(5, "Letzte 5 Jahre");
        }
    }

    public static class LastMonth
    extends Range {
        @Override
        public Date getStart() {
            Calendar cal = this.createCalendar();
            cal.add(2, -1);
            cal.set(5, 1);
            return DateUtil.startOfDay((Date)cal.getTime());
        }

        @Override
        public Date getEnd() {
            Calendar cal = this.createCalendar();
            cal.setTime(this.getStart());
            cal.set(5, cal.getActualMaximum(5));
            return DateUtil.endOfDay((Date)cal.getTime());
        }

        public String toString() {
            return i18n.tr("Monat: Letzter");
        }
    }

    public static class LastNinetyDays
    extends Range {
        @Override
        public Date getStart() {
            Calendar cal = this.createCalendar();
            cal.add(5, -90);
            Date d = cal.getTime();
            return DateUtil.startOfDay((Date)d);
        }

        @Override
        public Date getEnd() {
            return null;
        }

        public String toString() {
            return i18n.tr("Letzte 90 Tage");
        }
    }

    public static class LastQuarter
    extends Range {
        @Override
        public Date getStart() {
            Calendar cal = this.createCalendar();
            cal.setTime(new ThisQuarter().getStart());
            cal.add(2, -3);
            return cal.getTime();
        }

        @Override
        public Date getEnd() {
            Calendar cal = this.createCalendar();
            cal.setTime(this.getStart());
            cal.add(2, 2);
            cal.set(5, cal.getActualMaximum(5));
            return DateUtil.endOfDay((Date)cal.getTime());
        }

        public String toString() {
            return i18n.tr("Quartal: Letztes");
        }
    }

    public static class LastSevenDays
    extends Range {
        @Override
        public Date getStart() {
            Calendar cal = this.createCalendar();
            cal.add(5, -7);
            Date d = cal.getTime();
            return DateUtil.startOfDay((Date)d);
        }

        @Override
        public Date getEnd() {
            return null;
        }

        public String toString() {
            return i18n.tr("Letzte 7 Tage");
        }
    }

    public static class LastThirtyDays
    extends Range {
        @Override
        public Date getStart() {
            Calendar cal = this.createCalendar();
            cal.add(5, -30);
            Date d = cal.getTime();
            return DateUtil.startOfDay((Date)d);
        }

        @Override
        public Date getEnd() {
            return null;
        }

        public String toString() {
            return i18n.tr("Letzte 30 Tage");
        }
    }

    public static class LastWeek
    extends Range {
        @Override
        public Date getStart() {
            Calendar cal = this.createCalendar();
            cal.setTime(new ThisWeek().getStart());
            cal.add(3, -1);
            return DateUtil.startOfDay((Date)cal.getTime());
        }

        @Override
        public Date getEnd() {
            Calendar cal = this.createCalendar();
            cal.setTime(this.getStart());
            cal.add(5, 6);
            return DateUtil.endOfDay((Date)cal.getTime());
        }

        public String toString() {
            return i18n.tr("Woche: Letzte");
        }
    }

    public static class LastYear
    extends Range {
        @Override
        public Date getStart() {
            Calendar cal = this.createCalendar();
            cal.add(1, -1);
            cal.set(2, 0);
            cal.set(5, 1);
            return DateUtil.startOfDay((Date)cal.getTime());
        }

        @Override
        public Date getEnd() {
            Calendar cal = this.createCalendar();
            cal.add(1, -1);
            cal.set(2, 11);
            cal.set(5, cal.getActualMaximum(5));
            return DateUtil.endOfDay((Date)cal.getTime());
        }

        public String toString() {
            return i18n.tr("Jahr: Letztes");
        }
    }

    private static abstract class LastYears
    extends Range {
        private String text;
        private int years;

        protected LastYears(int years, String text) {
            this.years = years;
            this.text = text;
        }

        @Override
        public Date getStart() {
            Calendar cal = this.createCalendar();
            cal.add(1, -this.years);
            cal.add(5, 1);
            Date d = cal.getTime();
            return DateUtil.startOfDay((Date)d);
        }

        @Override
        public Date getEnd() {
            return null;
        }

        public String toString() {
            return i18n.tr(this.text);
        }
    }

    public static class SecondLastMonth
    extends Range {
        @Override
        public Date getStart() {
            Calendar cal = this.createCalendar();
            cal.add(2, -2);
            cal.set(5, 1);
            return DateUtil.startOfDay((Date)cal.getTime());
        }

        @Override
        public Date getEnd() {
            Calendar cal = this.createCalendar();
            cal.setTime(this.getStart());
            cal.set(5, cal.getActualMaximum(5));
            return DateUtil.endOfDay((Date)cal.getTime());
        }

        public String toString() {
            return i18n.tr("Monat: Vorletzter");
        }
    }

    public static class SecondLastQuarter
    extends Range {
        @Override
        public Date getStart() {
            Calendar cal = this.createCalendar();
            cal.setTime(new LastQuarter().getStart());
            cal.add(2, -3);
            return cal.getTime();
        }

        @Override
        public Date getEnd() {
            Calendar cal = this.createCalendar();
            cal.setTime(this.getStart());
            cal.add(2, 2);
            cal.set(5, cal.getActualMaximum(5));
            return DateUtil.endOfDay((Date)cal.getTime());
        }

        public String toString() {
            return i18n.tr("Quartal: Vorletztes");
        }
    }

    public static class SecondLastWeek
    extends Range {
        @Override
        public Date getStart() {
            Calendar cal = this.createCalendar();
            cal.setTime(new ThisWeek().getStart());
            cal.add(3, -2);
            return DateUtil.startOfDay((Date)cal.getTime());
        }

        @Override
        public Date getEnd() {
            Calendar cal = this.createCalendar();
            cal.setTime(this.getStart());
            cal.add(5, 6);
            return DateUtil.endOfDay((Date)cal.getTime());
        }

        public String toString() {
            return i18n.tr("Woche: Vorletzte");
        }
    }

    public static class SecondLastYear
    extends Range {
        @Override
        public Date getStart() {
            Calendar cal = this.createCalendar();
            cal.add(1, -2);
            cal.set(2, 0);
            cal.set(5, 1);
            return DateUtil.startOfDay((Date)cal.getTime());
        }

        @Override
        public Date getEnd() {
            Calendar cal = this.createCalendar();
            cal.add(1, -2);
            cal.set(2, 11);
            cal.set(5, cal.getActualMaximum(5));
            return DateUtil.endOfDay((Date)cal.getTime());
        }

        public String toString() {
            return i18n.tr("Jahr: Vorletztes");
        }
    }

    public static class ThisMonth
    extends Range {
        @Override
        public Date getStart() {
            Calendar cal = this.createCalendar();
            cal.set(5, 1);
            return DateUtil.startOfDay((Date)cal.getTime());
        }

        @Override
        public Date getEnd() {
            Calendar cal = this.createCalendar();
            cal.set(5, cal.getActualMaximum(5));
            return DateUtil.endOfDay((Date)cal.getTime());
        }

        public String toString() {
            return i18n.tr("Monat: Dieser");
        }
    }

    public static class ThisQuarter
    extends Range {
        private static final int[] quarters;

        static {
            int[] nArray = new int[12];
            nArray[3] = 3;
            nArray[4] = 3;
            nArray[5] = 3;
            nArray[6] = 6;
            nArray[7] = 6;
            nArray[8] = 6;
            nArray[9] = 9;
            nArray[10] = 9;
            nArray[11] = 9;
            quarters = nArray;
        }

        @Override
        public Date getStart() {
            Calendar cal = this.createCalendar();
            cal.set(2, quarters[cal.get(2)]);
            cal.set(5, 1);
            return DateUtil.startOfDay((Date)cal.getTime());
        }

        @Override
        public Date getEnd() {
            Calendar cal = this.createCalendar();
            cal.setTime(this.getStart());
            cal.add(2, 2);
            cal.set(5, cal.getActualMaximum(5));
            return DateUtil.endOfDay((Date)cal.getTime());
        }

        public String toString() {
            return i18n.tr("Quartal: Dieses");
        }
    }

    public static class ThisWeek
    extends Range {
        @Override
        public Date getStart() {
            Calendar cal = this.createCalendar();
            cal.set(7, 2);
            return DateUtil.startOfDay((Date)cal.getTime());
        }

        @Override
        public Date getEnd() {
            Calendar cal = this.createCalendar();
            cal.set(7, 1);
            return DateUtil.endOfDay((Date)cal.getTime());
        }

        public String toString() {
            return i18n.tr("Woche: Diese");
        }
    }

    public static class ThisYear
    extends Range {
        @Override
        public Date getStart() {
            Calendar cal = this.createCalendar();
            cal.set(2, 0);
            cal.set(5, 1);
            return DateUtil.startOfDay((Date)cal.getTime());
        }

        @Override
        public Date getEnd() {
            Calendar cal = this.createCalendar();
            cal.set(2, 11);
            cal.set(5, cal.getActualMaximum(5));
            return DateUtil.endOfDay((Date)cal.getTime());
        }

        public String toString() {
            return i18n.tr("Jahr: Dieses");
        }
    }
}

