/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.rmi.Duplicatable;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaDauerauftrag;
import de.willuhn.jameica.hbci.server.AbstractBaseDauerauftragImpl;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.zip.CRC32;
import org.apache.commons.lang.StringUtils;

public class SepaDauerauftragImpl
extends AbstractBaseDauerauftragImpl
implements SepaDauerauftrag {
    private static final transient I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    protected String getTableName() {
        return "sepadauerauftrag";
    }

    public Duplicatable duplicate() throws RemoteException {
        SepaDauerauftrag u = (SepaDauerauftrag)this.getService().createObject(SepaDauerauftrag.class, null);
        u.setBetrag(this.getBetrag());
        u.setGegenkontoNummer(this.getGegenkontoNummer());
        u.setGegenkontoName(this.getGegenkontoName());
        u.setGegenkontoBLZ(this.getGegenkontoBLZ());
        u.setKonto(this.getKonto());
        u.setZweck(this.getZweck());
        u.setEndtoEndId(this.getEndtoEndId());
        u.setPmtInfId(this.getPmtInfId());
        u.setPurposeCode(this.getPurposeCode());
        u.setLetzteZahlung(this.getLetzteZahlung());
        u.setTurnus(this.getTurnus());
        return u;
    }

    @Override
    public long getChecksum() throws RemoteException {
        String ersteZahlung = this.getErsteZahlung() == null ? "" : HBCI.DATEFORMAT.format(this.getErsteZahlung());
        String letzteZahlung = this.getLetzteZahlung() == null ? "" : HBCI.DATEFORMAT.format(this.getLetzteZahlung());
        String s = String.valueOf((double)this.getTurnus().getChecksum() + this.getBetrag()) + this.getGegenkontoBLZ() + this.getGegenkontoNummer() + this.getGegenkontoName() + this.getKonto().getChecksum() + this.getZweck() + this.getEndtoEndId() + ersteZahlung + letzteZahlung;
        CRC32 crc = new CRC32();
        crc.update(s.getBytes());
        return crc.getValue();
    }

    @Override
    protected void insertCheck() throws ApplicationException {
        try {
            Konto k = this.getKonto();
            if (k == null) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie ein Konto aus."));
            }
            if (k.isNewObject()) {
                throw new ApplicationException(i18n.tr("Bitte speichern Sie zun\u00e4chst das Konto"));
            }
            String kiban = k.getIban();
            if (kiban == null || kiban.length() == 0) {
                throw new ApplicationException(i18n.tr("Das ausgew\u00e4hlte Konto besitzt keine IBAN"));
            }
            String bic = k.getBic();
            if (bic == null || bic.length() == 0) {
                throw new ApplicationException(i18n.tr("Das ausgew\u00e4hlte Konto besitzt keine BIC"));
            }
            Date ersteZahlung = this.getErsteZahlung();
            Date letzteZahlung = this.getLetzteZahlung();
            double betrag = this.getBetrag();
            if (betrag == 0.0 || Double.isNaN(betrag)) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie einen g\u00fcltigen Betrag ein."));
            }
            if (this.getTurnus() == null) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen Zahlungsturnus aus"));
            }
            if (ersteZahlung == null) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie ein Datum f\u00fcr die erste Zahlung an"));
            }
            if (letzteZahlung != null && letzteZahlung.before(ersteZahlung)) {
                throw new ApplicationException(i18n.tr("Bei Angabe eines Datum f\u00fcr die letzte Zahlung ({0}) muss dieses nach der ersten Zahlung ({1}) liegen", new String[]{HBCI.DATEFORMAT.format(letzteZahlung), HBCI.DATEFORMAT.format(ersteZahlung)}));
            }
            String s = StringUtils.trimToNull((String)this.getGegenkontoNummer());
            if (s == null) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie die IBAN des Gegenkontos ein"));
            }
            HBCIProperties.checkChars(s, HBCIProperties.HBCI_IBAN_VALIDCHARS);
            HBCIProperties.checkLength(s, HBCIProperties.HBCI_IBAN_MAXLENGTH);
            HBCIProperties.checkIBAN(s);
            if (StringUtils.trimToNull((String)this.getGegenkontoBLZ()) != null) {
                HBCIProperties.checkBIC(this.getGegenkontoBLZ());
            }
            if (StringUtils.trimToNull((String)this.getGegenkontoName()) == null) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie den Namen des Kontoinhabers des Gegenkontos ein"));
            }
            HBCIProperties.checkLength(this.getGegenkontoName(), HBCIProperties.HBCI_SEPATRANSFER_USAGE_MAXLENGTH);
            HBCIProperties.checkChars(this.getGegenkontoName(), HBCIProperties.HBCI_SEPA_VALIDCHARS);
            String zweck = this.getZweck();
            if (zweck == null || zweck.length() == 0) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie einen Verwendungszweck ein"));
            }
            HBCIProperties.checkLength(zweck, HBCIProperties.HBCI_SEPATRANSFER_USAGE_MAXLENGTH);
            HBCIProperties.checkChars(zweck, HBCIProperties.HBCI_SEPA_VALIDCHARS);
            HBCIProperties.checkLength(this.getEndtoEndId(), HBCIProperties.HBCI_SEPA_ENDTOENDID_MAXLENGTH);
            HBCIProperties.checkChars(this.getEndtoEndId(), HBCIProperties.HBCI_SEPA_VALIDCHARS);
            HBCIProperties.checkLength(this.getPmtInfId(), HBCIProperties.HBCI_SEPA_ENDTOENDID_MAXLENGTH);
            HBCIProperties.checkChars(this.getPmtInfId(), HBCIProperties.HBCI_SEPA_PMTINF_VALIDCHARS);
            HBCIProperties.checkLength(this.getPurposeCode(), HBCIProperties.HBCI_SEPA_PURPOSECODE_MAXLENGTH);
            HBCIProperties.checkChars(this.getPurposeCode(), HBCIProperties.HBCI_SEPA_PURPOSECODE_VALIDCHARS);
        }
        catch (RemoteException e) {
            Logger.error((String)"insert check failed", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler bei der Pr\u00fcfung des SEPA-Dauerauftrags"));
        }
    }

    @Override
    public void setGegenkontoBLZ(String blz) throws RemoteException {
        this.setAttribute("empfaenger_bic", blz);
    }

    @Override
    public String getGegenkontoBLZ() throws RemoteException {
        return (String)this.getAttribute("empfaenger_bic");
    }

    @Override
    public String getEndtoEndId() throws RemoteException {
        return (String)this.getAttribute("endtoendid");
    }

    @Override
    public void setEndtoEndId(String id) throws RemoteException {
        this.setAttribute("endtoendid", id);
    }

    @Override
    public boolean canChange() throws RemoteException {
        Integer i = (Integer)this.getAttribute("canchange");
        return i != null && i == 1;
    }

    @Override
    public boolean canDelete() throws RemoteException {
        Integer i = (Integer)this.getAttribute("candelete");
        return i != null && i == 1;
    }

    public void setChangable(boolean b) throws RemoteException {
        this.setAttribute("canchange", b ? 1 : 0);
    }

    public void setDeletable(boolean b) throws RemoteException {
        this.setAttribute("candelete", b ? 1 : 0);
    }

    @Override
    public String getPmtInfId() throws RemoteException {
        return (String)this.getAttribute("pmtinfid");
    }

    @Override
    public void setPmtInfId(String id) throws RemoteException {
        this.setAttribute("pmtinfid", id);
    }

    @Override
    public String getPurposeCode() throws RemoteException {
        return (String)this.getAttribute("purposecode");
    }

    @Override
    public void setPurposeCode(String code) throws RemoteException {
        this.setAttribute("purposecode", code);
    }
}

