/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.reminder.ReminderStorageProviderHibiscus;
import de.willuhn.jameica.hbci.rmi.Duplicatable;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaLastSequenceType;
import de.willuhn.jameica.hbci.rmi.SepaLastType;
import de.willuhn.jameica.hbci.rmi.SepaLastschrift;
import de.willuhn.jameica.hbci.server.AbstractBaseUeberweisungImpl;
import de.willuhn.jameica.reminder.Reminder;
import de.willuhn.jameica.reminder.ReminderInterval;
import de.willuhn.jameica.reminder.ReminderStorageProvider;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SepaLastschriftImpl
extends AbstractBaseUeberweisungImpl
implements SepaLastschrift {
    private static final transient I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    protected String getTableName() {
        return "sepalastschrift";
    }

    public Duplicatable duplicate() throws RemoteException {
        SepaLastschriftImpl u = (SepaLastschriftImpl)this.getService().createObject(SepaLastschrift.class, null);
        u.setBetrag(this.getBetrag());
        u.setGegenkontoNummer(this.getGegenkontoNummer());
        u.setGegenkontoName(this.getGegenkontoName());
        u.setGegenkontoBLZ(this.getGegenkontoBLZ());
        u.setKonto(this.getKonto());
        u.setZweck(this.getZweck());
        u.setEndtoEndId(this.getEndtoEndId());
        u.setPmtInfId(this.getPmtInfId());
        u.setMandateId(this.getMandateId());
        u.setSignatureDate(this.getSignatureDate());
        u.setCreditorId(this.getCreditorId());
        u.setSequenceType(this.getSequenceType());
        u.setType(this.getType());
        u.setOrderId(this.getOrderId());
        u.setPurposeCode(this.getPurposeCode());
        try {
            Date target = this.getTargetDate();
            Date now = new Date();
            Date newTarget = null;
            if (target != null && !target.after(now)) {
                String uuid = MetaKey.REMINDER_UUID.get(this);
                if (uuid != null) {
                    Logger.info((String)"calculating target date from duplication template");
                    BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
                    ReminderStorageProvider provider = (ReminderStorageProvider)service.get(ReminderStorageProviderHibiscus.class);
                    Reminder r = provider.get(uuid);
                    ReminderInterval ri = r.getReminderInterval();
                    List dates = ri.getDates(target, now, null);
                    if (!dates.isEmpty()) {
                        newTarget = (Date)dates.get(0);
                    }
                } else {
                    newTarget = new Date(now.getTime() + 86400000L);
                }
                u.setTargetDate(DateUtil.endOfDay((Date)newTarget));
            } else {
                u.setTargetDate(target);
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to apply target date", (Throwable)e);
        }
        return u;
    }

    @Override
    protected void insertCheck() throws ApplicationException {
        try {
            Konto k = this.getKonto();
            if (k == null) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie ein Konto aus."));
            }
            if (k.isNewObject()) {
                throw new ApplicationException(i18n.tr("Bitte speichern Sie zun\u00e4chst das Konto"));
            }
            String kiban = k.getIban();
            if (kiban == null || kiban.length() == 0) {
                throw new ApplicationException(i18n.tr("Das ausgew\u00e4hlte Konto besitzt keine IBAN"));
            }
            String bic = k.getBic();
            if (bic == null || bic.length() == 0) {
                throw new ApplicationException(i18n.tr("Das ausgew\u00e4hlte Konto besitzt keine BIC"));
            }
            double betrag = this.getBetrag();
            if (betrag == 0.0 || Double.isNaN(betrag)) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie einen g\u00fcltigen Betrag ein."));
            }
            String s = StringUtils.trimToNull((String)this.getGegenkontoNummer());
            if (s == null) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie die IBAN des Gegenkontos ein"));
            }
            HBCIProperties.checkChars(s, HBCIProperties.HBCI_IBAN_VALIDCHARS);
            HBCIProperties.checkLength(s, HBCIProperties.HBCI_IBAN_MAXLENGTH);
            HBCIProperties.checkIBAN(s);
            if (StringUtils.trimToNull((String)this.getGegenkontoBLZ()) != null) {
                HBCIProperties.checkBIC(this.getGegenkontoBLZ());
            }
            if (StringUtils.trimToNull((String)this.getGegenkontoName()) == null) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie den Namen des Kontoinhabers des Gegenkontos ein"));
            }
            HBCIProperties.checkLength(this.getGegenkontoName(), HBCIProperties.HBCI_SEPATRANSFER_USAGE_MAXLENGTH);
            HBCIProperties.checkChars(this.getGegenkontoName(), HBCIProperties.HBCI_SEPA_VALIDCHARS);
            HBCIProperties.checkLength(this.getZweck(), HBCIProperties.HBCI_SEPATRANSFER_USAGE_MAXLENGTH);
            HBCIProperties.checkChars(this.getZweck(), HBCIProperties.HBCI_SEPA_VALIDCHARS);
            HBCIProperties.checkLength(this.getEndtoEndId(), HBCIProperties.HBCI_SEPA_ENDTOENDID_MAXLENGTH);
            HBCIProperties.checkChars(this.getEndtoEndId(), HBCIProperties.HBCI_SEPA_VALIDCHARS);
            HBCIProperties.checkLength(this.getPmtInfId(), HBCIProperties.HBCI_SEPA_ENDTOENDID_MAXLENGTH);
            HBCIProperties.checkChars(this.getPmtInfId(), HBCIProperties.HBCI_SEPA_PMTINF_VALIDCHARS);
            HBCIProperties.checkLength(this.getPurposeCode(), HBCIProperties.HBCI_SEPA_PURPOSECODE_MAXLENGTH);
            HBCIProperties.checkChars(this.getPurposeCode(), HBCIProperties.HBCI_SEPA_PURPOSECODE_VALIDCHARS);
            String creditorId = this.getCreditorId();
            if (creditorId == null || creditorId.length() == 0) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie die Gl\u00e4ubiger-Identifikation ein."));
            }
            HBCIProperties.checkLength(creditorId, HBCIProperties.HBCI_SEPA_CREDITORID_MAXLENGTH);
            HBCIProperties.checkChars(creditorId, HBCIProperties.HBCI_SEPA_VALIDCHARS);
            if (!HBCIProperties.checkCreditorIdCRC(creditorId)) {
                throw new ApplicationException(i18n.tr("Ung\u00fcltige Gl\u00e4ubiger-Identifikation. Bitte pr\u00fcfen Sie Ihre Eingaben."));
            }
            String mandateId = this.getMandateId();
            if (mandateId == null || mandateId.length() == 0) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie die Mandatsreferenz ein."));
            }
            HBCIProperties.checkLength(mandateId, HBCIProperties.HBCI_SEPA_MANDATEID_MAXLENGTH);
            HBCIProperties.checkChars(mandateId, HBCIProperties.HBCI_SEPA_VALIDCHARS);
            if (this.getSignatureDate() == null) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie das Unterschriftsdatum des Mandats ein"));
            }
            if (this.getSequenceType() == null) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie den Sequenz-Typ aus"));
            }
            if (this.getTargetDate() == null) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie einen Zieltermin ein"));
            }
            if (!this.getTargetDate().after(DateUtil.startOfDay((Date)new Date()))) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie einen Zieltermin ein, der sich in der Zukunft befindet"));
            }
            if (this.getType() == null) {
                this.setType(SepaLastType.DEFAULT);
            }
            if (this.getTermin() == null) {
                this.setTermin(new Date());
            }
        }
        catch (RemoteException e) {
            Logger.error((String)"error while checking job", (Throwable)e);
            if (!this.markingExecuted()) {
                throw new ApplicationException(i18n.tr("Fehler beim Pr\u00fcfen des SEPA-Auftrages."));
            }
        }
        catch (ApplicationException ae) {
            if (!this.markingExecuted()) {
                throw ae;
            }
            Logger.warn((String)ae.getMessage());
        }
    }

    @Override
    public void setTextSchluessel(String schluessel) throws RemoteException {
        if (schluessel != null && schluessel.length() > 0) {
            throw new RemoteException("textschluessel not allowed for foreign transfer");
        }
    }

    @Override
    public void setGegenkontoBLZ(String blz) throws RemoteException {
        this.setAttribute("empfaenger_bic", blz);
    }

    @Override
    public String getGegenkontoBLZ() throws RemoteException {
        return (String)this.getAttribute("empfaenger_bic");
    }

    @Override
    public void setWeitereVerwendungszwecke(String[] list) throws RemoteException {
        if (list != null && list.length > 0) {
            throw new RemoteException("extended usages not allowed for foreign transfer");
        }
    }

    @Override
    public void setZweck2(String zweck2) throws RemoteException {
        if (zweck2 != null && zweck2.length() > 0) {
            throw new RemoteException("second usage not allowed for sepa debit");
        }
    }

    @Override
    public String getEndtoEndId() throws RemoteException {
        return (String)this.getAttribute("endtoendid");
    }

    @Override
    public void setEndtoEndId(String id) throws RemoteException {
        this.setAttribute("endtoendid", id);
    }

    @Override
    public String getMandateId() throws RemoteException {
        return (String)this.getAttribute("mandateid");
    }

    @Override
    public void setMandateId(String id) throws RemoteException {
        this.setAttribute("mandateid", id);
    }

    @Override
    public Date getSignatureDate() throws RemoteException {
        return (Date)this.getAttribute("sigdate");
    }

    @Override
    public String getCreditorId() throws RemoteException {
        return (String)this.getAttribute("creditorid");
    }

    @Override
    public void setCreditorId(String id) throws RemoteException {
        this.setAttribute("creditorid", id);
    }

    @Override
    public void setSignatureDate(Date date) throws RemoteException {
        this.setAttribute("sigdate", date);
    }

    @Override
    public SepaLastSequenceType getSequenceType() throws RemoteException {
        String val = (String)this.getAttribute("sequencetype");
        if (val == null || val.length() == 0) {
            return null;
        }
        try {
            return SepaLastSequenceType.valueOf(val);
        }
        catch (Exception e) {
            Logger.error((String)("invalid sequencetype: " + val), (Throwable)e);
            return null;
        }
    }

    @Override
    public void setSequenceType(SepaLastSequenceType type) throws RemoteException {
        this.setAttribute("sequencetype", type != null ? type.name() : null);
    }

    @Override
    public Date getTargetDate() throws RemoteException {
        return (Date)this.getAttribute("targetdate");
    }

    @Override
    public void setTargetDate(Date date) throws RemoteException {
        this.setAttribute("targetdate", date);
    }

    @Override
    public SepaLastType getType() throws RemoteException {
        String val = (String)this.getAttribute("sepatype");
        if (val == null || val.length() == 0) {
            return null;
        }
        try {
            return SepaLastType.valueOf(val);
        }
        catch (Exception e) {
            Logger.error((String)("invalid sepa-type: " + val), (Throwable)e);
            return null;
        }
    }

    @Override
    public void setType(SepaLastType type) throws RemoteException {
        this.setAttribute("sepatype", type != null ? type.name() : null);
    }

    @Override
    public String getOrderId() throws RemoteException {
        return (String)this.getAttribute("orderid");
    }

    @Override
    public void setOrderId(String orderId) throws RemoteException {
        this.setAttribute("orderid", orderId);
    }

    @Override
    public String getPmtInfId() throws RemoteException {
        return (String)this.getAttribute("pmtinfid");
    }

    @Override
    public void setPmtInfId(String id) throws RemoteException {
        this.setAttribute("pmtinfid", id);
    }

    @Override
    public String getPurposeCode() throws RemoteException {
        return (String)this.getAttribute("purposecode");
    }

    @Override
    public void setPurposeCode(String code) throws RemoteException {
        this.setAttribute("purposecode", code);
    }
}

