/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.reminder.ReminderStorageProviderHibiscus;
import de.willuhn.jameica.hbci.rmi.Duplicatable;
import de.willuhn.jameica.hbci.rmi.SepaLastSequenceType;
import de.willuhn.jameica.hbci.rmi.SepaLastType;
import de.willuhn.jameica.hbci.rmi.SepaSammelLastBuchung;
import de.willuhn.jameica.hbci.rmi.SepaSammelLastschrift;
import de.willuhn.jameica.hbci.server.AbstractSepaSammelTransferImpl;
import de.willuhn.jameica.reminder.Reminder;
import de.willuhn.jameica.reminder.ReminderInterval;
import de.willuhn.jameica.reminder.ReminderStorageProvider;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;

public class SepaSammelLastschriftImpl
extends AbstractSepaSammelTransferImpl<SepaSammelLastBuchung>
implements SepaSammelLastschrift {
    private static final transient I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    protected String getTableName() {
        return "sepaslast";
    }

    @Override
    protected void insertCheck() throws ApplicationException {
        super.insertCheck();
        try {
            if (this.getSequenceType() == null) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie den Sequenz-Typ aus"));
            }
            if (this.getTargetDate() == null) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie einen Zieltermin ein"));
            }
            if (this.getTargetDate().before(DateUtil.startOfDay((Date)new Date())) && !this.ausgefuehrt()) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie einen Zieltermin ein, der sich in der Zukunft befindet"));
            }
            if (this.getType() == null) {
                this.setType(SepaLastType.DEFAULT);
            }
        }
        catch (RemoteException e) {
            Logger.error((String)"error while checking job", (Throwable)e);
            if (!this.markingExecuted()) {
                throw new ApplicationException(i18n.tr("Fehler beim Pr\u00fcfen des SEPA-Auftrages."));
            }
        }
        catch (ApplicationException ae) {
            if (!this.markingExecuted()) {
                throw ae;
            }
            Logger.warn((String)ae.getMessage());
        }
    }

    @Override
    public List<SepaSammelLastBuchung> getBuchungen() throws RemoteException {
        DBIterator list = this.getService().createList(SepaSammelLastBuchung.class);
        list.addFilter("sepaslast_id = " + this.getID());
        list.setOrder("order by empfaenger_name,id");
        return PseudoIterator.asList((GenericIterator)list);
    }

    @Override
    public SepaSammelLastBuchung createBuchung() throws RemoteException, ApplicationException {
        SepaSammelLastBuchung b = (SepaSammelLastBuchung)this.getService().createObject(SepaSammelLastBuchung.class, null);
        if (this.isNewObject()) {
            this.store();
        }
        b.setSammelTransfer(this);
        return b;
    }

    @Override
    public SepaLastSequenceType getSequenceType() throws RemoteException {
        String val = (String)this.getAttribute("sequencetype");
        if (val == null || val.length() == 0) {
            return null;
        }
        try {
            return SepaLastSequenceType.valueOf(val);
        }
        catch (Exception e) {
            Logger.error((String)("invalid sequencetype: " + val), (Throwable)e);
            return null;
        }
    }

    @Override
    public void setSequenceType(SepaLastSequenceType type) throws RemoteException {
        this.setAttribute("sequencetype", type != null ? type.name() : null);
    }

    @Override
    public Date getTargetDate() throws RemoteException {
        return (Date)this.getAttribute("targetdate");
    }

    @Override
    public void setTargetDate(Date date) throws RemoteException {
        this.setAttribute("targetdate", date);
    }

    @Override
    public SepaLastType getType() throws RemoteException {
        String val = (String)this.getAttribute("sepatype");
        if (val == null || val.length() == 0) {
            return null;
        }
        try {
            return SepaLastType.valueOf(val);
        }
        catch (Exception e) {
            Logger.error((String)("invalid sepa-type: " + val), (Throwable)e);
            return null;
        }
    }

    @Override
    public void setType(SepaLastType type) throws RemoteException {
        this.setAttribute("sepatype", type != null ? type.name() : null);
    }

    @Override
    public String getOrderId() throws RemoteException {
        return (String)this.getAttribute("orderid");
    }

    @Override
    public void setOrderId(String orderId) throws RemoteException {
        this.setAttribute("orderid", orderId);
    }

    public Duplicatable duplicate() throws RemoteException {
        SepaSammelLastschrift l = null;
        try {
            l = (SepaSammelLastschrift)this.getService().createObject(SepaSammelLastschrift.class, null);
            l.transactionBegin();
            l.setBezeichnung(this.getBezeichnung());
            l.setKonto(this.getKonto());
            l.setTermin(new Date());
            l.setSequenceType(this.getSequenceType());
            l.setType(this.getType());
            l.setOrderId(this.getOrderId());
            l.setPmtInfId(this.getPmtInfId());
            try {
                Date target = this.getTargetDate();
                Date now = new Date();
                Date newTarget = null;
                if (target != null && !target.after(now)) {
                    String uuid = MetaKey.REMINDER_UUID.get(this);
                    if (uuid != null) {
                        Logger.info((String)"calculating target date from duplication template");
                        BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
                        ReminderStorageProvider provider = (ReminderStorageProvider)service.get(ReminderStorageProviderHibiscus.class);
                        Reminder r = provider.get(uuid);
                        ReminderInterval ri = r.getReminderInterval();
                        List dates = ri.getDates(target, now, null);
                        if (!dates.isEmpty()) {
                            newTarget = (Date)dates.get(0);
                        }
                    } else {
                        newTarget = new Date(now.getTime() + 86400000L);
                    }
                    l.setTargetDate(DateUtil.endOfDay((Date)newTarget));
                } else {
                    l.setTargetDate(target);
                }
            }
            catch (Exception e) {
                Logger.error((String)"unable to apply target date", (Throwable)e);
            }
            l.store();
            List<SepaSammelLastBuchung> list = this.getBuchungen();
            for (SepaSammelLastBuchung t : list) {
                SepaSammelLastBuchung copy = (SepaSammelLastBuchung)t.duplicate();
                copy.setSammelTransfer(l);
                copy.store();
            }
            l.transactionCommit();
            return l;
        }
        catch (Exception e) {
            if (l != null) {
                l.transactionRollback();
            }
            Logger.error((String)"unable to duplicate sepa sammeltransfer", (Throwable)e);
            String text = i18n.tr("Fehler beim Duplizieren des SEPA-Sammelauftrages");
            if (e instanceof ApplicationException) {
                text = e.getMessage();
            }
            throw new RemoteException(text, e);
        }
    }
}

