/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.Duplicatable;
import de.willuhn.jameica.hbci.rmi.SepaSammelUeberweisung;
import de.willuhn.jameica.hbci.rmi.SepaSammelUeberweisungBuchung;
import de.willuhn.jameica.hbci.server.AbstractSepaSammelTransferImpl;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;

public class SepaSammelUeberweisungImpl
extends AbstractSepaSammelTransferImpl<SepaSammelUeberweisungBuchung>
implements SepaSammelUeberweisung {
    private static final transient I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    protected String getTableName() {
        return "sepasueb";
    }

    @Override
    public List<SepaSammelUeberweisungBuchung> getBuchungen() throws RemoteException {
        DBIterator list = this.getService().createList(SepaSammelUeberweisungBuchung.class);
        list.addFilter("sepasueb_id = " + this.getID());
        list.setOrder("order by empfaenger_name,id");
        return PseudoIterator.asList((GenericIterator)list);
    }

    @Override
    public SepaSammelUeberweisungBuchung createBuchung() throws RemoteException, ApplicationException {
        SepaSammelUeberweisungBuchung b = (SepaSammelUeberweisungBuchung)this.getService().createObject(SepaSammelUeberweisungBuchung.class, null);
        if (this.isNewObject()) {
            this.store();
        }
        b.setSammelTransfer(this);
        return b;
    }

    public Duplicatable duplicate() throws RemoteException {
        SepaSammelUeberweisung u = null;
        try {
            u = (SepaSammelUeberweisung)this.getService().createObject(SepaSammelUeberweisung.class, null);
            u.transactionBegin();
            u.setBezeichnung(this.getBezeichnung());
            u.setKonto(this.getKonto());
            u.setTerminUeberweisung(this.isTerminUeberweisung());
            u.setTermin(this.isTerminUeberweisung() ? this.getTermin() : new Date());
            u.setPmtInfId(this.getPmtInfId());
            u.store();
            List<SepaSammelUeberweisungBuchung> list = this.getBuchungen();
            for (SepaSammelUeberweisungBuchung t : list) {
                SepaSammelUeberweisungBuchung copy = (SepaSammelUeberweisungBuchung)t.duplicate();
                copy.setSammelTransfer(u);
                copy.store();
            }
            u.transactionCommit();
            return u;
        }
        catch (Exception e) {
            if (u != null) {
                u.transactionRollback();
            }
            Logger.error((String)"unable to duplicate sepa sammeltransfer", (Throwable)e);
            String text = i18n.tr("Fehler beim Duplizieren des SEPA-Sammelauftrages");
            if (e instanceof ApplicationException) {
                text = e.getMessage();
            }
            throw new RemoteException(text, e);
        }
    }

    @Override
    public boolean ueberfaellig() throws RemoteException {
        if (this.isTerminUeberweisung()) {
            return !this.ausgefuehrt();
        }
        return super.ueberfaellig();
    }

    @Override
    public boolean isTerminUeberweisung() throws RemoteException {
        Integer i = (Integer)this.getAttribute("banktermin");
        return i != null && i == 1;
    }

    @Override
    public void setTerminUeberweisung(boolean termin) throws RemoteException {
        this.setAttribute("banktermin", termin ? Integer.valueOf(1) : null);
    }
}

