/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.SynchronizeSchedulerSettings;
import de.willuhn.jameica.hbci.gui.action.Synchronize;
import de.willuhn.jameica.hbci.gui.parts.SynchronizeList;
import de.willuhn.jameica.hbci.rmi.SynchronizeSchedulerService;
import de.willuhn.jameica.hbci.synchronize.Synchronization;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class SynchronizeSchedulerServiceImpl
extends UnicastRemoteObject
implements SynchronizeSchedulerService {
    private static final transient I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private Timer timer = null;
    private SchedulerTask task = null;
    private long period = 1L;
    private int status = 1;
    private long lastStart = 0L;
    private long lastFinish = 0L;
    private MessageConsumer mc = new MyMessageConsumer();

    public String getName() throws RemoteException {
        return "Scheduler-Service";
    }

    public boolean isStartable() throws RemoteException {
        return SynchronizeSchedulerSettings.isEnabled() && !this.isStarted();
    }

    public boolean isStarted() throws RemoteException {
        return this.timer != null;
    }

    public void start() throws RemoteException {
        if (!SynchronizeSchedulerSettings.isEnabled()) {
            return;
        }
        if (this.isStarted()) {
            Logger.warn((String)"service already started, skipping request");
            return;
        }
        Logger.info((String)"starting scheduler service");
        int interval = SynchronizeSchedulerSettings.getSchedulerInterval();
        Logger.info((String)("scheduler interval: " + interval + " minutes"));
        this.timer = new Timer();
        this.task = new SchedulerTask();
        this.period = (long)(interval * 60) * 1000L;
        this.timer.schedule((TimerTask)this.task, 60000L, this.period);
        Application.getMessagingFactory().getMessagingQueue("hibiscus.sync.status").registerMessageConsumer(this.mc);
    }

    @Override
    public int getStatus() throws RemoteException {
        return this.status;
    }

    public void stop(boolean arg0) throws RemoteException {
        if (!this.isStarted()) {
            Logger.warn((String)"service not started, skipping request");
            return;
        }
        if (this.timer == null) {
            Logger.info((String)"skip stop request. Scheduler not running");
            return;
        }
        try {
            Logger.info((String)"stopping scheduler service");
            Application.getMessagingFactory().getMessagingQueue("hibiscus.sync.status").unRegisterMessageConsumer(this.mc);
            this.task.cancel();
            this.timer.cancel();
        }
        finally {
            this.task = null;
            this.timer = null;
        }
    }

    @Override
    public Date getLastExecution() throws RemoteException {
        if (this.lastStart <= 0L) {
            return null;
        }
        return new Date(this.lastStart);
    }

    @Override
    public Date getNextExecution() throws RemoteException {
        if (this.task == null) {
            return null;
        }
        long current = this.task.scheduledExecutionTime();
        Logger.info((String)("calculating next execution [scheduled execution: " + new Date(current) + ", last start: " + (this.lastStart <= 0L ? "<never>" : new Date(this.lastStart)) + ", last finish: " + (this.lastFinish <= 0L ? "<never>" : new Date(this.lastFinish)) + "]"));
        Date d = null;
        int i = 0;
        while (i < 10000) {
            d = new Date(current += this.period);
            if (this.canRun(d) && current > System.currentTimeMillis()) {
                Logger.info((String)("next execution: " + d));
                return d;
            }
            ++i;
        }
        Logger.error((String)"exclude window too large, scheduler will ne run");
        Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage("Zeitfenster f\u00fcr Ausschluss zu gro\u00df, Synchronisierung w\u00fcrde nie starten", 1));
        return null;
    }

    private void doSync() {
        try {
            List<Synchronization> list = SynchronizeList.getActiveSyncs();
            if (list.isEmpty()) {
                return;
            }
            Synchronize sync = new Synchronize();
            sync.handleAction(list);
        }
        catch (OperationCanceledException oce) {
            Logger.info((String)"synchronization cancelled");
        }
        catch (ApplicationException ae) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
        }
        catch (Exception e) {
            Logger.error((String)"error while synchronizing", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Synchronisierung fehlgeschlagen: {0}", e.getMessage()), 1));
        }
    }

    private boolean canRun(Date check) {
        int to;
        Calendar cal = Calendar.getInstance();
        cal.setTime(check);
        if (!SynchronizeSchedulerSettings.getSchedulerIncludeDay(cal.get(7))) {
            return false;
        }
        int from = SynchronizeSchedulerSettings.getSchedulerStartTime();
        if (from == (to = SynchronizeSchedulerSettings.getSchedulerEndTime())) {
            return true;
        }
        int run = cal.get(11);
        if (from > to) {
            return run >= from || run < to;
        }
        return run >= from && run < to;
    }

    private class MyMessageConsumer
    implements MessageConsumer {
        private MyMessageConsumer() {
        }

        public Class[] getExpectedMessageTypes() {
            return new Class[]{QueryMessage.class};
        }

        public void handleMessage(Message message) throws Exception {
            QueryMessage msg = (QueryMessage)message;
            Object data = msg.getData();
            if (!(data instanceof Integer)) {
                Logger.warn((String)("got unknown data: " + data));
                return;
            }
            SynchronizeSchedulerServiceImpl.this.status = (Integer)data;
            if (SynchronizeSchedulerServiceImpl.this.status == 3 && SynchronizeSchedulerSettings.getStopSchedulerOnError()) {
                Logger.error((String)"stopping synchronize scheduler");
                try {
                    SynchronizeSchedulerServiceImpl.this.stop(true);
                }
                catch (RemoteException re) {
                    Logger.error((String)"stopping of service failed");
                }
            }
        }

        public boolean autoRegister() {
            return false;
        }
    }

    public class SchedulerTask
    extends TimerTask {
        public SchedulerTask() {
            Logger.info((String)"starting scheduled synchronization");
        }

        @Override
        public void run() {
            try {
                if (!SynchronizeSchedulerServiceImpl.this.canRun(new Date())) {
                    Logger.info((String)("skip synchronize, not inside execution time [hours: " + SynchronizeSchedulerSettings.getSchedulerStartTime() + " - " + SynchronizeSchedulerSettings.getSchedulerEndTime() + "]"));
                    return;
                }
                try {
                    SynchronizeSchedulerServiceImpl.this.lastStart = System.currentTimeMillis();
                    SynchronizeSchedulerServiceImpl.this.doSync();
                }
                catch (Exception e) {
                    Logger.error((String)("error while executing scheduler task: " + e.getMessage()), (Throwable)e);
                }
            }
            finally {
                SynchronizeSchedulerServiceImpl.this.lastFinish = System.currentTimeMillis();
            }
        }
    }
}

