/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestVerwendungszweckUtil {
    @Test
    public void testRewrap() throws Exception {
        String[] stringArray = new String[6];
        stringArray[0] = "123456789012345678901234567890";
        stringArray[1] = "123456789012345678901234567890 ";
        stringArray[3] = "d";
        stringArray[4] = " ";
        stringArray[5] = "123456789012345678901234567";
        String[] test = stringArray;
        Object[] result = VerwendungszweckUtil.rewrap(27, test);
        Assertions.assertArrayEquals((Object[])new String[]{"123456789012345678901234567", "890123456789012345678901234", "567890d12345678901234567890", "1234567"}, (Object[])result);
    }

    @Test
    public void testParse001() throws Exception {
        String[] test = new String[]{"SVWZ+Ein komischer.Verwendungszweck ", "auf mehreren Zeilen ", "Hier kommt nochwas", "ABWA+Das ist ein..Test//Text ", "mit Zeilen-Umbruch"};
        Map<VerwendungszweckUtil.Tag, String> map = VerwendungszweckUtil.parse(test);
        Assertions.assertEquals((Object)"Ein komischer.Verwendungszweck auf mehreren Zeilen Hier kommt nochwas", (Object)map.get((Object)VerwendungszweckUtil.Tag.SVWZ), (String)"SVWZ falsch");
        Assertions.assertEquals((Object)"Das ist ein..Test//Text mit Zeilen-Umbruch", (Object)map.get((Object)VerwendungszweckUtil.Tag.ABWA), (String)"ABWA falsch");
    }

    @Test
    public void testParse002() throws Exception {
        String[] test = new String[]{"SVWZ+Das folgende Tag gibts nicht", "Fooo", "ABCD+Gehoert zum Verwendungszweck"};
        Map<VerwendungszweckUtil.Tag, String> map = VerwendungszweckUtil.parse(test);
        Assertions.assertEquals((Object)"Das folgende Tag gibts nichtFoooABCD+Gehoert zum Verwendungszweck", (Object)map.get((Object)VerwendungszweckUtil.Tag.SVWZ), (String)"SVWZ falsch");
    }

    @Test
    public void testParse003() throws Exception {
        String[] test = new String[]{"SVWZ+Das folgende Tag gibts nicht", "Fooo ", "ABCD+Gehoert zum Verwendungszweck", "EREF+Aber hier kommt noch was"};
        Map<VerwendungszweckUtil.Tag, String> map = VerwendungszweckUtil.parse(test);
        Assertions.assertEquals((Object)"Das folgende Tag gibts nichtFooo ABCD+Gehoert zum Verwendungszweck", (Object)map.get((Object)VerwendungszweckUtil.Tag.SVWZ), (String)"SVWZ falsch");
        Assertions.assertEquals((Object)"Aber hier kommt noch was", (Object)map.get((Object)VerwendungszweckUtil.Tag.EREF), (String)"EREF falsch");
    }

    @Test
    public void testParse004() throws Exception {
        String[] test = new String[]{"SVWZ+Das folgende Tag gibts nicht", "Fooo ", "ABCD+ Leerzeichen hinter dem Tag stoeren nicht", "KREF+ und hier stoeren sie auch nicht, sind aber nicht teil des Value "};
        Map<VerwendungszweckUtil.Tag, String> map = VerwendungszweckUtil.parse(test);
        Assertions.assertEquals((Object)"Das folgende Tag gibts nichtFooo ABCD+ Leerzeichen hinter dem Tag stoeren nicht", (Object)map.get((Object)VerwendungszweckUtil.Tag.SVWZ), (String)"SVWZ falsch");
        Assertions.assertEquals((Object)"und hier stoeren sie auch nicht, sind aber nicht teil des Value", (Object)map.get((Object)VerwendungszweckUtil.Tag.KREF), (String)"KREF falsch");
    }

    @Test
    public void testParse005() throws Exception {
        String[] test = new String[]{"SVWZ+Nur eine Zeile"};
        Map<VerwendungszweckUtil.Tag, String> map = VerwendungszweckUtil.parse(test);
        Assertions.assertEquals((Object)"Nur eine Zeile", (Object)map.get((Object)VerwendungszweckUtil.Tag.SVWZ), (String)"SVWZ falsch");
    }

    @Test
    public void testParse006() throws Exception {
        String[] test = new String[]{"SVWZ+"};
        Map<VerwendungszweckUtil.Tag, String> map = VerwendungszweckUtil.parse(test);
        Assertions.assertEquals((Object)"", (Object)map.get((Object)VerwendungszweckUtil.Tag.SVWZ), (String)"SVWZ falsch");
    }

    @Test
    public void testParse007() throws Exception {
        String[] test = new String[]{};
        Map<VerwendungszweckUtil.Tag, String> map = VerwendungszweckUtil.parse(test);
        Assertions.assertEquals((int)0, (int)map.size(), (String)"Map falsch");
    }

    @Test
    public void testParse008() throws Exception {
        String[] test = new String[]{"Das ist eine Zeile ohne Tag ", "Fooo", "KREF+Und hier kommen ploetzlich noch Tags. Der Teil bis zum ersten Tag ist dann eigentlich der Verwendungszweck"};
        Map<VerwendungszweckUtil.Tag, String> map = VerwendungszweckUtil.parse(test);
        Assertions.assertEquals((Object)"Das ist eine Zeile ohne Tag Fooo", (Object)map.get((Object)VerwendungszweckUtil.Tag.SVWZ), (String)"SVWZ falsch");
        Assertions.assertEquals((Object)"Und hier kommen ploetzlich noch Tags. Der Teil bis zum ersten Tag ist dann eigentlich der Verwendungszweck", (Object)map.get((Object)VerwendungszweckUtil.Tag.KREF), (String)"KREF falsch");
    }

    @Test
    public void testParse009() throws Exception {
        String[] test = new String[]{"Wir koennen auch", "mit", "KREF: Doppelpunkt als Separatur umgehen"};
        Map<VerwendungszweckUtil.Tag, String> map = VerwendungszweckUtil.parse(test);
        Assertions.assertEquals((Object)"Wir koennen auchmit", (Object)map.get((Object)VerwendungszweckUtil.Tag.SVWZ), (String)"SVWZ falsch");
        Assertions.assertEquals((Object)"Doppelpunkt als Separatur umgehen", (Object)map.get((Object)VerwendungszweckUtil.Tag.KREF), (String)"KREF falsch");
    }

    @Test
    public void testParse010() throws Exception {
        String[] test = new String[]{"SVWZ+ Das geht sogar", " gemischt ", "IBAN: DE1234567890 "};
        Map<VerwendungszweckUtil.Tag, String> map = VerwendungszweckUtil.parse(test);
        Assertions.assertEquals((Object)"Das geht sogar gemischt IBAN: DE1234567890", (Object)map.get((Object)VerwendungszweckUtil.Tag.SVWZ), (String)"SVWZ falsch");
        Assertions.assertEquals((Object)"DE1234567890", (Object)map.get((Object)VerwendungszweckUtil.Tag.IBAN), (String)"IBAN falsch");
    }

    @Test
    public void testParse011() throws Exception {
        String[] test = new String[]{"IBAN: DE49390500000000012345 BIC: AACSDE33 ABWA: NetAachen"};
        Map<VerwendungszweckUtil.Tag, String> map = VerwendungszweckUtil.parse(test);
        Assertions.assertEquals((Object)"DE49390500000000012345", (Object)map.get((Object)VerwendungszweckUtil.Tag.IBAN), (String)"IBAN falsch");
        Assertions.assertEquals((Object)"AACSDE33", (Object)map.get((Object)VerwendungszweckUtil.Tag.BIC), (String)"BIC falsch");
        Assertions.assertEquals((Object)"NetAachen", (Object)map.get((Object)VerwendungszweckUtil.Tag.ABWA), (String)"ABWA falsch");
    }

    @Test
    public void testParse012() throws Exception {
        String[] test = new String[]{"SVWZ+BIC:GENODED1SAM ", "IBAN:DE12345678901234567890 ", "Datum: 14.01.16 Zeit: 08:00 ", "KD 00012345 TAN 12345 ", "Beleg 12345  Kunde 12345"};
        Map<VerwendungszweckUtil.Tag, String> map = VerwendungszweckUtil.parse(test);
        Assertions.assertEquals((Object)"DE12345678901234567890", (Object)map.get((Object)VerwendungszweckUtil.Tag.IBAN), (String)"IBAN falsch");
        Assertions.assertEquals((Object)"GENODED1SAM", (Object)map.get((Object)VerwendungszweckUtil.Tag.BIC), (String)"BIC falsch");
        Assertions.assertEquals((Object)"BIC:GENODED1SAM IBAN:DE12345678901234567890 Datum: 14.01.16 Zeit: 08:00 KD 00012345 TAN 12345 Beleg 12345  Kunde 12345", (Object)map.get((Object)VerwendungszweckUtil.Tag.SVWZ), (String)"SVWZ");
    }

    @Test
    public void testParse013() throws Exception {
        String[] test = new String[]{"Verwendungszweck EREF: 1234", "567890123456789 IBAN: DE123", "45678901234567890 BIC: ABCD", "EFGH"};
        Map<VerwendungszweckUtil.Tag, String> map = VerwendungszweckUtil.parse(test);
        Assertions.assertEquals((Object)"Verwendungszweck", (Object)map.get((Object)VerwendungszweckUtil.Tag.SVWZ), (String)"SVWZ falsch");
        Assertions.assertEquals((Object)"1234567890123456789", (Object)map.get((Object)VerwendungszweckUtil.Tag.EREF), (String)"EREF falsch");
        Assertions.assertEquals((Object)"DE12345678901234567890", (Object)map.get((Object)VerwendungszweckUtil.Tag.IBAN), (String)"IBAN falsch");
        Assertions.assertEquals((Object)"ABCDEFGH", (Object)map.get((Object)VerwendungszweckUtil.Tag.BIC), (String)"BIC falsch");
    }

    @Test
    public void testParse014() throws Exception {
        String[] test = new String[]{"SVWZ+Das ist Zeile 1", "2", "3"};
        Map<VerwendungszweckUtil.Tag, String> map = VerwendungszweckUtil.parse(test);
        Assertions.assertEquals((Object)"Das ist Zeile 123", (Object)map.get((Object)VerwendungszweckUtil.Tag.SVWZ), (String)"SVWZ falsch");
    }
}

