/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.rmi.Turnus;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import org.kapott.hbci.GV_Result.GVRDauerList;

public class TurnusHelper {
    private static String[] wochentage = null;
    private static final int[] DAYMAP = new int[]{2, 3, 4, 5, 6, 7, 1};

    public static String[] getWochentage() {
        if (wochentage != null) {
            return wochentage;
        }
        I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
        wochentage = new String[]{i18n.tr("Montag"), i18n.tr("Dienstag"), i18n.tr("Mittwoch"), i18n.tr("Donnerstag"), i18n.tr("Freitag"), i18n.tr("Samstag"), i18n.tr("Sonntag")};
        return wochentage;
    }

    public static String getWochentag(int index) {
        if (index < 1 || index > 7) {
            return null;
        }
        return TurnusHelper.getWochentage()[index - 1];
    }

    public static Date getNaechsteZahlung(Date ersteZahlung, Date letzteZahlung, Turnus turnus, Date valuta) throws RemoteException {
        if (ersteZahlung == null || turnus == null) {
            return null;
        }
        if (valuta == null) {
            valuta = new Date();
        }
        if (letzteZahlung != null && letzteZahlung.before(valuta)) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(ersteZahlung);
        cal.setFirstDayOfWeek(2);
        int ze = turnus.getZeiteinheit();
        int tag = turnus.getTag();
        int iv = turnus.getIntervall();
        Date test = null;
        int i = 0;
        while (i < 1000) {
            if (ze == 1) {
                int calTag = DAYMAP[tag - 1];
                cal.set(7, calTag);
                test = cal.getTime();
                if (letzteZahlung != null && test.after(letzteZahlung)) {
                    return null;
                }
                if (test.after(valuta) || test.equals(valuta)) {
                    return test;
                }
                cal.add(3, iv);
            } else {
                if (tag == HBCIProperties.HBCI_LAST_OF_MONTH) {
                    cal.set(5, cal.getActualMaximum(5));
                } else {
                    cal.set(5, tag);
                }
                test = cal.getTime();
                if (letzteZahlung != null && test.after(letzteZahlung)) {
                    return null;
                }
                if (test.after(valuta) || test.equals(valuta)) {
                    return test;
                }
                cal.add(2, iv);
            }
            ++i;
        }
        return null;
    }

    public static Turnus findByDauerAuftrag(GVRDauerList.Dauer d) throws RemoteException {
        int ze = 2;
        if ("W".equalsIgnoreCase(d.timeunit)) {
            ze = 1;
        }
        DBIterator list = Settings.getDBService().createList(Turnus.class);
        list.addFilter("zeiteinheit = " + ze);
        list.addFilter("intervall = " + d.turnus);
        list.addFilter("tag = " + d.execday);
        if (list.hasNext()) {
            return (Turnus)list.next();
        }
        return null;
    }

    public static Turnus createByDauerAuftrag(GVRDauerList.Dauer d) throws RemoteException, ApplicationException {
        Turnus turnus = TurnusHelper.findByDauerAuftrag(d);
        if (turnus != null) {
            return turnus;
        }
        int ze = 2;
        if ("W".equalsIgnoreCase(d.timeunit)) {
            ze = 1;
        }
        turnus = (Turnus)Settings.getDBService().createObject(Turnus.class, null);
        turnus.setIntervall(d.turnus);
        turnus.setTag(d.execday);
        turnus.setZeiteinheit(ze);
        turnus.store();
        return turnus;
    }

    public static String createBezeichnung(Turnus turnus) throws RemoteException {
        I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
        int iv = turnus.getIntervall();
        int ze = turnus.getZeiteinheit();
        int ta = turnus.getTag();
        String s = null;
        if (iv == 1 && ze == 2) {
            s = i18n.tr("Monatlich");
        } else if (iv == 1 && ze == 1) {
            s = i18n.tr("W\u00f6chentlich");
        }
        if (iv > 1 && ze == 2) {
            s = i18n.tr("Alle {0} Monate", "" + iv);
        } else if (iv > 1 && ze == 1) {
            s = i18n.tr("Alle {0} Wochen", "" + iv);
        }
        if (iv == 3 && ze == 2) {
            s = i18n.tr("Viertelj\u00e4hrlich");
        }
        if (iv == 6 && ze == 2) {
            s = i18n.tr("Halbj\u00e4hrlich");
        }
        if (iv == 12 && ze == 2) {
            s = i18n.tr("J\u00e4hrlich");
        }
        if (ze == 1) {
            s = String.valueOf(s) + ", " + TurnusHelper.getWochentag(ta);
        } else if (ze == 2) {
            s = ta == HBCIProperties.HBCI_LAST_OF_MONTH ? String.valueOf(s) + ", " + i18n.tr("zum Monatsletzten") : String.valueOf(s) + ", " + i18n.tr("am {0}. des Monats", "" + ta);
        }
        return s;
    }
}

