/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.rmi.Turnus;
import de.willuhn.jameica.hbci.server.AbstractHibiscusDBObject;
import de.willuhn.jameica.hbci.server.TurnusHelper;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.zip.CRC32;

public class TurnusImpl
extends AbstractHibiscusDBObject
implements Turnus {
    private static final transient I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    protected String getTableName() {
        return "turnus";
    }

    public String getPrimaryAttribute() throws RemoteException {
        return "bezeichnung";
    }

    protected void deleteCheck() throws ApplicationException {
        try {
            if (this.isInitial()) {
                throw new ApplicationException(i18n.tr("Turnus ist Bestandteil der System-Daten und kann nicht gel\u00f6scht werden."));
            }
        }
        catch (RemoteException e) {
            Logger.error((String)"error in turnus deletCheck", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim L\u00f6schen des Turnus"));
        }
    }

    protected void insertCheck() throws ApplicationException {
        try {
            if (this.getZeiteinheit() != 2 && this.getZeiteinheit() != 1) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie eine g\u00fcltige Zeiteinheit aus"));
            }
            if (this.getIntervall() < 1) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie ein g\u00fcltiges Intervall ein"));
            }
            if (this.getZeiteinheit() == 2 && (this.getTag() < 1 || this.getTag() > 31) && this.getTag() != HBCIProperties.HBCI_LAST_OF_MONTH) {
                throw new ApplicationException(i18n.tr("Bei monatlicher Zeiteinheit darf der Zahltag nicht kleiner als 1 und nicht gr\u00f6\u00dfer als 31 sein. Angegebener Tag: {0}", "" + this.getTag()));
            }
            if (this.getZeiteinheit() == 1 && (this.getTag() < 1 || this.getTag() > 7)) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen g\u00fcltigen Wochentag"));
            }
        }
        catch (RemoteException e) {
            Logger.error((String)"error in turnus insertCheck", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim Speichern des Turnus"));
        }
    }

    protected void updateCheck() throws ApplicationException {
        this.insertCheck();
    }

    @Override
    public String getBezeichnung() throws RemoteException {
        return TurnusHelper.createBezeichnung(this);
    }

    @Override
    public int getIntervall() throws RemoteException {
        Integer i = (Integer)this.getAttribute("intervall");
        if (i == null) {
            return 1;
        }
        return i;
    }

    @Override
    public void setIntervall(int intervall) throws RemoteException {
        this.setAttribute("intervall", intervall);
    }

    @Override
    public int getZeiteinheit() throws RemoteException {
        Integer i = (Integer)this.getAttribute("zeiteinheit");
        if (i == null) {
            return 2;
        }
        return i;
    }

    @Override
    public void setZeiteinheit(int zeiteinheit) throws RemoteException {
        this.setAttribute("zeiteinheit", zeiteinheit);
    }

    @Override
    public int getTag() throws RemoteException {
        Integer i = (Integer)this.getAttribute("tag");
        if (i == null) {
            return 1;
        }
        return i;
    }

    @Override
    public void setTag(int tag) throws RemoteException {
        this.setAttribute("tag", tag);
    }

    @Override
    public boolean isInitial() throws RemoteException {
        return this.getAttribute("initial") != null;
    }

    @Override
    public long getChecksum() throws RemoteException {
        String s = "" + this.getIntervall() + this.getTag() + this.getZeiteinheit();
        CRC32 crc = new CRC32();
        crc.update(s.getBytes());
        return crc.getValue();
    }

    public Object getAttribute(String arg0) throws RemoteException {
        if ("bezeichnung".equals(arg0)) {
            return this.getBezeichnung();
        }
        return super.getAttribute(arg0);
    }

    public void insert() throws RemoteException, ApplicationException {
        DBIterator existing = this.getService().createList(Turnus.class);
        existing.addFilter("zeiteinheit = " + this.getZeiteinheit());
        existing.addFilter("intervall = " + this.getIntervall());
        existing.addFilter("tag = " + this.getTag());
        if (existing.hasNext()) {
            Logger.info((String)("turnus \"" + TurnusHelper.createBezeichnung(this) + "\" already exists, skipping insert"));
            return;
        }
        super.insert();
    }
}

