/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.rmi.Ueberweisung;
import de.willuhn.jameica.hbci.server.AbstractBaseUeberweisungImpl;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;

public class UeberweisungImpl
extends AbstractBaseUeberweisungImpl
implements Ueberweisung {
    private static final transient I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    protected String getTableName() {
        return "ueberweisung";
    }

    @Override
    protected void insertCheck() throws ApplicationException {
        super.insertCheck();
        try {
            String usage;
            String key;
            if (this.isUmbuchung()) {
                String src;
                if (this.isTerminUeberweisung()) {
                    Logger.error((String)"SUSPECT: the gui should block both - \"umbuchung\" and \"terminueberweisung\"");
                    throw new ApplicationException(i18n.tr("Eine Umbuchung kann nicht als Termin-Auftrag gesendet werden"));
                }
                String dest = this.getGegenkontoBLZ();
                if (!dest.equals(src = this.getKonto().getBLZ())) {
                    throw new ApplicationException(i18n.tr("Umbuchungen sind nur zu einem Konto bei Ihrer eigenen Bank m\u00f6glich"));
                }
            }
            if ((key = this.getTextSchluessel()) != null && key.equals("67")) {
                usage = this.getZweck();
                if (usage == null || usage.length() == 0) {
                    throw new ApplicationException(i18n.tr("Bitte geben Sie die {0}-stellige BZ\u00dc-Pr\u00fcfziffer ein.", Integer.toString(HBCIProperties.HBCI_TRANSFER_BZU_LENGTH)));
                }
                if (!usage.matches("^[" + HBCIProperties.HBCI_BZU_VALIDCHARS + "]{" + HBCIProperties.HBCI_TRANSFER_BZU_LENGTH + "}$")) {
                    throw new ApplicationException(i18n.tr("Die BZ\u00dc-Pr\u00fcfziffer muss exakt {0} Ziffern enthalten", Integer.toString(HBCIProperties.HBCI_TRANSFER_BZU_LENGTH)));
                }
            } else if (key != null && key.equals("69")) {
                usage = this.getZweck();
                String usage2 = this.getZweck2();
                String[] wvz = this.getWeitereVerwendungszwecke();
                if (usage == null || usage.trim().length() == 0) {
                    throw new ApplicationException(i18n.tr("Bitte geben Sie die Spenden-/Mitgliedsnummer oder den Namen des Spenders ein"));
                }
                if (usage2 == null || usage2.trim().length() == 0) {
                    throw new ApplicationException(i18n.tr("Bitte geben Sie Postleitzahl und Strasse des Spenders ein"));
                }
                if (wvz == null || wvz.length == 0) {
                    throw new ApplicationException(i18n.tr("Bitte geben Sie Name und Ort des Kontoinhabers/Einzahlers ein"));
                }
            }
        }
        catch (RemoteException e) {
            Logger.error((String)"error while checking transfer", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim Pr\u00fcfen des Auftrages."));
        }
    }

    @Override
    public boolean isTerminUeberweisung() throws RemoteException {
        Integer i = (Integer)this.getAttribute("banktermin");
        return i != null && i == 1;
    }

    @Override
    public void setTerminUeberweisung(boolean termin) throws RemoteException {
        this.setAttribute("banktermin", termin ? Integer.valueOf(1) : null);
    }

    @Override
    public boolean ueberfaellig() throws RemoteException {
        if (this.isTerminUeberweisung()) {
            return !this.ausgefuehrt();
        }
        return super.ueberfaellig();
    }

    @Override
    public boolean isUmbuchung() throws RemoteException {
        Integer i = (Integer)this.getAttribute("umbuchung");
        return i != null && i == 1;
    }

    @Override
    public void setUmbuchung(boolean b) throws RemoteException {
        this.setAttribute("umbuchung", b ? Integer.valueOf(1) : null);
    }
}

