/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.GenericObjectNode;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.rmi.UmsatzTyp;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class UmsatzGroup
implements GenericObjectNode,
Comparable {
    private static final transient I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private UmsatzTyp typ = null;
    private ArrayList umsaetze = new ArrayList();

    public UmsatzGroup(UmsatzTyp typ) {
        this.typ = typ;
    }

    public UmsatzTyp getUmsatzTyp() {
        return this.typ;
    }

    public void add(Umsatz umsatz) {
        this.umsaetze.add(umsatz);
    }

    public GenericIterator getChildren() throws RemoteException {
        return PseudoIterator.fromArray((GenericObject[])this.umsaetze.toArray(new GenericObject[0]));
    }

    public GenericObjectNode getParent() throws RemoteException {
        return null;
    }

    public GenericIterator getPath() throws RemoteException {
        return null;
    }

    public GenericIterator getPossibleParents() throws RemoteException {
        return null;
    }

    public boolean hasChild(GenericObjectNode node) throws RemoteException {
        int i = 0;
        while (i < this.umsaetze.size()) {
            GenericObject o = (GenericObject)this.umsaetze.get(i);
            if (o.equals((GenericObject)node)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean equals(GenericObject other) throws RemoteException {
        if (other == null || !(other instanceof UmsatzGroup)) {
            return false;
        }
        return this.getID().equals(other.getID());
    }

    public Object getAttribute(String arg0) throws RemoteException {
        if (this.typ == null && "name".equalsIgnoreCase(arg0)) {
            return i18n.tr("Nicht zugeordnet");
        }
        if ("betrag".equalsIgnoreCase(arg0)) {
            double betrag = 0.0;
            int i = 0;
            while (i < this.umsaetze.size()) {
                Umsatz u = (Umsatz)this.umsaetze.get(i);
                betrag += u.getBetrag();
                ++i;
            }
            return betrag;
        }
        return this.typ == null ? null : this.typ.getAttribute(arg0);
    }

    public String[] getAttributeNames() throws RemoteException {
        String[] stringArray;
        if (this.typ == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "name";
        } else {
            stringArray = this.typ.getAttributeNames();
        }
        return stringArray;
    }

    public String getID() throws RemoteException {
        return this.typ == null ? "<unassigned>" : this.typ.getID();
    }

    public String getPrimaryAttribute() throws RemoteException {
        return this.typ == null ? "name" : this.typ.getPrimaryAttribute();
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof UmsatzGroup)) {
            return -1;
        }
        if (this.typ == null) {
            return -1;
        }
        UmsatzGroup other = (UmsatzGroup)o;
        if (other.typ == null) {
            return 1;
        }
        try {
            int numberCompare;
            String na2;
            String na1;
            String n2;
            int thisType = this.typ.getTyp();
            int otherType = other.typ.getTyp();
            if (thisType != otherType) {
                return thisType < otherType ? -1 : 1;
            }
            String n1 = this.typ.getNummer();
            if (n1 == null) {
                n1 = "";
            }
            if ((n2 = other.typ.getNummer()) == null) {
                n2 = "";
            }
            if ((na1 = this.typ.getName()) == null) {
                na1 = "";
            }
            if ((na2 = other.typ.getName()) == null) {
                na2 = "";
            }
            if ((numberCompare = n1.compareTo(n2)) != 0) {
                return numberCompare;
            }
            return na1.compareTo(na2);
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to determine umsatztyp number", (Throwable)re);
            return 0;
        }
    }
}

