/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.rmi.Address;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.rmi.UmsatzTyp;
import de.willuhn.jameica.hbci.server.AbstractHibiscusDBObject;
import de.willuhn.jameica.hbci.server.Cache;
import de.willuhn.jameica.hbci.server.UmsatzTypUtil;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.zip.CRC32;
import org.apache.commons.lang.StringUtils;

public class UmsatzImpl
extends AbstractHibiscusDBObject
implements Umsatz {
    private static final transient I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    protected String getTableName() {
        return "umsatz";
    }

    public String getPrimaryAttribute() throws RemoteException {
        return "zweck";
    }

    protected void insertCheck() throws ApplicationException {
        try {
            if (Double.isNaN(this.getBetrag())) {
                throw new ApplicationException(i18n.tr("Betrag ung\u00fcltig."));
            }
            if (this.getDatum() == null) {
                throw new ApplicationException(i18n.tr("Datum fehlt."));
            }
            if (this.getKonto() == null) {
                throw new ApplicationException(i18n.tr("Umsatz muss einem Konto zugewiesen sein."));
            }
            if (this.getValuta() == null) {
                throw new ApplicationException(i18n.tr("Valuta fehlt."));
            }
            HBCIProperties.checkLength(this.getZweck(), 255);
            int limit = HBCIProperties.HBCI_TRANSFER_USAGE_DB_MAXLENGTH;
            HBCIProperties.checkLength(this.getZweck2(), limit);
            String[] ewz = this.getWeitereVerwendungszwecke();
            if (ewz != null && ewz.length > 0) {
                int i = 0;
                while (i < ewz.length) {
                    HBCIProperties.checkLength(ewz[i], limit);
                    ++i;
                }
            }
            HBCIProperties.checkLength(this.getGvCode(), HBCIProperties.HBCI_GVCODE_MAXLENGTH);
            HBCIProperties.checkLength(this.getAddKey(), HBCIProperties.HBCI_ADDKEY_MAXLENGTH);
            HBCIProperties.checkLength(this.getCreditorId(), HBCIProperties.HBCI_SEPA_CREDITORID_MAXLENGTH);
        }
        catch (RemoteException e) {
            Logger.error((String)"error while insertcheck in umsatz", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim Speichern des Umsatzes"));
        }
    }

    protected void updateCheck() throws ApplicationException {
        this.insertCheck();
    }

    public void insert() throws RemoteException, ApplicationException {
        this.setAttribute("checksum", this.getChecksum());
        super.insert();
    }

    @Override
    public Konto getKonto() throws RemoteException {
        Integer i = (Integer)super.getAttribute("konto_id");
        if (i == null) {
            return null;
        }
        Cache cache = Cache.get(Konto.class, true);
        return (Konto)cache.get(i);
    }

    @Override
    public String getGegenkontoName() throws RemoteException {
        return (String)this.getAttribute("empfaenger_name");
    }

    @Override
    public String getGegenkontoNummer() throws RemoteException {
        return (String)this.getAttribute("empfaenger_konto");
    }

    @Override
    public String getGegenkontoBLZ() throws RemoteException {
        return (String)this.getAttribute("empfaenger_blz");
    }

    @Override
    public double getBetrag() throws RemoteException {
        Double d = (Double)this.getAttribute("betrag");
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    @Override
    public Date getDatum() throws RemoteException {
        return (Date)this.getAttribute("datum");
    }

    @Override
    public Date getValuta() throws RemoteException {
        return (Date)this.getAttribute("valuta");
    }

    @Override
    public String getZweck() throws RemoteException {
        return (String)this.getAttribute("zweck");
    }

    @Override
    public String getZweck2() throws RemoteException {
        return (String)this.getAttribute("zweck2");
    }

    @Override
    public void setGegenkonto(Address e) throws RemoteException {
        if (e == null) {
            return;
        }
        String kto = e.getIban();
        String blz = e.getBic();
        if (kto == null || kto.length() == 0) {
            kto = e.getKontonummer();
        }
        if (blz == null || blz.length() == 0) {
            blz = e.getBlz();
        }
        this.setGegenkontoNummer(kto);
        this.setGegenkontoBLZ(blz);
        this.setGegenkontoName(e.getName());
    }

    @Override
    public void setGegenkontoName(String name) throws RemoteException {
        this.setAttribute("empfaenger_name", name);
    }

    @Override
    public void setGegenkontoNummer(String konto) throws RemoteException {
        this.setAttribute("empfaenger_konto", konto);
    }

    @Override
    public void setGegenkontoBLZ(String blz) throws RemoteException {
        this.setAttribute("empfaenger_blz", blz);
    }

    @Override
    public void setBetrag(double d) throws RemoteException {
        this.setAttribute("betrag", d);
    }

    @Override
    public void setZweck(String zweck) throws RemoteException {
        this.setAttribute("zweck", zweck);
    }

    @Override
    public void setZweck2(String zweck2) throws RemoteException {
        this.setAttribute("zweck2", zweck2);
    }

    @Override
    public void setDatum(Date d) throws RemoteException {
        this.setAttribute("datum", d);
    }

    @Override
    public void setValuta(Date d) throws RemoteException {
        this.setAttribute("valuta", d);
    }

    @Override
    public void setKonto(Konto k) throws RemoteException {
        this.setAttribute("konto_id", k == null || k.getID() == null ? null : Integer.valueOf(k.getID()));
    }

    public boolean equals(GenericObject o) throws RemoteException {
        if (o == null || !(o instanceof Umsatz)) {
            return false;
        }
        try {
            Umsatz other = (Umsatz)o;
            String id1 = this.getID();
            String id2 = other.getID();
            if (id1 != null && id2 != null) {
                return id1.equals(id2);
            }
            id1 = this.getTransactionId();
            id2 = other.getTransactionId();
            if (id1 != null && id2 != null) {
                return id1.equals(id2);
            }
            return other.getChecksum() == this.getChecksum();
        }
        catch (Exception e) {
            Logger.error((String)"error while comparing objects", (Throwable)e);
            return false;
        }
    }

    @Override
    public double getSaldo() throws RemoteException {
        Double d = (Double)this.getAttribute("saldo");
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    @Override
    public String getPrimanota() throws RemoteException {
        return (String)this.getAttribute("primanota");
    }

    @Override
    public String getArt() throws RemoteException {
        return (String)this.getAttribute("art");
    }

    @Override
    public String getCustomerRef() throws RemoteException {
        return (String)this.getAttribute("customerref");
    }

    @Override
    public void setSaldo(double s) throws RemoteException {
        this.setAttribute("saldo", s);
    }

    @Override
    public void setPrimanota(String primanota) throws RemoteException {
        this.setAttribute("primanota", primanota);
    }

    @Override
    public void setArt(String art) throws RemoteException {
        this.setAttribute("art", art);
    }

    @Override
    public void setCustomerRef(String ref) throws RemoteException {
        this.setAttribute("customerref", ref);
    }

    @Override
    public long getChecksum() throws RemoteException {
        Number n = (Number)this.getAttribute("checksum");
        if (n != null && n.longValue() != 0L) {
            return n.longValue();
        }
        Date datum = this.getDatum();
        Date valuta = this.getValuta();
        String sd = "";
        String sv = "";
        if (datum != null) {
            try {
                sd = HBCI.DATEFORMAT.format(datum);
            }
            catch (Exception e) {
                sd = datum.toString();
            }
        }
        if (valuta != null) {
            try {
                sv = HBCI.DATEFORMAT.format(valuta);
            }
            catch (Exception e) {
                sv = valuta.toString();
            }
        }
        String s = String.valueOf(this.getArt().toUpperCase()) + this.getKonto().getID() + this.getBetrag() + this.getCustomerRef() + this.getGegenkontoBLZ() + this.getGegenkontoNummer() + this.getGegenkontoName().toUpperCase() + this.getPrimanota() + (Settings.getSaldoInChecksum() ? Double.valueOf(this.getSaldo()) : "") + ((String)this.getAttribute("mergedzweck")).toUpperCase() + sd + sv;
        if (this.hasFlag(2)) {
            s = String.valueOf(s) + "notbooked";
        }
        CRC32 crc = new CRC32();
        crc.update(s.getBytes());
        return crc.getValue();
    }

    public Object getAttribute(String arg0) throws RemoteException {
        if ("umsatztyp".equals(arg0)) {
            return this.getUmsatzTyp();
        }
        if ("konto_id".equals(arg0)) {
            return this.getKonto();
        }
        if ("name".equals(arg0)) {
            arg0 = "empfaenger";
        }
        if ("valuta_pseudo".equals(arg0)) {
            return this.getPseudoDate(this.getValuta());
        }
        if ("datum_pseudo".equals(arg0)) {
            return this.getPseudoDate(this.getDatum());
        }
        if ("id-int".equals(arg0)) {
            try {
                return Integer.valueOf(this.getID());
            }
            catch (Exception e) {
                Logger.error((String)("unable to parse id: " + this.getID()));
                return this.getID();
            }
        }
        if ("mergedzweck".equals(arg0)) {
            return VerwendungszweckUtil.toString(this);
        }
        VerwendungszweckUtil.Tag tag = VerwendungszweckUtil.Tag.byName(arg0);
        if (tag != null) {
            return VerwendungszweckUtil.getTag(this, tag);
        }
        if ("empfaenger".equals(arg0)) {
            String name = this.getGegenkontoName();
            String name2 = this.getGegenkontoName2();
            boolean hasName = StringUtils.isNotBlank((String)name);
            boolean hasName2 = StringUtils.isNotBlank((String)name2);
            if (hasName || hasName2) {
                if (hasName && hasName2) {
                    return String.valueOf(name2) + " - " + name;
                }
                return hasName ? name : name2;
            }
            if (name != null) {
                return name;
            }
            String kto = this.getGegenkontoNummer();
            String blz = this.getGegenkontoBLZ();
            if (kto == null || kto.length() == 0 || blz == null || blz.length() == 0) {
                return null;
            }
            return i18n.tr("Kto. {0}, BLZ {1}", new String[]{kto, blz});
        }
        return super.getAttribute(arg0);
    }

    private Date getPseudoDate(Date date) throws RemoteException {
        if (date == null) {
            return null;
        }
        try {
            return new Date(date.getTime() + Long.parseLong(this.getID()));
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            Logger.error((String)("unable append pseudo time to " + date + " for ID: " + this.getID()));
            return date;
        }
    }

    @Override
    public void delete() throws RemoteException, ApplicationException {
        try {
            this.transactionBegin();
            Konto k = this.getKonto();
            super.delete();
            if (k != null) {
                String[] fields = new String[]{this.getGegenkontoName(), this.getGegenkontoNummer(), this.getGegenkontoBLZ(), HBCI.DATEFORMAT.format(this.getDatum()), this.getZweck(), String.valueOf(k.getWaehrung()) + " " + HBCI.DECIMALFORMAT.format(this.getBetrag())};
                if (!this.hasFlag(2)) {
                    k.addToProtokoll(i18n.tr("Umsatz [Gegenkonto: {0}, Kto. {1} BLZ {2}], Datum {3}, Zweck: {4}] {5} gel\u00f6scht", fields), 1);
                }
            }
            this.transactionCommit();
        }
        catch (ApplicationException | RemoteException e) {
            try {
                this.transactionRollback();
            }
            catch (Exception e2) {
                Logger.error((String)"unable to rollback transaction", (Throwable)e2);
            }
            throw e;
        }
    }

    @Override
    public String getKommentar() throws RemoteException {
        return (String)this.getAttribute("kommentar");
    }

    @Override
    public void setKommentar(String kommentar) throws RemoteException {
        this.setAttribute("kommentar", kommentar);
    }

    @Override
    public UmsatzTyp getUmsatzTyp() throws RemoteException {
        Integer i = (Integer)super.getAttribute("umsatztyp_id");
        Cache cache = Cache.get(UmsatzTyp.class, new Cache.ObjectFactory(){

            @Override
            public DBIterator load() throws RemoteException {
                return UmsatzTypUtil.getAll();
            }
        }, true);
        if (i != null) {
            return (UmsatzTyp)cache.get(i);
        }
        for (UmsatzTyp umsatzTyp : cache.values()) {
            if (!umsatzTyp.matches(this)) continue;
            return umsatzTyp;
        }
        return null;
    }

    @Override
    public void setUmsatzTyp(UmsatzTyp ut) throws RemoteException {
        this.setAttribute("umsatztyp_id", ut == null ? null : Integer.valueOf(ut.getID()));
    }

    @Override
    public boolean isAssigned() throws RemoteException {
        return super.getAttribute("umsatztyp_id") != null;
    }

    @Override
    public String[] getWeitereVerwendungszwecke() throws RemoteException {
        return VerwendungszweckUtil.split((String)this.getAttribute("zweck3"));
    }

    @Override
    public void setWeitereVerwendungszwecke(String[] list) throws RemoteException {
        String s = VerwendungszweckUtil.merge(list);
        try {
            if (s != null && s.length() > 1000) {
                s = s.substring(0, 1000);
            }
        }
        catch (Exception e) {
            Logger.error((String)"invalid usage", (Throwable)e);
        }
        this.setAttribute("zweck3", s);
    }

    @Override
    public int getFlags() throws RemoteException {
        Integer i = (Integer)this.getAttribute("flags");
        return i == null ? 0 : i;
    }

    @Override
    public boolean hasFlag(int flag) throws RemoteException {
        return (this.getFlags() & flag) == flag;
    }

    @Override
    public void setFlags(int flags) throws RemoteException {
        if (flags < 0) {
            return;
        }
        this.setAttribute("flags", flags);
    }

    @Override
    public String getGvCode() throws RemoteException {
        return (String)this.getAttribute("gvcode");
    }

    @Override
    public void setGvCode(String code) throws RemoteException {
        this.setAttribute("gvcode", code);
    }

    @Override
    public String getAddKey() throws RemoteException {
        return (String)this.getAttribute("addkey");
    }

    @Override
    public void setAddKey(String key) throws RemoteException {
        this.setAttribute("addkey", key);
    }

    @Override
    public Umsatz duplicate() throws RemoteException {
        Umsatz copy = (Umsatz)this.getService().createObject(Umsatz.class, null);
        copy.setArt(this.getArt());
        copy.setBetrag(this.getBetrag());
        copy.setCustomerRef(this.getCustomerRef());
        copy.setDatum(this.getDatum());
        copy.setFlags(this.getFlags());
        copy.setGegenkontoBLZ(this.getGegenkontoBLZ());
        copy.setGegenkontoName(this.getGegenkontoName());
        copy.setGegenkontoName2(this.getGegenkontoName2());
        copy.setGegenkontoNummer(this.getGegenkontoNummer());
        copy.setKommentar(this.getKommentar());
        copy.setKonto(this.getKonto());
        copy.setPrimanota(this.getPrimanota());
        copy.setSaldo(this.getSaldo());
        copy.setUmsatzTyp(this.getUmsatzTyp());
        copy.setValuta(this.getValuta());
        copy.setZweck(this.getZweck());
        copy.setZweck2(this.getZweck2());
        copy.setWeitereVerwendungszwecke(this.getWeitereVerwendungszwecke());
        copy.setGvCode(this.getGvCode());
        copy.setPurposeCode(this.getPurposeCode());
        copy.setEndToEndId(this.getEndToEndId());
        copy.setMandateId(this.getMandateId());
        copy.setCreditorId(this.getCreditorId());
        return copy;
    }

    @Override
    public String getTransactionId() throws RemoteException {
        return (String)this.getAttribute("txid");
    }

    @Override
    public void setTransactionId(String id) throws RemoteException {
        this.setAttribute("txid", id);
    }

    @Override
    public String getPurposeCode() throws RemoteException {
        return (String)this.getAttribute("purposecode");
    }

    @Override
    public void setPurposeCode(String code) throws RemoteException {
        this.setAttribute("purposecode", code);
    }

    @Override
    public String getEndToEndId() throws RemoteException {
        return (String)this.getAttribute("endtoendid");
    }

    @Override
    public void setEndToEndId(String id) throws RemoteException {
        this.setAttribute("endtoendid", id);
    }

    @Override
    public String getMandateId() throws RemoteException {
        return (String)this.getAttribute("mandateid");
    }

    @Override
    public void setMandateId(String id) throws RemoteException {
        this.setAttribute("mandateid", id);
    }

    @Override
    public String getGegenkontoName2() throws RemoteException {
        return (String)this.getAttribute("empfaenger_name2");
    }

    @Override
    public void setGegenkontoName2(String name) throws RemoteException {
        this.setAttribute("empfaenger_name2", name);
    }

    @Override
    public String getCreditorId() throws RemoteException {
        return (String)this.getAttribute("creditorid");
    }

    @Override
    public void setCreditorId(String name) throws RemoteException {
        this.setAttribute("creditorid", name);
    }
}

