/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.GenericObjectNode;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.rmi.UmsatzTyp;
import de.willuhn.jameica.hbci.server.UmsatzTypUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UmsatzTreeNode
implements GenericObjectNode,
Comparable {
    private static final transient I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private UmsatzTyp typ = null;
    private UmsatzTreeNode parent = null;
    private List<UmsatzTreeNode> children = new ArrayList<UmsatzTreeNode>();
    private List<Umsatz> umsaetze = new ArrayList<Umsatz>();
    private Double betrag = null;
    private Double einnahmen = null;
    private Double ausgaben = null;

    public UmsatzTreeNode(UmsatzTyp typ) {
        this.typ = typ;
    }

    public UmsatzTyp getUmsatzTyp() {
        return this.typ;
    }

    public void add(Umsatz umsatz) {
        this.umsaetze.add(umsatz);
    }

    public void setParent(UmsatzTreeNode parent) {
        this.parent = parent;
    }

    public List<Umsatz> getUmsaetze() {
        return this.umsaetze;
    }

    public List<UmsatzTreeNode> getSubGroups() {
        return this.children;
    }

    public GenericIterator getChildren() throws RemoteException {
        ArrayList<Object> all = new ArrayList<Object>();
        List<UmsatzTreeNode> children = this.getSubGroups();
        Collections.sort(children);
        all.addAll(children);
        all.addAll(this.umsaetze);
        return PseudoIterator.fromArray((GenericObject[])all.toArray(new GenericObject[0]));
    }

    public GenericObjectNode getParent() throws RemoteException {
        return this.parent;
    }

    public GenericIterator getPath() throws RemoteException {
        return null;
    }

    public GenericIterator getPossibleParents() throws RemoteException {
        return null;
    }

    public boolean hasChild(GenericObjectNode node) throws RemoteException {
        int i = 0;
        while (i < this.umsaetze.size()) {
            Umsatz u = this.umsaetze.get(i);
            if (u.equals((GenericObject)node)) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < this.children.size()) {
            UmsatzTreeNode g = this.children.get(i);
            if (g.equals((GenericObject)node)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean equals(GenericObject other) throws RemoteException {
        if (other == null || !(other instanceof UmsatzTreeNode)) {
            return false;
        }
        return this.getID().equals(other.getID());
    }

    public Object getAttribute(String arg0) throws RemoteException {
        if (this.typ == null && "name".equalsIgnoreCase(arg0)) {
            return i18n.tr("Nicht zugeordnet");
        }
        if ("betrag".equalsIgnoreCase(arg0)) {
            this.calculateSums();
            return this.betrag;
        }
        if ("einnahmen".equalsIgnoreCase(arg0)) {
            this.calculateSums();
            return this.einnahmen;
        }
        if ("ausgaben".equalsIgnoreCase(arg0)) {
            this.calculateSums();
            return this.ausgaben;
        }
        return this.typ == null ? null : this.typ.getAttribute(arg0);
    }

    private void calculateSums() throws RemoteException {
        if (this.betrag != null && this.einnahmen != null && this.ausgaben != null) {
            return;
        }
        double betrag = 0.0;
        double einnahmen = 0.0;
        double ausgaben = 0.0;
        int i = 0;
        while (i < this.umsaetze.size()) {
            Umsatz u = this.umsaetze.get(i);
            double d = u.getBetrag();
            betrag += d;
            if (d > 0.0) {
                einnahmen += d;
            } else {
                ausgaben += d;
            }
            ++i;
        }
        i = 0;
        while (i < this.children.size()) {
            UmsatzTreeNode ug = this.children.get(i);
            Double d = (Double)ug.getAttribute("betrag");
            betrag += d.doubleValue();
            d = (Double)ug.getAttribute("einnahmen");
            einnahmen += d.doubleValue();
            d = (Double)ug.getAttribute("ausgaben");
            ausgaben += d.doubleValue();
            ++i;
        }
        this.betrag = betrag;
        this.einnahmen = einnahmen;
        this.ausgaben = ausgaben;
    }

    public String[] getAttributeNames() throws RemoteException {
        String[] stringArray;
        if (this.typ == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "name";
        } else {
            stringArray = this.typ.getAttributeNames();
        }
        return stringArray;
    }

    public String getID() throws RemoteException {
        return this.typ == null ? "<unassigned>" : this.typ.getID();
    }

    public String getPrimaryAttribute() throws RemoteException {
        return this.typ == null ? "name" : this.typ.getPrimaryAttribute();
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof UmsatzTreeNode)) {
            return -1;
        }
        UmsatzTreeNode other = (UmsatzTreeNode)o;
        try {
            return UmsatzTypUtil.compare(this.typ, other.typ);
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to compare categories", (Throwable)re);
            return 0;
        }
    }
}

