/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.GenericObjectNode;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.jameica.hbci.rmi.UmsatzTyp;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class UmsatzTypBean
implements GenericObjectNode {
    private UmsatzTypBean parent = null;
    private List<UmsatzTypBean> children = new LinkedList<UmsatzTypBean>();
    private UmsatzTyp typ = null;
    private Integer level = null;

    public UmsatzTypBean(UmsatzTyp typ) {
        this.typ = typ;
    }

    void collectChildren(List<UmsatzTypBean> all) throws RemoteException {
        for (UmsatzTypBean child : all) {
            String pid;
            Object parent = child.typ.getAttribute("parent_id");
            if (parent == null) continue;
            String string = pid = parent instanceof GenericObject ? ((GenericObject)parent).getID() : parent.toString();
            if (pid == null || !pid.equals(this.typ.getID())) continue;
            child.parent = this;
            this.children.add(child);
            child.collectChildren(all);
        }
    }

    public UmsatzTypBean getParent() {
        return this.parent;
    }

    public UmsatzTyp getTyp() {
        return this.typ;
    }

    public int getLevel() {
        if (this.level != null) {
            return this.level;
        }
        int depth = 0;
        UmsatzTypBean parent = this.getParent();
        int i = 0;
        while (i < 100) {
            if (parent == null) break;
            ++depth;
            parent = parent.getParent();
            ++i;
        }
        this.level = depth;
        return this.level;
    }

    public String getIndented() throws RemoteException {
        return String.valueOf(StringUtils.repeat((String)"    ", (int)this.getLevel())) + this.typ.getName();
    }

    public String getPathName() throws RemoteException {
        if (this.parent == null) {
            return this.typ.getName();
        }
        return String.valueOf(this.parent.getPathName()) + "/" + this.typ.getName();
    }

    public boolean equals(GenericObject arg0) throws RemoteException {
        if (arg0 == null || !(arg0 instanceof UmsatzTypBean)) {
            return false;
        }
        UmsatzTypBean other = (UmsatzTypBean)arg0;
        return this.typ.equals((GenericObject)other.typ);
    }

    public Object getAttribute(String arg0) throws RemoteException {
        if (arg0 != null && arg0.equals("indented")) {
            return this.getIndented();
        }
        return this.typ.getAttribute(arg0);
    }

    public String[] getAttributeNames() throws RemoteException {
        return this.typ.getAttributeNames();
    }

    public String getID() throws RemoteException {
        return this.typ.getID();
    }

    public String getPrimaryAttribute() throws RemoteException {
        return this.typ.getPrimaryAttribute();
    }

    public GenericIterator getChildren() throws RemoteException {
        return PseudoIterator.fromArray((GenericObject[])((GenericObject[])this.children.toArray(new UmsatzTypBean[0])));
    }

    public GenericIterator getPath() throws RemoteException {
        LinkedList<UmsatzTypBean> result = new LinkedList<UmsatzTypBean>();
        UmsatzTypBean parent = this.getParent();
        int i = 0;
        while (i < 100) {
            if (parent == null) break;
            result.add(parent);
            parent = parent.getParent();
            ++i;
        }
        return PseudoIterator.fromArray((GenericObject[])((GenericObject[])result.toArray(new UmsatzTypBean[0])));
    }

    public GenericIterator getPossibleParents() throws RemoteException {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean hasChild(GenericObjectNode node) throws RemoteException {
        if (node == null) {
            return false;
        }
        for (UmsatzTypBean child : this.children) {
            if (BeanUtil.equals((Object)child, (Object)node)) {
                return true;
            }
            if (!child.hasChild(node)) continue;
            return true;
        }
        return false;
    }
}

