/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.GenericObjectNode;
import de.willuhn.datasource.db.AbstractDBObjectNode;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.datasource.rmi.DBObject;
import de.willuhn.datasource.rmi.DBObjectNode;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.Duplicatable;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.rmi.UmsatzTyp;
import de.willuhn.jameica.hbci.server.AbstractHibiscusTransferImpl;
import de.willuhn.jameica.hbci.server.Cache;
import de.willuhn.jameica.hbci.server.UmsatzTypUtil;
import de.willuhn.jameica.hbci.server.UmsatzUtil;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;

public class UmsatzTypImpl
extends AbstractDBObjectNode
implements UmsatzTyp,
Duplicatable {
    private static final transient I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final transient Settings settings = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getSettings();
    private static final transient boolean ignorewhitespace = settings.getBoolean("search.ignore.whitespace", true);
    private static final transient Map<String, Pattern> patternCache = new HashMap<String, Pattern>();

    protected String getTableName() {
        return "umsatztyp";
    }

    protected void insertCheck() throws ApplicationException {
        try {
            String comment;
            String name = this.getName();
            if (name == null || name.length() == 0) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie eine Bezeichnung ein."));
            }
            String pattern = this.getPattern();
            if (pattern != null && pattern.length() > 0) {
                if (pattern.length() > 1000) {
                    throw new ApplicationException(i18n.tr("Bitte geben Sie maximal {0} Zeichen als Suchbegriff ein.", Integer.toString(1000)));
                }
                if (this.isRegex()) {
                    try {
                        Pattern.compile(pattern);
                    }
                    catch (PatternSyntaxException pse) {
                        throw new ApplicationException(i18n.tr("Regul\u00e4rer Ausdruck ung\u00fcltig: {0}", pse.getDescription()));
                    }
                }
            }
            if ((comment = this.getKommentar()) != null && comment.length() > 1000) {
                throw new ApplicationException(i18n.tr("Die Notiz ist zu lang. Bitte geben Sie maximal 1000 Zeichen ein."));
            }
            if (this.isCustomColor() && (this.getColor() == null || this.getColor().length != 3)) {
                throw new ApplicationException("W\u00e4hlen Sie bitte eine benutzerdefinierte Farbe aus");
            }
        }
        catch (RemoteException e) {
            Logger.error((String)"error while insert check", (Throwable)e);
            throw new ApplicationException(i18n.tr("Fehler beim Speichern des Umsatz-Typs."));
        }
        super.insertCheck();
    }

    protected void updateCheck() throws ApplicationException {
        this.insertCheck();
    }

    @Override
    public GenericIterator getUmsaetze() throws RemoteException {
        return this.getUmsaetze(-1);
    }

    @Override
    public GenericIterator getUmsaetze(int days) throws RemoteException {
        java.util.Date start = null;
        if (days > 0) {
            long d = (long)days * 24L * 60L * 60L * 1000L;
            start = DateUtil.startOfDay((java.util.Date)new java.util.Date(System.currentTimeMillis() - d));
        }
        return this.getUmsaetze(start, null);
    }

    @Override
    public GenericIterator getUmsaetze(java.util.Date von, java.util.Date bis) throws RemoteException {
        DBIterator list = UmsatzUtil.getUmsaetze();
        if (von != null) {
            list.addFilter("datum >= ?", new Object[]{new Date(von.getTime())});
        }
        if (bis != null) {
            list.addFilter("datum <= ?", new Object[]{new Date(bis.getTime())});
        }
        if (this.isNewObject()) {
            list.addFilter("umsatztyp_id is null");
        } else {
            list.addFilter("(umsatztyp_id is null or umsatztyp_id=" + this.getID() + ")");
        }
        ArrayList<Umsatz> result = new ArrayList<Umsatz>();
        while (list.hasNext()) {
            Umsatz u = (Umsatz)list.next();
            if (!u.isAssigned() && !this.matches(u)) continue;
            result.add(u);
        }
        return PseudoIterator.fromArray((GenericObject[])result.toArray(new Umsatz[0]));
    }

    public String getPrimaryAttribute() throws RemoteException {
        return "name";
    }

    @Override
    public String getName() throws RemoteException {
        return (String)this.getAttribute("name");
    }

    @Override
    public void setName(String name) throws RemoteException {
        this.setAttribute("name", name);
    }

    @Override
    public String getNummer() throws RemoteException {
        return (String)this.getAttribute("nummer");
    }

    @Override
    public void setNummer(String nummer) throws RemoteException {
        this.setAttribute("nummer", nummer);
    }

    @Override
    public String getPattern() throws RemoteException {
        return (String)this.getAttribute("pattern");
    }

    @Override
    public void setPattern(String pattern) throws RemoteException {
        this.setAttribute("pattern", pattern);
    }

    @Override
    public boolean matches(Umsatz umsatz) throws RemoteException {
        return this.matches(umsatz, false);
    }

    @Override
    public boolean matches(Umsatz umsatz, boolean allowReassign) throws RemoteException {
        String s;
        Konto test;
        if (!allowReassign && umsatz.isAssigned()) {
            String id = this.getID();
            if (id == null) {
                return false;
            }
            UmsatzTyp typ = umsatz.getUmsatzTyp();
            return typ.equals((GenericObject)this);
        }
        double betrag = umsatz.getBetrag();
        int typ = this.getTyp();
        if (betrag != 0.0 && (betrag < 0.0 && typ == 1 || betrag > 0.0 && typ == 0)) {
            return false;
        }
        String kat = this.getKontoKategorie();
        Konto k = this.getKonto();
        if ((k != null || kat != null && kat.length() > 0) && (test = umsatz.getKonto()) != null) {
            if (k != null && !k.equals((GenericObject)test)) {
                return false;
            }
            if (kat != null && !kat.equals(test.getKategorie())) {
                return false;
            }
        }
        if ((s = this.getPattern()) == null || s.trim().length() == 0) {
            return false;
        }
        String zweck = VerwendungszweckUtil.toString(umsatz, "");
        String name = StringUtils.trimToEmpty((String)umsatz.getGegenkontoName());
        String name2 = StringUtils.trimToEmpty((String)umsatz.getGegenkontoName2());
        String kto = StringUtils.trimToEmpty((String)umsatz.getGegenkontoNummer());
        String kom = StringUtils.trimToEmpty((String)umsatz.getKommentar());
        String art = StringUtils.trimToEmpty((String)umsatz.getArt());
        String purp = StringUtils.trimToEmpty((String)umsatz.getPurposeCode());
        String ref = StringUtils.trimToEmpty((String)umsatz.getCustomerRef());
        String e2eid = StringUtils.trimToEmpty((String)umsatz.getEndToEndId());
        String mid = StringUtils.trimToEmpty((String)umsatz.getMandateId());
        String cid = StringUtils.trimToEmpty((String)umsatz.getCreditorId());
        String id = StringUtils.trimToEmpty((String)umsatz.getID());
        if (!this.isRegex()) {
            zweck = zweck.toLowerCase();
            name = name.toLowerCase();
            name2 = name2.toLowerCase();
            kto = kto.toLowerCase();
            kom = kom.toLowerCase();
            art = art.toLowerCase();
            purp = purp.toLowerCase();
            ref = ref.toLowerCase();
            e2eid = e2eid.toLowerCase();
            mid = mid.toLowerCase();
            cid = cid.toLowerCase();
            if (ignorewhitespace) {
                zweck = StringUtils.deleteWhitespace((String)zweck);
                name = StringUtils.deleteWhitespace((String)name);
                name2 = StringUtils.deleteWhitespace((String)name2);
            }
            String[] list = UmsatzTypUtil.splitQuery(s.toLowerCase(), ",");
            int i = 0;
            while (i < list.length) {
                String test2 = list[i].trim();
                if (!(ignorewhitespace && (test2 = StringUtils.deleteWhitespace((String)test2)).isEmpty() || zweck.indexOf(test2) == -1 && name.indexOf(test2) == -1 && name2.indexOf(test2) == -1 && kto.indexOf(test2) == -1 && kom.indexOf(test2) == -1 && art.indexOf(test2) == -1 && purp.indexOf(test2) == -1 && ref.indexOf(test2) == -1 && e2eid.indexOf(test2) == -1 && mid.indexOf(test2) == -1 && cid.indexOf(test2) == -1 && !id.equals(test2))) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        Pattern pattern = patternCache.get(s);
        try {
            if (pattern == null) {
                pattern = Pattern.compile(s, 2);
                patternCache.put(s, pattern);
            }
            Matcher mZweck = pattern.matcher(zweck);
            Matcher mName = pattern.matcher(name);
            Matcher mName2 = pattern.matcher(name2);
            Matcher mKto = pattern.matcher(kto);
            Matcher mKom = pattern.matcher(kom);
            Matcher mArt = pattern.matcher(art);
            Matcher mPurp = pattern.matcher(purp);
            Matcher mRef = pattern.matcher(ref);
            Matcher mE2eid = pattern.matcher(e2eid);
            Matcher mMid = pattern.matcher(mid);
            Matcher mCid = pattern.matcher(cid);
            Matcher mAll = pattern.matcher(String.valueOf(name) + " " + name2 + " " + kto + " " + zweck + " " + kom + " " + art + " " + purp + " " + e2eid + " " + mid + " " + cid + " " + ref);
            return mAll.matches() || mZweck.matches() || mName.matches() || mName2.matches() || mKto.matches() || mKom.matches() || mArt.matches() || mPurp.matches() || mRef.matches() || mE2eid.matches() || mMid.matches() || mCid.matches();
        }
        catch (Exception e) {
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Ung\u00fcltiger regul\u00e4rer Ausdruck \"{0}\": {1}", new String[]{s, e.getMessage()}), 1));
            Logger.error((String)("invalid regex pattern: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isRegex() throws RemoteException {
        Integer i = (Integer)this.getAttribute("isregex");
        return i != null && i == 1;
    }

    @Override
    public void setRegex(boolean regex) throws RemoteException {
        this.setAttribute("isregex", regex ? 1 : 0);
    }

    @Override
    public void setKommentar(String kommentar) throws RemoteException {
        this.setAttribute("kommentar", kommentar);
    }

    @Override
    public String getKommentar() throws RemoteException {
        return (String)this.getAttribute("kommentar");
    }

    @Override
    public double getUmsatz() throws RemoteException {
        return this.getUmsatz(-1);
    }

    @Override
    public double getUmsatz(java.util.Date von, java.util.Date bis) throws RemoteException {
        double sum = 0.0;
        GenericIterator i = this.getUmsaetze(von, bis);
        while (i.hasNext()) {
            Umsatz u = (Umsatz)i.next();
            sum += u.getBetrag();
        }
        GenericIterator children = this.getChildren();
        while (children.hasNext()) {
            UmsatzTyp t = (UmsatzTyp)children.next();
            sum += t.getUmsatz(von, bis);
        }
        return sum;
    }

    @Override
    public double getUmsatz(int days) throws RemoteException {
        double sum = 0.0;
        GenericIterator i = this.getUmsaetze(days);
        while (i.hasNext()) {
            Umsatz u = (Umsatz)i.next();
            sum += u.getBetrag();
        }
        GenericIterator children = this.getChildren();
        while (children.hasNext()) {
            UmsatzTyp t = (UmsatzTyp)children.next();
            sum += t.getUmsatz(days);
        }
        return sum;
    }

    public Object getAttribute(String arg0) throws RemoteException {
        if ("konto_id".equals(arg0)) {
            return this.getKonto();
        }
        if ("nummer-int".equals(arg0)) {
            String n = this.getNummer();
            if (n == null || n.length() == 0) {
                return null;
            }
            try {
                Integer i = Integer.valueOf(n);
                return i;
            }
            catch (Exception e) {
                Logger.warn((String)("unable to parse " + n + " as number"));
                return null;
            }
        }
        if ("umsatz".equals(arg0)) {
            return this.getUmsatz();
        }
        return super.getAttribute(arg0);
    }

    public void overwrite(DBObject object) throws RemoteException {
        super.overwrite(object);
        this.setKonto(((AbstractHibiscusTransferImpl)object).getKonto());
    }

    public void delete() throws RemoteException, ApplicationException {
        if (this.isNewObject()) {
            return;
        }
        patternCache.clear();
        Cache.clear(UmsatzTyp.class);
        DBIterator list = UmsatzUtil.getUmsaetzeBackwards();
        list.addFilter("umsatztyp_id = " + this.getID());
        if (!list.hasNext()) {
            super.delete();
            return;
        }
        try {
            Logger.info((String)"removing assignments to existing umsatz objects");
            this.transactionBegin();
            while (list.hasNext()) {
                Umsatz u = (Umsatz)list.next();
                u.setUmsatzTyp(null);
                u.store();
            }
            super.delete();
            this.transactionCommit();
        }
        catch (ApplicationException | RemoteException e) {
            this.transactionRollback();
            throw e;
        }
    }

    public void store() throws RemoteException, ApplicationException {
        super.store();
        patternCache.clear();
        Cache.clear(UmsatzTyp.class);
    }

    @Override
    public int[] getColor() throws RemoteException {
        String color = (String)this.getAttribute("color");
        if (color == null || color.length() == 0) {
            return null;
        }
        try {
            int[] rgb = new int[3];
            String[] values = color.split(",");
            int i = 0;
            while (i < 3) {
                int v = Integer.parseInt(values[i]);
                if (v < 0 || v > 255) {
                    throw new IllegalArgumentException("invalid color value: " + v);
                }
                rgb[i] = v;
                ++i;
            }
            return rgb;
        }
        catch (Exception e) {
            Logger.error((String)("invalid color code: " + color + ", ignoring"), (Throwable)e);
            return null;
        }
    }

    @Override
    public void setColor(int[] rgb) throws RemoteException {
        if (rgb == null || rgb.length != 3) {
            this.setAttribute("color", null);
            return;
        }
        int i = 0;
        while (i < 3) {
            if (rgb[i] < 0 || rgb[i] > 255) {
                Logger.error((String)("invalid color value: " + rgb[i]));
                return;
            }
            ++i;
        }
        this.setAttribute("color", String.valueOf(rgb[0]) + "," + rgb[1] + "," + rgb[2]);
    }

    @Override
    public int getTyp() throws RemoteException {
        Integer i = (Integer)this.getAttribute("umsatztyp");
        return i == null ? 2 : i;
    }

    @Override
    public void setTyp(int typ) throws RemoteException {
        this.setAttribute("umsatztyp", typ);
    }

    public GenericIterator getPossibleParents() throws RemoteException {
        DBIterator list = (DBIterator)super.getPossibleParents();
        list.setOrder("order by COALESCE(nummer,''), name");
        return list;
    }

    public GenericIterator getTopLevelList() throws RemoteException {
        DBIterator list = (DBIterator)super.getTopLevelList();
        list.setOrder("order by COALESCE(nummer,''), name");
        return list;
    }

    @Override
    public boolean isCustomColor() throws RemoteException {
        Integer i = (Integer)this.getAttribute("customcolor");
        return i != null && i == 1;
    }

    @Override
    public void setCustomColor(boolean b) throws RemoteException {
        this.setAttribute("customcolor", b ? 1 : 0);
    }

    public GenericIterator getChildren() throws RemoteException {
        GenericIterator i = super.getChildren();
        if (this.isNewObject() || !(i instanceof DBIterator)) {
            return i;
        }
        DBIterator di = (DBIterator)i;
        di.setOrder("order by COALESCE(nummer,''),name");
        return di;
    }

    public GenericObjectNode getParent() throws RemoteException {
        Cache cache = Cache.get(UmsatzTyp.class, new Cache.ObjectFactory(){

            @Override
            public DBIterator load() throws RemoteException {
                return UmsatzTypUtil.getAll();
            }
        }, true);
        Object i = this.getAttribute(this.getNodeField());
        if (i instanceof UmsatzTyp) {
            return (UmsatzTyp)i;
        }
        return (UmsatzTyp)cache.get(i);
    }

    public Object duplicate() throws RemoteException {
        UmsatzTyp t = (UmsatzTyp)this.getService().createObject(UmsatzTyp.class, null);
        t.setColor(this.getColor());
        t.setCustomColor(this.isCustomColor());
        t.setName(this.getName());
        t.setNummer(this.getNummer());
        t.setParent((DBObjectNode)this.getParent());
        t.setPattern(this.getPattern());
        t.setRegex(this.isRegex());
        t.setKommentar(this.getKommentar());
        t.setTyp(this.getTyp());
        t.setKonto(this.getKonto());
        t.setKontoKategorie(this.getKontoKategorie());
        t.setFlags(this.getFlags());
        return t;
    }

    @Override
    public Konto getKonto() throws RemoteException {
        Integer i = (Integer)super.getAttribute("konto_id");
        if (i == null) {
            return null;
        }
        Cache cache = Cache.get(Konto.class, true);
        return (Konto)cache.get(i);
    }

    @Override
    public void setKonto(Konto konto) throws RemoteException {
        Integer id = konto == null || konto.getID() == null ? null : Integer.valueOf(konto.getID());
        this.setAttribute("konto_id", id);
        if (id != null) {
            this.setKontoKategorie(null);
        }
    }

    @Override
    public String getKontoKategorie() throws RemoteException {
        return (String)this.getAttribute("konto_kategorie");
    }

    @Override
    public void setKontoKategorie(String kategorie) throws RemoteException {
        this.setAttribute("konto_kategorie", kategorie);
        if (kategorie != null && kategorie.length() > 0) {
            this.setAttribute("konto_id", null);
        }
    }

    @Override
    public boolean hasFlag(int flag) throws RemoteException {
        return (this.getFlags() & flag) == flag;
    }

    @Override
    public int getFlags() throws RemoteException {
        Integer i = (Integer)this.getAttribute("flags");
        return i == null ? 0 : i;
    }

    @Override
    public void setFlags(int flags) throws RemoteException {
        if (flags < 0) {
            return;
        }
        this.setAttribute("flags", flags);
    }

    @Override
    public String getPath(String sep) throws RemoteException {
        ArrayList<String> names = new ArrayList<String>();
        UmsatzTyp current = this;
        int i = 0;
        while (i < 20) {
            if (current == null) break;
            names.add(current.getName());
            current = (UmsatzTyp)current.getParent();
            ++i;
        }
        if (sep == null) {
            sep = "|";
        }
        Collections.reverse(names);
        return StringUtils.join(names, (String)sep);
    }
}

