/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.GenericObjectNode;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.datasource.rmi.DBObject;
import de.willuhn.datasource.rmi.DBObjectNode;
import de.willuhn.datasource.rmi.Listener;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.rmi.UmsatzTyp;
import de.willuhn.jameica.hbci.server.UmsatzTypBean;
import de.willuhn.jameica.hbci.server.UmsatzUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;

public class UmsatzTypUtil {
    private static I18N i18n;
    public static final UmsatzTyp UNASSIGNED;

    static {
        UNASSIGNED = new UmsatzTypUnassigned();
    }

    private static I18N getI18N() {
        if (i18n == null) {
            i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
        }
        return i18n;
    }

    public static String getNameForType(int type) {
        I18N i18n = UmsatzTypUtil.getI18N();
        switch (type) {
            case 0: {
                return i18n.tr("Ausgabe");
            }
            case 1: {
                return i18n.tr("Einnahme");
            }
        }
        return i18n.tr("egal");
    }

    public static DBIterator<UmsatzTyp> getAll() throws RemoteException {
        DBIterator list = Settings.getDBService().createList(UmsatzTyp.class);
        list.setOrder("ORDER BY COALESCE(nummer,''),name");
        return list;
    }

    public static DBIterator<UmsatzTyp> getRootElements() throws RemoteException {
        DBIterator<UmsatzTyp> list = UmsatzTypUtil.getAll();
        list.addFilter("parent_id is null or parent_id not in (select id from umsatztyp)");
        return list;
    }

    public static GenericIterator<UmsatzTypBean> getTree(UmsatzTyp skip, int typ) throws RemoteException {
        DBIterator<UmsatzTyp> it = UmsatzTypUtil.getAll();
        LinkedList<UmsatzTypBean> all = new LinkedList<UmsatzTypBean>();
        while (it.hasNext()) {
            UmsatzTyp t = (UmsatzTyp)it.next();
            if (UmsatzTypUtil.filtered(t, skip, typ)) continue;
            all.add(new UmsatzTypBean(t));
        }
        LinkedList<UmsatzTypBean> root = new LinkedList<UmsatzTypBean>();
        for (UmsatzTypBean t : all) {
            if (t.getAttribute("parent_id") != null) continue;
            t.collectChildren(all);
            root.add(t);
        }
        return PseudoIterator.fromArray((GenericObject[])((GenericObject[])root.toArray(new UmsatzTypBean[0])));
    }

    public static List<UmsatzTypBean> getList(UmsatzTyp skip, int typ) throws RemoteException {
        GenericIterator<UmsatzTypBean> tree = UmsatzTypUtil.getTree(skip, typ);
        LinkedList<UmsatzTypBean> result = new LinkedList<UmsatzTypBean>();
        while (tree.hasNext()) {
            UmsatzTypUtil.collect((UmsatzTypBean)tree.next(), result);
        }
        return result;
    }

    private static void collect(UmsatzTypBean bean, List<UmsatzTypBean> target) throws RemoteException {
        target.add(bean);
        GenericIterator children = bean.getChildren();
        while (children.hasNext()) {
            UmsatzTypUtil.collect((UmsatzTypBean)children.next(), target);
        }
    }

    private static boolean filtered(UmsatzTyp ut, UmsatzTyp skip, int typ) throws RemoteException {
        if (ut == null) {
            return true;
        }
        if (skip != null && BeanUtil.equals((Object)skip, (Object)ut)) {
            return true;
        }
        int ti = ut.getTyp();
        if (typ == 2 || ti == 2) {
            return false;
        }
        return ti != typ;
    }

    public static int compare(UmsatzTyp t1, UmsatzTyp t2) throws RemoteException {
        int numberCompare;
        String na2;
        String na1;
        String n2;
        int otherType;
        if (t1 == null) {
            return -1;
        }
        if (t2 == null) {
            return 1;
        }
        int thisType = t1.getTyp();
        if (thisType != (otherType = t2.getTyp()) && thisType != 2 && otherType != 2) {
            return thisType < otherType ? -1 : 1;
        }
        String n1 = t1.getNummer();
        if (n1 == null) {
            n1 = "";
        }
        if ((n2 = t2.getNummer()) == null) {
            n2 = "";
        }
        if ((na1 = t1.getName()) == null) {
            na1 = "";
        }
        if ((na2 = t2.getName()) == null) {
            na2 = "";
        }
        if ((numberCompare = n1.compareTo(n2)) != 0) {
            return numberCompare;
        }
        return na1.compareTo(na2);
    }

    public static String[] splitQuery(String query, String separator) {
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = query.split("(?<!\\\\)" + separator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if ((s = StringUtils.trimToNull((String)s)) != null) {
                s = s.replace("\\", "");
                result.add(s);
            }
            ++n2;
        }
        return result.toArray(new String[0]);
    }

    public static class UmsatzTypUnassigned
    implements UmsatzTyp {
        public Object getAttribute(String attribute) throws RemoteException {
            if ("indented".equals(attribute) || "name".equals(attribute)) {
                return this.getName();
            }
            return null;
        }

        public GenericIterator getTopLevelList() throws RemoteException {
            return null;
        }

        public void setParent(DBObjectNode arg0) throws RemoteException {
        }

        public void addDeleteListener(Listener arg0) throws RemoteException {
        }

        public void addStoreListener(Listener arg0) throws RemoteException {
        }

        public boolean equals(GenericObject arg0) throws RemoteException {
            return arg0 != null && arg0 instanceof UmsatzTypUnassigned;
        }

        public String getAttributeType(String arg0) throws RemoteException {
            return null;
        }

        public DBIterator getList() throws RemoteException {
            return null;
        }

        public String getPrimaryAttribute() throws RemoteException {
            return "name";
        }

        public void load(String arg0) throws RemoteException {
        }

        public void removeDeleteListener(Listener arg0) throws RemoteException {
        }

        public void removeStoreListener(Listener arg0) throws RemoteException {
        }

        public String[] getAttributeNames() throws RemoteException {
            return new String[]{"name", "indented", "kommentar"};
        }

        public String getID() throws RemoteException {
            return "-1";
        }

        public void transactionBegin() throws RemoteException {
        }

        public void transactionCommit() throws RemoteException {
        }

        public void transactionRollback() throws RemoteException {
        }

        public void clear() throws RemoteException {
        }

        public void delete() throws RemoteException, ApplicationException {
        }

        public boolean isNewObject() throws RemoteException {
            return false;
        }

        public void overwrite(DBObject arg0) throws RemoteException {
        }

        public void store() throws RemoteException, ApplicationException {
        }

        public GenericIterator getChildren() throws RemoteException {
            return null;
        }

        public GenericObjectNode getParent() throws RemoteException {
            return null;
        }

        public GenericIterator getPath() throws RemoteException {
            return null;
        }

        public GenericIterator getPossibleParents() throws RemoteException {
            return null;
        }

        public boolean hasChild(GenericObjectNode arg0) throws RemoteException {
            return false;
        }

        @Override
        public String getName() throws RemoteException {
            return "<" + UmsatzTypUtil.getI18N().tr("Nicht zugeordnet") + ">";
        }

        @Override
        public void setName(String name) throws RemoteException {
        }

        @Override
        public String getNummer() throws RemoteException {
            return null;
        }

        @Override
        public void setNummer(String nummer) throws RemoteException {
        }

        @Override
        public String getPattern() throws RemoteException {
            return null;
        }

        @Override
        public void setPattern(String pattern) throws RemoteException {
        }

        @Override
        public GenericIterator getUmsaetze() throws RemoteException {
            return this.getUmsaetze(-1);
        }

        @Override
        public GenericIterator getUmsaetze(java.util.Date von, java.util.Date bis) throws RemoteException {
            DBIterator list = UmsatzUtil.getUmsaetze();
            if (von != null) {
                list.addFilter("datum >= ?", new Object[]{new Date(von.getTime())});
            }
            if (bis != null) {
                list.addFilter("datum <= ?", new Object[]{new Date(bis.getTime())});
            }
            list.addFilter("umsatztyp_id is null");
            ArrayList<Umsatz> result = new ArrayList<Umsatz>();
            while (list.hasNext()) {
                Umsatz u = (Umsatz)list.next();
                if (!this.matches(u)) continue;
                result.add(u);
            }
            return PseudoIterator.fromArray((GenericObject[])result.toArray(new Umsatz[0]));
        }

        @Override
        public GenericIterator getUmsaetze(int days) throws RemoteException {
            java.util.Date start = null;
            if (days > 0) {
                long d = (long)days * 24L * 60L * 60L * 1000L;
                start = DateUtil.startOfDay((java.util.Date)new java.util.Date(System.currentTimeMillis() - d));
            }
            return this.getUmsaetze(start, null);
        }

        @Override
        public double getUmsatz() throws RemoteException {
            return this.getUmsatz(-1);
        }

        @Override
        public double getUmsatz(java.util.Date von, java.util.Date bis) throws RemoteException {
            double sum = 0.0;
            GenericIterator i = this.getUmsaetze(von, bis);
            while (i.hasNext()) {
                Umsatz u = (Umsatz)i.next();
                sum += u.getBetrag();
            }
            return sum;
        }

        @Override
        public double getUmsatz(int days) throws RemoteException {
            double sum = 0.0;
            GenericIterator i = this.getUmsaetze(days);
            while (i.hasNext()) {
                Umsatz u = (Umsatz)i.next();
                sum += u.getBetrag();
            }
            return sum;
        }

        @Override
        public boolean isRegex() throws RemoteException {
            return false;
        }

        @Override
        public int getTyp() throws RemoteException {
            return 2;
        }

        @Override
        public void setTyp(int typ) throws RemoteException {
        }

        @Override
        public void setRegex(boolean regex) throws RemoteException {
        }

        @Override
        public boolean matches(Umsatz umsatz, boolean allowReassign) throws RemoteException, PatternSyntaxException {
            if (umsatz == null) {
                return false;
            }
            boolean assigned = umsatz.isAssigned();
            if (assigned) {
                return false;
            }
            return umsatz.getUmsatzTyp() == null;
        }

        @Override
        public boolean matches(Umsatz umsatz) throws RemoteException {
            return this.matches(umsatz, false);
        }

        @Override
        public int[] getColor() throws RemoteException {
            return null;
        }

        @Override
        public void setColor(int[] rgb) throws RemoteException {
        }

        @Override
        public boolean isCustomColor() throws RemoteException {
            return false;
        }

        @Override
        public void setCustomColor(boolean b) throws RemoteException {
        }

        @Override
        public void setKommentar(String kommentar) throws RemoteException {
        }

        @Override
        public String getKommentar() throws RemoteException {
            return null;
        }

        @Override
        public Konto getKonto() throws RemoteException {
            return null;
        }

        @Override
        public void setKonto(Konto konto) throws RemoteException {
        }

        @Override
        public String getKontoKategorie() throws RemoteException {
            return null;
        }

        @Override
        public void setKontoKategorie(String kategorie) throws RemoteException {
        }

        @Override
        public int getFlags() throws RemoteException {
            return 0;
        }

        @Override
        public void setFlags(int flags) throws RemoteException {
        }

        @Override
        public boolean hasFlag(int flag) throws RemoteException {
            return false;
        }

        @Override
        public String getPath(String sep) throws RemoteException {
            return "";
        }
    }
}

