/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.datasource.rmi.ResultSetExtractor;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class UmsatzUtil {
    public static DBIterator getUmsaetze() throws RemoteException {
        return UmsatzUtil.getUmsaetze(false);
    }

    public static DBIterator getUmsaetzeBackwards() throws RemoteException {
        return UmsatzUtil.getUmsaetze(true);
    }

    public static DBIterator getUmsaetze(int days) throws RemoteException {
        return UmsatzUtil.getUmsaetze(days, false);
    }

    public static DBIterator getUmsaetzeBackwards(int days) throws RemoteException {
        return UmsatzUtil.getUmsaetze(days, true);
    }

    public static Date getOldest(Object kontoOrGroup) throws RemoteException {
        String query = "select min(datum) from umsatz";
        String[] params = null;
        if (kontoOrGroup != null && kontoOrGroup instanceof Konto) {
            query = String.valueOf(query) + " where konto_id = " + ((Konto)kontoOrGroup).getID();
        } else if (kontoOrGroup != null && kontoOrGroup instanceof String) {
            query = String.valueOf(query) + " where konto_id in (select id from konto where kategorie = ?)";
            params = new String[]{(String)kontoOrGroup};
        }
        return (Date)Settings.getDBService().execute(query, params, new ResultSetExtractor(){

            public Object extract(ResultSet rs) throws RemoteException, SQLException {
                if (!rs.next()) {
                    return null;
                }
                return rs.getDate(1);
            }
        });
    }

    public static DBIterator find(Konto konto, String kategorie, Date from, Date to, String query) throws RemoteException {
        DBIterator list = UmsatzUtil.getUmsaetzeBackwards();
        if (konto != null) {
            list.addFilter("konto_id = " + konto.getID());
        } else if (StringUtils.trimToNull((String)kategorie) != null) {
            list.addFilter("konto_id in (select id from konto where kategorie = ?)", new Object[]{kategorie});
        }
        if (from != null) {
            list.addFilter("datum >= ?", new Object[]{new java.sql.Date(DateUtil.startOfDay((Date)from).getTime())});
        }
        if (to != null) {
            list.addFilter("datum <= ?", new Object[]{new java.sql.Date(DateUtil.endOfDay((Date)to).getTime())});
        }
        if (StringUtils.trimToNull((String)query) != null) {
            String text = "%" + query.toLowerCase() + "%";
            String search = "(LOWER(CONCAT(COALESCE(zweck,''),COALESCE(zweck2,''),COALESCE(zweck3,''))) LIKE ? OR LOWER(empfaenger_name) LIKE ? OR empfaenger_konto LIKE ? OR empfaenger_blz LIKE ? OR LOWER(primanota) LIKE ? OR LOWER(art) LIKE ? OR LOWER(customerref) LIKE ? OR LOWER(purposecode) LIKE ? OR LOWER(kommentar) LIKE ? OR LOWER(endtoendid) LIKE ? OR LOWER(mandateid) LIKE ? OR LOWER(creditorid) LIKE ? OR LOWER(empfaenger_name2) LIKE ? OR LOWER(art) LIKE ?)";
            ArrayList<String> params = new ArrayList<String>(Arrays.asList(text, text, text, text, text, text, text, text, text, text, text, text, text, text));
            if (query.matches("^[0-9]{1,10}$")) {
                search = "(id = ? or " + search + ")";
                params.add(0, query);
            }
            list.addFilter(search, params.toArray());
        }
        return list;
    }

    public static DBIterator find(String query) throws RemoteException, ApplicationException {
        if (query == null || query.length() == 0) {
            I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
            throw new ApplicationException(i18n.tr("Bitte geben Sie einen Suchbegriff an"));
        }
        return UmsatzUtil.find(null, null, null, null, query);
    }

    private static DBIterator getUmsaetze(boolean backwards) throws RemoteException {
        return UmsatzUtil.getUmsaetze(-1, backwards);
    }

    private static DBIterator getUmsaetze(int days, boolean backwards) throws RemoteException {
        String s = backwards ? "DESC" : "ASC";
        HBCIDBService service = Settings.getDBService();
        DBIterator list = service.createList(Umsatz.class);
        list.setOrder("ORDER BY " + service.getSQLTimestamp("datum") + " " + s + ", id " + s);
        if (days > 0) {
            Calendar cal = Calendar.getInstance();
            cal.add(6, -days);
            Date from = cal.getTime();
            list.addFilter("datum >= ?", new Object[]{new java.sql.Date(DateUtil.startOfDay((Date)from).getTime())});
        }
        return list;
    }
}

