/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.datasource.db.AbstractDBObject;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.Version;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;

public class VersionImpl
extends AbstractDBObject
implements Version {
    public String getPrimaryAttribute() throws RemoteException {
        return "name";
    }

    protected String getTableName() {
        return "version";
    }

    @Override
    public String getName() throws RemoteException {
        return (String)this.getAttribute("name");
    }

    @Override
    public int getVersion() throws RemoteException {
        Integer i = (Integer)this.getAttribute("version");
        return i == null ? 0 : i;
    }

    @Override
    public void setVersion(int newVersion) throws RemoteException {
        if (newVersion < 0) {
            throw new RemoteException("version cannot be smaller than zero");
        }
        this.setAttribute("version", newVersion);
    }

    @Override
    public void setName(String name) throws RemoteException {
        this.setAttribute("name", name);
    }

    protected void insertCheck() throws ApplicationException {
        I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
        try {
            if (this.getName() == null || this.getName().length() == 0) {
                throw new ApplicationException(i18n.tr("Keine Bezeichnung f\u00fcr die Version angegeben"));
            }
        }
        catch (RemoteException re) {
            Logger.error((String)"error while checking version", (Throwable)re);
            throw new ApplicationException(i18n.tr("Fehler beim Pr\u00fcfen der Version"));
        }
        super.insertCheck();
    }

    protected void updateCheck() throws ApplicationException {
        this.insertCheck();
    }

    public void insert() throws RemoteException, ApplicationException {
        this.setVersion(this.getVersion());
        super.insert();
    }
}

