/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.Version;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;

public class VersionUtil {
    public static Version getVersion(HBCIDBService service, String name) throws RemoteException, ApplicationException {
        if (name == null || name.length() == 0) {
            I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
            throw new ApplicationException(i18n.tr("Keine Versionsbezeichnung angegeben"));
        }
        DBIterator list = service.createList(Version.class);
        list.addFilter("name = ?", new Object[]{name});
        if (list.hasNext()) {
            return (Version)list.next();
        }
        Version v = (Version)service.createObject(Version.class, null);
        v.setName(name);
        v.store();
        return v;
    }

    public static int deleteAll(HBCIDBService service, String prefix) throws RemoteException {
        if (prefix == null || prefix.length() == 0) {
            throw new RemoteException("no prefix given");
        }
        if (prefix.indexOf("%") != -1 || prefix.indexOf("_") != -1) {
            throw new RemoteException("no wildcards allowed in prefix");
        }
        return service.executeUpdate("delete from version where name like ?", String.valueOf(prefix) + ".%");
    }

    public static int delete(HBCIDBService service, String name) throws RemoteException {
        if (name == null || name.length() == 0) {
            throw new RemoteException("no name given");
        }
        int i = service.executeUpdate("delete from version where name = ?", name);
        return i;
    }
}

