/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.rmi.HibiscusTransfer;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SammelTransfer;
import de.willuhn.jameica.hbci.rmi.SammelTransferBuchung;
import de.willuhn.jameica.hbci.rmi.Transfer;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class VerwendungszweckUtil {
    public static String[] split(String lines) {
        if (lines == null || lines.length() == 0) {
            return new String[0];
        }
        return lines.split("\n");
    }

    public static String[] parse(String line) {
        if (line == null || line.length() == 0) {
            return new String[0];
        }
        String s = line.replaceAll("(.{27})", "$1--##--##");
        return s.split("--##--##");
    }

    public static String getTag(Transfer t, Tag tag) throws RemoteException {
        if (tag == null) {
            return null;
        }
        Map<Tag, String> result = VerwendungszweckUtil.parse(t);
        if (result.size() == 0) {
            if (tag == Tag.SVWZ) {
                return VerwendungszweckUtil.toString(t);
            }
            return null;
        }
        String value = result.get((Object)tag);
        if (tag == Tag.SVWZ && StringUtils.trimToNull((String)value) == null) {
            return VerwendungszweckUtil.toString(t);
        }
        return value;
    }

    public static Map<Tag, String> parse(Transfer t) throws RemoteException {
        if (t == null) {
            return new HashMap<Tag, String>();
        }
        return VerwendungszweckUtil.parse(VerwendungszweckUtil.toArray(t));
    }

    public static Map<Tag, String> parse(String ... lines) throws RemoteException {
        Map<Tag, String> result = VerwendungszweckUtil.parse(true, '+', lines);
        if (result == null || result.size() == 0) {
            return VerwendungszweckUtil.parse(true, ':', lines);
        }
        String svwz = result.get((Object)Tag.SVWZ);
        if (StringUtils.trimToNull((String)svwz) != null) {
            result.putAll(VerwendungszweckUtil.parse(false, ':', svwz));
        }
        return result;
    }

    private static Map<Tag, String> parse(boolean leadingSvwz, char sep, String ... lines) throws RemoteException {
        HashMap<Tag, String> result = new HashMap<Tag, String>();
        if (lines == null || lines.length == 0) {
            return result;
        }
        String line = VerwendungszweckUtil.merge(lines);
        int first = -1;
        try {
            String bic;
            String iban;
            Tag[] tagArray = Tag.values();
            int n = tagArray.length;
            int n2 = 0;
            while (n2 < n) {
                Tag tag = tagArray[n2];
                int start = line.indexOf(String.valueOf(tag.name()) + sep);
                if (start != -1) {
                    if (first == -1 || start < first) {
                        first = start;
                    }
                    int next = 0;
                    while (next < line.length()) {
                        int tagLen = tag.name().length() + 1;
                        next = line.indexOf(sep, start + tagLen + next);
                        if (next == -1) {
                            result.put(tag, StringUtils.trimToEmpty((String)line.substring(start + tagLen).replace("\n", "")));
                            break;
                        }
                        String s = line.substring(next - 4, next);
                        Tag found = Tag.byName(s);
                        if (found == null) {
                            found = Tag.byName(line.substring(next - 3, next));
                        }
                        if (found == null) continue;
                        result.put(tag, StringUtils.trimToEmpty((String)line.substring(start + tagLen, next - found.name().length()).replace("\n", "")));
                        break;
                    }
                }
                ++n2;
            }
            if (leadingSvwz && result.size() > 0 && !result.containsKey((Object)Tag.SVWZ) && first > 0) {
                result.put(Tag.SVWZ, StringUtils.trimToEmpty((String)line.substring(0, first).replace("\n", "")));
            }
            if ((iban = StringUtils.trimToNull((String)((String)result.get((Object)Tag.IBAN)))) != null) {
                int space = iban.indexOf(" ");
                if (space > 21) {
                    result.put(Tag.IBAN, StringUtils.trimToEmpty((String)iban.substring(0, space)));
                } else if (space != -1) {
                    result.put(Tag.IBAN, StringUtils.deleteWhitespace((String)iban));
                }
            }
            if ((bic = StringUtils.trimToNull((String)((String)result.get((Object)Tag.BIC)))) != null) {
                result.put(Tag.BIC, StringUtils.deleteWhitespace((String)bic));
            }
        }
        catch (Exception e) {
            Logger.error((String)("unable to parse line: " + line), (Throwable)e);
            e.printStackTrace();
        }
        return result;
    }

    public static void apply(HibiscusTransfer t, String[] lines) throws RemoteException {
        if (t == null || lines == null || lines.length == 0) {
            return;
        }
        List<String> l = VerwendungszweckUtil.clean(true, lines);
        if (l.size() > 0) {
            t.setZweck(l.remove(0));
        }
        if (l.size() > 0) {
            t.setZweck2(l.remove(0));
        }
        if (l.size() > 0) {
            t.setWeitereVerwendungszwecke(l.toArray(new String[0]));
        }
    }

    public static void applyCamt(HibiscusTransfer t, List<String> lines) throws RemoteException {
        if (t == null || lines == null || lines.size() == 0) {
            return;
        }
        List<String> l = VerwendungszweckUtil.clean(true, lines);
        String all = StringUtils.join(l, (String)"");
        if (all.length() <= 255) {
            t.setZweck(all);
            return;
        }
        t.setZweck(all.substring(0, 255));
        all = all.substring(255);
        int limit = HBCIProperties.HBCI_TRANSFER_USAGE_DB_MAXLENGTH;
        if (all.length() <= limit) {
            t.setZweck2(all);
            return;
        }
        t.setZweck2(all.substring(0, limit));
        all = all.substring(limit);
        t.setWeitereVerwendungszwecke(VerwendungszweckUtil.parse(all));
    }

    public static String[] rewrap(int limit, String ... lines) {
        if (lines == null || lines.length == 0) {
            return lines;
        }
        boolean found = false;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null && s.length() > limit) {
                found = true;
                break;
            }
            ++n2;
        }
        if (!found) {
            return lines;
        }
        List<String> l = VerwendungszweckUtil.clean(true, lines);
        StringBuffer sb = new StringBuffer();
        for (String line : l) {
            sb.append(line);
        }
        String result = sb.toString();
        String s = result.replaceAll("(.{" + limit + "})", "$1--##--##");
        return s.split("--##--##");
    }

    public static String merge(String ... lines) {
        if (lines == null || lines.length == 0) {
            return null;
        }
        List<String> cleaned = VerwendungszweckUtil.clean(false, lines);
        StringBuffer sb = new StringBuffer();
        for (String line : cleaned) {
            sb.append(line);
            sb.append("\n");
        }
        String result = sb.toString();
        return result.length() == 0 ? null : result;
    }

    public static String[] toArray(Transfer t) throws RemoteException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(t.getZweck());
        lines.add(t.getZweck2());
        String[] wvz = t.getWeitereVerwendungszwecke();
        if (wvz != null && wvz.length > 0) {
            String[] stringArray = wvz;
            int n = wvz.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                lines.add(s);
                ++n2;
            }
        }
        String[] list = lines.toArray(new String[0]);
        List<String> result = VerwendungszweckUtil.clean(false, list);
        return result.toArray(new String[0]);
    }

    public static String toString(Transfer t) throws RemoteException {
        return VerwendungszweckUtil.toString(t, " ");
    }

    public static String toString(Transfer t, String sep) throws RemoteException {
        if (sep == null) {
            sep = " ";
        }
        StringBuffer sb = new StringBuffer();
        String[] lines = VerwendungszweckUtil.toArray(t);
        int i = 0;
        while (i < lines.length) {
            sb.append(lines[i]);
            if (i + 1 < lines.length) {
                sb.append(sep);
            }
            ++i;
        }
        String result = sb.toString();
        if (sep.equals("\n")) {
            return result;
        }
        return result.replace("\n", sep);
    }

    private static List<String> clean(boolean trim, String ... lines) {
        return VerwendungszweckUtil.clean(trim, lines != null ? Arrays.asList(lines) : null);
    }

    private static List<String> clean(boolean trim, List<String> lines) {
        ArrayList<String> result = new ArrayList<String>();
        if (lines == null || lines.size() == 0) {
            return result;
        }
        for (String line : lines) {
            if (line == null) continue;
            if (trim) {
                line = line.trim();
            }
            if (line.length() <= 0) continue;
            result.add(line);
        }
        return result;
    }

    public static final int getMaxUsageUeb(Konto konto) throws RemoteException {
        return HBCIProperties.HBCI_TRANSFER_USAGE_MAXNUM;
    }

    public static void checkMaxUsage(HibiscusTransfer transfer) throws RemoteException, ApplicationException {
        if (transfer == null) {
            return;
        }
        VerwendungszweckUtil.checkMaxUsage(transfer.getKonto(), transfer.getWeitereVerwendungszwecke());
    }

    public static void checkMaxUsage(SammelTransferBuchung buchung) throws RemoteException, ApplicationException {
        if (buchung == null) {
            return;
        }
        SammelTransfer t = buchung.getSammelTransfer();
        VerwendungszweckUtil.checkMaxUsage(t == null ? null : t.getKonto(), buchung.getWeitereVerwendungszwecke());
    }

    static void checkMaxUsage(Konto konto, String[] lines) throws RemoteException, ApplicationException {
        if (lines == null || lines.length == 0) {
            return;
        }
        int allowed = VerwendungszweckUtil.getMaxUsageUeb(konto);
        if (lines.length + 2 > allowed) {
            I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
            throw new ApplicationException(i18n.tr("Zuviele Verwendungszweck-Zeilen. Maximal erlaubt: {0}", String.valueOf(allowed)));
        }
    }

    public static enum Tag {
        EREF,
        KREF,
        MREF,
        CRED,
        DBET,
        SVWZ,
        ABWA,
        IBAN,
        BIC;


        public static Tag byName(String s) {
            if (s == null) {
                return null;
            }
            Tag[] tagArray = Tag.values();
            int n = tagArray.length;
            int n2 = 0;
            while (n2 < n) {
                Tag t = tagArray[n2];
                if (t.name().equals(s)) {
                    return t;
                }
                ++n2;
            }
            return null;
        }
    }
}

