/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server.hbci;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.hbci.rmi.Transfer;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.jameica.hbci.server.hbci.HBCIContext;
import de.willuhn.jameica.hbci.synchronize.SynchronizeSession;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeBackend;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import org.kapott.hbci.GV.HBCIJob;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.manager.HBCIUtilsInternal;
import org.kapott.hbci.status.HBCIRetVal;
import org.kapott.hbci.status.HBCIStatus;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public abstract class AbstractHBCIJob {
    protected static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final String NL = System.getProperty("line.separator", "\n");
    private static final List<String> IGNORE_WARNINGS = Arrays.asList("3010", "3040", "3072", "3076", "3290", "3300", "3920");
    private HBCIJob job = null;
    private boolean exclusive = false;
    private Hashtable params = new Hashtable();

    public abstract String getIdentifier();

    public abstract String getName() throws RemoteException;

    protected abstract void markExecuted() throws RemoteException, ApplicationException;

    protected abstract String markFailed(String var1) throws RemoteException, ApplicationException;

    protected abstract HibiscusDBObject getContext();

    public List<AbstractHBCIJob> getFollowerJobs() throws RemoteException, ApplicationException {
        return null;
    }

    protected void markCancelled() throws RemoteException, ApplicationException {
    }

    public void setJob(HBCIJob job) throws RemoteException, ApplicationException {
        this.job = job;
        HibiscusDBObject t = this.getContext();
        this.job.setExternalId(HBCIContext.serialize(t));
        for (Object key : this.params.keySet()) {
            Object value = this.params.get(key);
            String name = null;
            Integer idx = null;
            if (key instanceof AbstractMap.SimpleEntry) {
                name = (String)((AbstractMap.SimpleEntry)key).getKey();
                idx = (Integer)((AbstractMap.SimpleEntry)key).getValue();
            } else {
                name = (String)key;
            }
            if (idx != null) {
                if (value instanceof Konto) {
                    job.setParam(name, idx, (Konto)value);
                    continue;
                }
                if (value instanceof Date) {
                    job.setParam(name, idx, (Date)value);
                    continue;
                }
                if (value instanceof Value) {
                    job.setParam(name, idx, (Value)value);
                    continue;
                }
                job.setParam(name, idx, value.toString());
                continue;
            }
            if (value instanceof Konto) {
                job.setParam(name, (Konto)value);
                continue;
            }
            if (value instanceof Date) {
                job.setParam(name, (Date)value);
                continue;
            }
            if (value instanceof Value) {
                job.setParam(name, (Value)value);
                continue;
            }
            job.setParam(name, value.toString());
        }
    }

    protected final HBCIJobResult getJobResult() {
        return this.job != null ? this.job.getJobResult() : null;
    }

    public final void handleResult() throws ApplicationException, RemoteException {
        HBCIRetVal[] warnings;
        boolean errorStatus;
        HBCIJobResult result = this.getJobResult();
        if (result == null) {
            Logger.info((String)"mark job unsupported/failed");
            String msg = i18n.tr("Auftragsart nicht unterst\u00fctzt");
            this.markFailed(msg);
            throw new ApplicationException(msg);
        }
        HBCIStatus status = result.getJobStatus();
        boolean tanNeeded = false;
        boolean executed = false;
        boolean isOK = status.isOK();
        HBCIRetVal[] values = status.getSuccess();
        HBCIRetVal[] errors = status.getErrors();
        boolean successStatus = values != null && values.length > 0;
        boolean bl = errorStatus = errors != null && errors.length > 0;
        if (successStatus) {
            HBCIRetVal[] hBCIRetValArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                HBCIRetVal val = hBCIRetValArray[n2];
                if (val.code != null) {
                    tanNeeded |= val.code.equals("0030");
                    executed |= val.code.equals("0010") || val.code.equals("0020");
                }
                ++n2;
            }
        } else if (!errorStatus && (warnings = status.getWarnings()) != null && warnings.length > 0) {
            boolean b = true;
            HBCIRetVal[] hBCIRetValArray = warnings;
            int n = warnings.length;
            int n3 = 0;
            while (n3 < n) {
                HBCIRetVal v = hBCIRetValArray[n3];
                b &= v.code.startsWith("3");
                ++n3;
            }
            if (b) {
                Logger.info((String)"institute did not sent 0xxx success code but only warnings");
                executed = true;
                successStatus = true;
                isOK = true;
            }
        }
        boolean tanCancel = false;
        HibiscusDBObject ctx = this.getContext();
        if (ctx != null) {
            boolean bl2 = tanCancel = MetaKey.TAN_CANCEL.get(ctx) != null;
            if (tanCancel) {
                MetaKey.TAN_CANCEL.set(ctx, null);
            }
        }
        Logger.info((String)("execution state: tan needed: " + tanNeeded + ", tan-cancel: " + tanCancel + ", executed: " + executed + ", success status: " + successStatus + ", error status: " + errorStatus));
        BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        SynchronizeSession session = ((HBCISynchronizeBackend)service.get(HBCISynchronizeBackend.class)).getCurrentSession();
        ProgressMonitor monitor = session.getProgressMonitor();
        this.logMessages(status.getWarnings(), session.getWarnings(), monitor);
        if (tanCancel) {
            Logger.warn((String)("hbci job cancelled within tan dialog by user, mark job as cancelled [status code: " + status.getStatusCode() + ", session status: " + session.getStatus() + "]"));
            this.markCancelled();
            return;
        }
        String errorText = this.getErrorText();
        if (executed && isOK) {
            Logger.info((String)"mark job executed [executed: true, status: OK]");
            this.markExecutedInternal(errorText);
            return;
        }
        if ((tanNeeded || status.getStatusCode() == 1) && session.getStatus() == 5) {
            Logger.warn((String)("hbci session cancelled by user, mark job as cancelled [status code: " + status.getStatusCode() + ", session status: " + session.getStatus() + "]"));
            this.markCancelled();
            return;
        }
        if (result.isOK() && successStatus) {
            Logger.info((String)"mark job executed [result: OK]");
            this.markExecutedInternal(errorText);
            return;
        }
        if (isOK && successStatus) {
            Logger.info((String)"mark job executed [status: OK]");
            this.markExecutedInternal(errorText);
            return;
        }
        String error = null;
        try {
            Logger.info((String)"mark job failed");
            error = this.markFailed(errorText);
        }
        catch (Exception e) {
            Logger.error((String)"unable to mark job as failed", (Throwable)e);
        }
        throw new ApplicationException(error != null && error.length() > 0 ? error : errorText);
    }

    private void logMessages(HBCIRetVal[] messages, List<String> target, ProgressMonitor monitor) {
        if (messages == null || messages.length == 0) {
            return;
        }
        monitor.log(" ");
        HBCIRetVal[] hBCIRetValArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            HBCIRetVal val = hBCIRetValArray[n2];
            monitor.log("  " + val.code + ": " + val.text);
            if (!IGNORE_WARNINGS.contains(val.code)) {
                target.add(String.valueOf(val.code) + ": " + val.text);
            }
            ++n2;
        }
        monitor.log(" ");
    }

    private void markExecutedInternal(String errorText) throws ApplicationException {
        try {
            this.markExecuted();
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)"unable to mark job as executed", (Throwable)e);
            throw new ApplicationException(errorText);
        }
    }

    private final String getErrorText() {
        String sr = "";
        try {
            String sGlob = this.getJobResult().getGlobStatus().getErrorString();
            Logger.info((String)("global status: " + sGlob));
            String sJob = this.getJobResult().getJobStatus().getErrorString();
            Logger.info((String)("job status: " + sJob));
            HBCIRetVal[] retValues = this.getJobResult().getJobStatus().getRetVals();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < retValues.length) {
                Logger.info((String)("retval[" + i + "]: " + retValues[i].code + " - " + retValues[i].text));
                sb.append(String.valueOf(retValues[i].code) + " - " + retValues[i].text);
                if (i < retValues.length - 1) {
                    sb.append(", ");
                }
                ++i;
            }
            String sDetail = sb.toString();
            if (sDetail != null && sDetail.length() > 0) {
                sr = String.valueOf(sr) + NL + sDetail;
            }
            if (sJob != null && sJob.length() > 0) {
                sr = String.valueOf(sr) + NL + sJob;
            }
            if (sGlob != null && sGlob.length() > 0) {
                sr = String.valueOf(sr) + NL + sGlob;
            }
        }
        catch (ArrayIndexOutOfBoundsException sGlob) {
        }
        catch (Exception e2) {
            Logger.error((String)"error while reading status text", (Throwable)e2);
        }
        I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
        if (sr != null && sr.length() > 0) {
            return i18n.tr("Fehlermeldung der Bank: {0}", sr);
        }
        return i18n.tr("Unbekannter Fehler");
    }

    protected final void setJobParam(String name, String value) {
        this.setJobParam(name, null, value);
    }

    protected final void setJobParam(String name, Integer index, String value) {
        if (name == null || value == null) {
            Logger.warn((String)"[job parameter] no name or value given");
            return;
        }
        this.params.put(new AbstractMap.SimpleEntry<String, Integer>(name, index), value);
    }

    protected final void setJobParam(String name, Konto konto) {
        this.setJobParam(name, null, konto);
    }

    protected final void setJobParam(String name, Integer index, Konto konto) {
        if (name == null || konto == null) {
            Logger.warn((String)"[job parameter] no name or value given");
            return;
        }
        this.params.put(new AbstractMap.SimpleEntry<String, Integer>(name, index), konto);
    }

    protected final void setJobParam(String name, int i) {
        if (name == null) {
            Logger.warn((String)"[job parameter] no name given");
            return;
        }
        this.params.put(name, i);
    }

    protected final void setJobParam(String name, double value, String currency) {
        this.setJobParam(name, null, value, currency);
    }

    protected final void setJobParam(String name, Integer index, double value, String currency) {
        if (name == null) {
            Logger.warn((String)"[job parameter] no name given");
            return;
        }
        BigDecimal bd = new BigDecimal(value).setScale(2, 6);
        this.params.put(new AbstractMap.SimpleEntry<String, Integer>(name, index), new Value(bd, currency));
    }

    protected final void setJobParam(String name, Date date) {
        this.setJobParam(name, null, date);
    }

    protected final void setJobParam(String name, Integer index, Date date) {
        if (name == null || date == null) {
            Logger.warn((String)"[job parameter] no name given or value given");
            return;
        }
        this.params.put(new AbstractMap.SimpleEntry<String, Integer>(name, index), date);
    }

    protected void setJobParamUsage(Transfer t) throws RemoteException {
        if (t == null) {
            return;
        }
        String[] lines = VerwendungszweckUtil.toArray(t);
        int i = 0;
        while (i < lines.length) {
            this.setJobParam(HBCIUtilsInternal.withCounter((String)"usage", (int)i), lines[i]);
            ++i;
        }
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }
}

