/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server.hbci;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.rmi.BatchBookType;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaSammelTransfer;
import de.willuhn.jameica.hbci.rmi.SepaSammelTransferBuchung;
import de.willuhn.jameica.hbci.server.Converter;
import de.willuhn.jameica.hbci.server.hbci.AbstractHBCIJob;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.List;

public abstract class AbstractHBCISepaSammelTransferJob<T extends SepaSammelTransfer>
extends AbstractHBCIJob {
    private T transfer = null;
    private Konto konto = null;

    public AbstractHBCISepaSammelTransferJob(T transfer) throws ApplicationException, RemoteException {
        try {
            String curr;
            String pmtInfId;
            if (transfer == null) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie einen SEPA-Sammelauftrag an"));
            }
            if (transfer.isNewObject()) {
                transfer.store();
            }
            if (transfer.ausgefuehrt()) {
                throw new ApplicationException(i18n.tr("SEPA-Sammelauftrag wurde bereits ausgef\u00fchrt"));
            }
            this.transfer = transfer;
            this.konto = transfer.getKonto();
            List buchungen = this.transfer.getBuchungen();
            if (buchungen.size() == 0) {
                throw new ApplicationException(i18n.tr("SEPA-Sammelauftrag enth\u00e4lt keine Buchungen"));
            }
            for (SepaSammelTransferBuchung b : buchungen) {
                if (!(b.getBetrag() > Settings.getUeberweisungLimit())) continue;
                throw new ApplicationException(i18n.tr("Auftragslimit \u00fcberschritten: {0} ", String.valueOf(HBCI.DECIMALFORMAT.format(Settings.getUeberweisungLimit())) + " " + this.konto.getWaehrung()));
            }
            org.kapott.hbci.structures.Konto own = Converter.HibiscusKonto2HBCIKonto(this.konto);
            own.name = HBCIProperties.replace(own.name, HBCIProperties.TEXT_REPLACEMENTS_SEPA);
            this.setJobParam("src", own);
            BatchBookType batch = BatchBookType.byValue(MetaKey.SEPA_BATCHBOOK.get((HibiscusDBObject)this.transfer));
            if (batch != null && batch != BatchBookType.NONE) {
                this.setJobParam("batchbook", batch.getValue());
            }
            if ((pmtInfId = this.transfer.getPmtInfId()) != null && pmtInfId.trim().length() > 0) {
                this.setJobParam("pmtinfid", pmtInfId);
            }
            if ((curr = this.konto.getWaehrung()) == null || curr.length() == 0) {
                curr = HBCIProperties.CURRENCY_DEFAULT_DE;
            }
            int i = 0;
            while (i < buchungen.size()) {
                String purp;
                String endToEndId;
                SepaSammelTransferBuchung b = (SepaSammelTransferBuchung)buchungen.get(i);
                Integer idx = i;
                org.kapott.hbci.structures.Konto k = new org.kapott.hbci.structures.Konto();
                k.bic = b.getGegenkontoBLZ();
                k.iban = b.getGegenkontoNummer();
                k.name = b.getGegenkontoName();
                this.setJobParam("dst", idx, k);
                this.setJobParam("btg", idx, b.getBetrag(), curr);
                String zweck = b.getZweck();
                if (zweck != null && zweck.length() > 0) {
                    this.setJobParam("usage", idx, zweck);
                }
                if ((endToEndId = b.getEndtoEndId()) != null && endToEndId.trim().length() > 0) {
                    this.setJobParam("endtoendid", idx, endToEndId);
                }
                if ((purp = b.getPurposeCode()) != null && purp.length() > 0) {
                    this.setJobParam("purposecode", idx, purp);
                }
                ++i;
            }
        }
        catch (ApplicationException | RemoteException e) {
            throw e;
        }
        catch (Throwable t) {
            Logger.error((String)("error while executing job " + this.getIdentifier()), (Throwable)t);
            throw new ApplicationException(i18n.tr("Fehler beim Erstellen des Auftrags. Fehlermeldung: {0}", t.getMessage()), t);
        }
    }

    @Override
    protected HibiscusDBObject getContext() {
        return this.getSammelTransfer();
    }

    T getSammelTransfer() {
        return this.transfer;
    }

    @Override
    protected void markExecuted() throws RemoteException, ApplicationException {
        this.transfer.setAusgefuehrt(true);
        Application.getMessagingFactory().sendMessage((Message)new ObjectChangedMessage((GenericObject)this.transfer));
        this.konto.addToProtokoll(i18n.tr("SEPA-Sammelauftrag [Bezeichnung: {0}] ausgef\u00fchrt", this.transfer.getBezeichnung()), 1);
        Logger.info((String)"sepa sammellastschrift submitted successfully");
    }

    @Override
    protected String markFailed(String error) throws RemoteException, ApplicationException {
        String msg = i18n.tr("Fehler beim Ausf\u00fchren des SEPA-Sammelauftrages [Bezeichnung: {0}]: {1}", new String[]{this.transfer.getBezeichnung(), error});
        this.konto.addToProtokoll(msg, 2);
        return msg;
    }

    @Override
    protected void markCancelled() throws RemoteException, ApplicationException {
        String msg = i18n.tr("Ausf\u00fchrung des SEPA-Sammelauftrages [Bezeichnung: {0}] abgebrochen", this.transfer.getBezeichnung());
        this.konto.addToProtokoll(msg, 2);
    }
}

