/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server.hbci;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.rmi.AuslandsUeberweisung;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.server.Converter;
import de.willuhn.jameica.hbci.server.InstantPaymentStatus;
import de.willuhn.jameica.hbci.server.hbci.AbstractHBCIJob;
import de.willuhn.jameica.hbci.server.hbci.tests.PreTimeRestriction;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Properties;
import org.kapott.hbci.GV.HBCIJob;
import org.kapott.hbci.GV_Result.GVRInstUebSEPA;

public class HBCIAuslandsUeberweisungJob
extends AbstractHBCIJob {
    private AuslandsUeberweisung ueberweisung = null;
    private boolean isTermin = false;
    private boolean isUmb = false;
    private boolean isInstant = false;
    private Konto konto = null;

    public HBCIAuslandsUeberweisungJob(AuslandsUeberweisung ueberweisung) throws ApplicationException, RemoteException {
        try {
            String purp;
            String pmtInfId;
            String endToEndId;
            if (ueberweisung == null) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie einen Auftrag an"));
            }
            if (ueberweisung.isNewObject()) {
                ueberweisung.store();
            }
            if (ueberweisung.ausgefuehrt()) {
                throw new ApplicationException(i18n.tr("Auftrag wurde bereits ausgef\u00fchrt"));
            }
            this.ueberweisung = ueberweisung;
            this.konto = this.ueberweisung.getKonto();
            this.isTermin = this.ueberweisung.isTerminUeberweisung();
            this.isUmb = this.ueberweisung.isUmbuchung();
            this.isInstant = this.ueberweisung.isInstantPayment();
            if (this.ueberweisung.getBetrag() > Settings.getUeberweisungLimit()) {
                throw new ApplicationException(i18n.tr("Auftragslimit \u00fcberschritten: {0} ", String.valueOf(HBCI.DECIMALFORMAT.format(Settings.getUeberweisungLimit())) + " " + this.konto.getWaehrung()));
            }
            org.kapott.hbci.structures.Konto own = Converter.HibiscusKonto2HBCIKonto(this.konto);
            own.name = HBCIProperties.replace(own.name, HBCIProperties.TEXT_REPLACEMENTS_SEPA);
            this.setJobParam("src", own);
            org.kapott.hbci.structures.Konto k = new org.kapott.hbci.structures.Konto();
            k.bic = ueberweisung.getGegenkontoBLZ();
            k.iban = ueberweisung.getGegenkontoNummer();
            k.name = ueberweisung.getGegenkontoName();
            this.setJobParam("dst", k);
            String curr = this.konto.getWaehrung();
            if (curr == null || curr.length() == 0) {
                curr = HBCIProperties.CURRENCY_DEFAULT_DE;
            }
            this.setJobParam("btg", ueberweisung.getBetrag(), curr);
            String zweck = ueberweisung.getZweck();
            if (zweck != null && zweck.length() > 0) {
                this.setJobParam("usage", zweck);
            }
            if ((endToEndId = ueberweisung.getEndtoEndId()) != null && endToEndId.trim().length() > 0) {
                this.setJobParam("endtoendid", endToEndId);
            }
            if ((pmtInfId = ueberweisung.getPmtInfId()) != null && pmtInfId.trim().length() > 0) {
                this.setJobParam("pmtinfid", pmtInfId);
            }
            if ((purp = ueberweisung.getPurposeCode()) != null && purp.length() > 0) {
                this.setJobParam("purposecode", purp);
            }
        }
        catch (ApplicationException | RemoteException e) {
            throw e;
        }
        catch (Throwable t) {
            Logger.error((String)("error while executing job " + this.getIdentifier()), (Throwable)t);
            throw new ApplicationException(i18n.tr("Fehler beim Erstellen des Auftrags. Fehlermeldung: {0}", t.getMessage()), t);
        }
    }

    @Override
    protected HibiscusDBObject getContext() {
        return this.ueberweisung;
    }

    @Override
    public String getIdentifier() {
        if (this.isTermin) {
            return "TermUebSEPA";
        }
        if (this.isUmb) {
            return "UmbSEPA";
        }
        if (this.isInstant) {
            return "InstUebSEPA";
        }
        return "UebSEPA";
    }

    @Override
    public void setJob(HBCIJob job) throws RemoteException, ApplicationException {
        if (this.isTermin) {
            Date date = this.ueberweisung.getTermin();
            Properties p = job.getJobRestrictions();
            new PreTimeRestriction(date, p).test();
            this.setJobParam("date", date);
        }
        super.setJob(job);
    }

    @Override
    public String getName() throws RemoteException {
        if (this.isUmb) {
            return i18n.tr("SEPA-Umbuchung an {0} (IBAN: {1})", new String[]{this.ueberweisung.getGegenkontoName(), this.ueberweisung.getGegenkontoNummer()});
        }
        if (this.isTermin) {
            return i18n.tr("SEPA-Termin\u00fcberweisung an {0} (IBAN: {1})", new String[]{this.ueberweisung.getGegenkontoName(), this.ueberweisung.getGegenkontoNummer()});
        }
        if (this.isInstant) {
            return i18n.tr("SEPA-Echtzeit\u00fcberweisung an {0} (IBAN: {1})", new String[]{this.ueberweisung.getGegenkontoName(), this.ueberweisung.getGegenkontoNummer()});
        }
        return i18n.tr("SEPA-\u00dcberweisung an {0} (IBAN: {1})", new String[]{this.ueberweisung.getGegenkontoName(), this.ueberweisung.getGegenkontoNummer()});
    }

    @Override
    protected void markExecuted() throws RemoteException, ApplicationException {
        if (this.isInstant) {
            GVRInstUebSEPA result = (GVRInstUebSEPA)this.getJobResult();
            InstantPaymentStatus status = InstantPaymentStatus.determine(result.getOrderStatus());
            if (status != null) {
                Logger.info((String)("received status code for sepa instant payment: " + status.getStatus() + " - " + status.getDescription()));
                if (!status.isSuccess()) {
                    String s1 = this.ueberweisung.getGegenkontoNummer();
                    String s2 = status.getDescription();
                    this.konto.addToProtokoll(i18n.tr("Bank-Antwort auf Echtzeit\u00fcberweisung an {0}: {1}", new String[]{s1, s2}), 2);
                    throw new ApplicationException(i18n.tr("Echtzeit\u00fcberweisung an {0} fehlgeschlagen: {1}", new String[]{s1, s2}));
                }
            } else {
                Logger.info((String)"received no status status code for sepa instant payment (optional) - assuming as successfully executed");
            }
        }
        this.ueberweisung.setAusgefuehrt(true);
        Application.getMessagingFactory().sendMessage((Message)new ObjectChangedMessage((GenericObject)this.ueberweisung));
        this.konto.addToProtokoll(i18n.tr("SEPA-\u00dcberweisung ausgef\u00fchrt an: {0}", this.ueberweisung.getGegenkontoNummer()), 1);
        Logger.info((String)"foreign transfer submitted successfully");
    }

    @Override
    protected String markFailed(String error) throws ApplicationException, RemoteException {
        String msg = i18n.tr("Fehler beim Ausf\u00fchren des Auftrages an {0}: {1}", new String[]{this.ueberweisung.getGegenkontoName(), error});
        this.konto.addToProtokoll(msg, 2);
        return msg;
    }

    @Override
    protected void markCancelled() throws RemoteException, ApplicationException {
        String msg = i18n.tr("Ausf\u00fchrung des Auftrages an {0} abgebrochen", this.ueberweisung.getGegenkontoName());
        this.konto.addToProtokoll(msg, 2);
    }
}

