/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server.hbci;

import de.willuhn.datasource.rmi.DBObject;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.SynchronizeOptions;
import de.willuhn.jameica.hbci.rmi.AuslandsUeberweisung;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaDauerauftrag;
import de.willuhn.jameica.hbci.rmi.SepaLastschrift;
import de.willuhn.jameica.hbci.rmi.SepaSammelLastschrift;
import de.willuhn.jameica.hbci.rmi.SepaSammelUeberweisung;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import de.willuhn.util.MultipleClassLoader;
import org.apache.commons.lang.StringUtils;

public class HBCIContext {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public static HibiscusDBObject unserialize(String externalId) {
        int i;
        block5: {
            if ((externalId = StringUtils.trimToNull((String)externalId)) == null) {
                return null;
            }
            i = externalId.indexOf(":");
            if (i > 0) break block5;
            return null;
        }
        try {
            String className = externalId.substring(0, i);
            String id = externalId.substring(i + 1);
            HBCIDBService service = Settings.getDBService();
            MultipleClassLoader loader = Application.getPluginLoader().getManifest(HBCI.class).getClassLoader();
            DBObject o = service.createObject(loader.loadClass(className), id);
            if (o instanceof HibiscusDBObject) {
                return (HibiscusDBObject)o;
            }
        }
        catch (Exception e) {
            Logger.error((String)("unable to unserialize transfer for external id: " + externalId), (Throwable)e);
        }
        return null;
    }

    public static String serialize(HibiscusDBObject context) {
        block3: {
            try {
                if (context != null && !context.isNewObject()) break block3;
                return null;
            }
            catch (Exception e) {
                Logger.error((String)"unable to serialize transfer", (Throwable)e);
                return null;
            }
        }
        return String.valueOf(context.getClass().getName()) + ":" + context.getID();
    }

    public static String toString(Object object) {
        try {
            if (object instanceof AuslandsUeberweisung) {
                AuslandsUeberweisung ueb = (AuslandsUeberweisung)object;
                Konto k = ueb.getKonto();
                if (ueb.isTerminUeberweisung()) {
                    return i18n.tr("{0}: ({1}) {2} {3} per {4} an {5} ({6}) \u00fcberweisen", new String[]{k.getLongName(), ueb.getZweck(), HBCI.DECIMALFORMAT.format(ueb.getBetrag()), k.getWaehrung(), HBCI.DATEFORMAT.format(ueb.getTermin()), ueb.getGegenkontoName(), HBCIProperties.formatIban(ueb.getGegenkontoNummer())});
                }
                if (ueb.isUmbuchung()) {
                    return i18n.tr("{0}: ({1}) {2} {3} an {4} ({5}) \u00fcberweisen (Umbuchung)", new String[]{k.getLongName(), ueb.getZweck(), HBCI.DECIMALFORMAT.format(ueb.getBetrag()), k.getWaehrung(), ueb.getGegenkontoName(), HBCIProperties.formatIban(ueb.getGegenkontoNummer())});
                }
                if (ueb.isInstantPayment()) {
                    return i18n.tr("{0}: ({1}) {2} {3} an {4} ({5}) \u00fcberweisen (Echtzeit\u00fcberweisung)", new String[]{k.getLongName(), ueb.getZweck(), HBCI.DECIMALFORMAT.format(ueb.getBetrag()), k.getWaehrung(), ueb.getGegenkontoName(), HBCIProperties.formatIban(ueb.getGegenkontoNummer())});
                }
                return i18n.tr("{0}: ({1}) {2} {3} an {4} ({5}) \u00fcberweisen", new String[]{k.getLongName(), ueb.getZweck(), HBCI.DECIMALFORMAT.format(ueb.getBetrag()), k.getWaehrung(), ueb.getGegenkontoName(), HBCIProperties.formatIban(ueb.getGegenkontoNummer())});
            }
            if (object instanceof SepaSammelUeberweisung) {
                SepaSammelUeberweisung r = (SepaSammelUeberweisung)object;
                Konto k = r.getKonto();
                if (r.isTerminUeberweisung()) {
                    return i18n.tr("{0}: ({1}) {2} {3} per {4} als SEPA-Sammeltermin\u00fcberweisung absenden", new String[]{k.getLongName(), r.getBezeichnung(), HBCI.DECIMALFORMAT.format(r.getSumme()), k.getWaehrung(), HBCI.DATEFORMAT.format(r.getTermin())});
                }
                return i18n.tr("{0}: ({1}) {2} {3} als SEPA-Sammel\u00fcberweisung absenden", new String[]{k.getLongName(), r.getBezeichnung(), HBCI.DECIMALFORMAT.format(r.getSumme()), k.getWaehrung()});
            }
            if (object instanceof SepaDauerauftrag) {
                SepaDauerauftrag dauer = (SepaDauerauftrag)object;
                Konto k = dauer.getKonto();
                return i18n.tr("{0}: ({1}) {2} {3} an {4} ({5}), Turnus: {6}", new String[]{k.getLongName(), dauer.getZweck(), HBCI.DECIMALFORMAT.format(dauer.getBetrag()), k.getWaehrung(), dauer.getGegenkontoName(), HBCIProperties.formatIban(dauer.getGegenkontoNummer()), dauer.getTurnus().getBezeichnung()});
            }
            if (object instanceof SepaLastschrift) {
                SepaLastschrift last = (SepaLastschrift)object;
                Konto k = last.getKonto();
                return i18n.tr("{0}: ({1}) {2} {3} von {4} ({5}) einziehen", new String[]{k.getLongName(), last.getZweck(), HBCI.DECIMALFORMAT.format(last.getBetrag()), k.getWaehrung(), last.getGegenkontoName(), HBCIProperties.formatIban(last.getGegenkontoNummer())});
            }
            if (object instanceof SepaSammelLastschrift) {
                SepaSammelLastschrift last = (SepaSammelLastschrift)object;
                Konto k = last.getKonto();
                return i18n.tr("{0}: ({1}) {2} {3} als SEPA-Sammellastschrift einziehen", new String[]{k.getLongName(), last.getBezeichnung(), HBCI.DECIMALFORMAT.format(last.getSumme()), k.getWaehrung()});
            }
            if (object instanceof Konto) {
                Konto k = (Konto)object;
                SynchronizeOptions o = new SynchronizeOptions(k);
                String s = "{0}: ";
                if (o.getSyncKontoauszuege()) {
                    s = String.valueOf(s) + "Ums\u00e4tze";
                }
                if (o.getSyncSaldo()) {
                    if (o.getSyncKontoauszuege()) {
                        s = String.valueOf(s) + "/";
                    }
                    s = String.valueOf(s) + "Salden";
                }
                s = String.valueOf(s) + " abrufen";
                return i18n.tr(s, k.getLongName());
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to stringify object", (Throwable)e);
        }
        return i18n.tr("Unbekannter Auftrag");
    }
}

