/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server.hbci;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Kontoauszug;
import de.willuhn.jameica.hbci.server.BPDUtil;
import de.willuhn.jameica.hbci.server.Converter;
import de.willuhn.jameica.hbci.server.KontoauszugPdfUtil;
import de.willuhn.jameica.hbci.server.hbci.AbstractHBCIJob;
import de.willuhn.jameica.hbci.server.hbci.HBCIQuittungJob;
import de.willuhn.jameica.hbci.synchronize.SynchronizeSession;
import de.willuhn.jameica.hbci.synchronize.hbci.HBCISynchronizeBackend;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.ProgressMonitor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.kapott.hbci.GV.GVKontoauszug;
import org.kapott.hbci.GV.GVKontoauszugPdf;
import org.kapott.hbci.GV_Result.GVRKontoauszug;

public class HBCIKontoauszugJob
extends AbstractHBCIJob {
    private Konto konto = null;
    private List<AbstractHBCIJob> followers = new ArrayList<AbstractHBCIJob>();

    public HBCIKontoauszugJob(Konto konto) throws ApplicationException, RemoteException {
        try {
            List<GVRKontoauszug.Format> formats;
            BPDUtil.Support support;
            if (konto == null) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie ein Konto aus"));
            }
            if (konto.isNewObject()) {
                konto.store();
            }
            this.konto = konto;
            String curr = konto.getWaehrung();
            if (curr == null || curr.length() == 0) {
                konto.setWaehrung(HBCIProperties.CURRENCY_DEFAULT_DE);
            }
            this.setJobParam("my", Converter.HibiscusKonto2HBCIKonto(konto));
            if (this.getIdentifier().equals(GVKontoauszug.getLowlevelName()) && (support = BPDUtil.getSupport(this.konto, BPDUtil.Query.Kontoauszug)) != null && (formats = KontoauszugPdfUtil.getFormats(support.getBpd())).contains(GVRKontoauszug.Format.PDF)) {
                this.setJobParam("format", GVRKontoauszug.Format.PDF.getCode());
            }
        }
        catch (ApplicationException | RemoteException e) {
            throw e;
        }
        catch (Throwable t) {
            Logger.error((String)("error while executing job " + this.getIdentifier()), (Throwable)t);
            throw new ApplicationException(i18n.tr("Fehler beim Erstellen des Auftrags. Fehlermeldung: {0}", t.getMessage()), t);
        }
    }

    @Override
    protected HibiscusDBObject getContext() {
        return this.konto;
    }

    @Override
    public String getIdentifier() {
        BPDUtil.Support support = BPDUtil.getSupport(this.konto, BPDUtil.Query.KontoauszugPdf);
        if (support != null && support.isSupported()) {
            return GVKontoauszugPdf.getLowlevelName();
        }
        return GVKontoauszug.getLowlevelName();
    }

    @Override
    public String getName() throws RemoteException {
        return i18n.tr("Elektronische Kontoausz\u00fcge {0}", this.konto.getLongName());
    }

    @Override
    protected void markExecuted() throws RemoteException, ApplicationException {
        GVRKontoauszug result = (GVRKontoauszug)this.getJobResult();
        List entries = result.getEntries();
        MetaKey.KONTOAUSZUG_INTERVAL_LAST.set(this.konto, HBCI.LONGDATEFORMAT.format(new Date()));
        if (entries != null && entries.size() > 0) {
            for (GVRKontoauszug.GVRKontoauszugEntry entry : entries) {
                try {
                    byte[] q;
                    byte[] data = entry.getData();
                    if (data == null || data.length == 0) {
                        Logger.info((String)"no new account statements");
                        BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
                        SynchronizeSession session = ((HBCISynchronizeBackend)service.get(HBCISynchronizeBackend.class)).getCurrentSession();
                        ProgressMonitor monitor = session.getProgressMonitor();
                        monitor.log(i18n.tr("Keine neuen Kontoausz\u00fcge verf\u00fcgbar"));
                        return;
                    }
                    Kontoauszug ka = Converter.HBCIKontoauszug2HibiscusKontoauszug(this.konto, entry);
                    if (Boolean.parseBoolean(MetaKey.KONTOAUSZUG_MARK_READ.get(this.konto))) {
                        ka.setGelesenAm(new Date());
                    }
                    Logger.info((String)("received new account statement for range " + ka.getVon() + " - " + ka.getBis()));
                    ka.store();
                    KontoauszugPdfUtil.receive(ka, entry.getData());
                    Application.getMessagingFactory().sendMessage((Message)new ImportMessage((GenericObject)ka));
                    this.konto.addToProtokoll(i18n.tr("Elektronische Kontoausz\u00fcge abgerufen"), 1);
                    boolean sendReceipt = Boolean.parseBoolean(MetaKey.KONTOAUSZUG_SEND_RECEIPT.get(this.konto));
                    if (!sendReceipt || (q = ka.getQuittungscode()) == null || q.length <= 0) continue;
                    this.followers.add(new HBCIQuittungJob(ka));
                }
                catch (Exception e) {
                    Logger.error((String)"unable to store account statements, skipping", (Throwable)e);
                    this.konto.addToProtokoll(i18n.tr("Speichern des elektronischen Kontoauszuges fehlgeschlagen: {0}", e.getMessage()), 2);
                }
            }
        }
    }

    @Override
    public List<AbstractHBCIJob> getFollowerJobs() throws RemoteException, ApplicationException {
        return this.followers;
    }

    @Override
    protected String markFailed(String error) throws RemoteException, ApplicationException {
        String msg = i18n.tr("Fehler beim Abrufen der elektronischen Kontoausz\u00fcge: {0}", error);
        this.konto.addToProtokoll(msg, 2);
        return msg;
    }
}

