/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server.hbci;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.hbci.rmi.Kontoauszug;
import de.willuhn.jameica.hbci.server.hbci.AbstractHBCIJob;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.kapott.hbci.GV.GVReceipt;

public class HBCIQuittungJob
extends AbstractHBCIJob {
    private Kontoauszug ka = null;

    public HBCIQuittungJob(Kontoauszug ka) throws ApplicationException, RemoteException {
        try {
            if (ka == null) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen Kontoauszug aus"));
            }
            this.ka = ka;
            byte[] receipt = this.ka.getQuittungscode();
            if (receipt == null || receipt.length == 0) {
                throw new ApplicationException(i18n.tr("Kontoauszug enth\u00e4lt keinen Quittungscode"));
            }
            if (ka.isNewObject()) {
                ka.store();
            }
            String s = null;
            try {
                s = new String(receipt, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                Logger.error((String)"unable to encode receipt using encoding ISO-8859-1 - fallback to default encoding", (Throwable)e);
            }
            if (s == null) {
                s = new String(receipt);
            }
            this.setJobParam("receipt", s);
        }
        catch (ApplicationException | RemoteException e) {
            throw e;
        }
        catch (Throwable t) {
            Logger.error((String)("error while executing job " + this.getIdentifier()), (Throwable)t);
            throw new ApplicationException(i18n.tr("Fehler beim Erstellen des Auftrags. Fehlermeldung: {0}", t.getMessage()), t);
        }
    }

    @Override
    protected HibiscusDBObject getContext() {
        return this.ka;
    }

    @Override
    public String getIdentifier() {
        return GVReceipt.getLowlevelName();
    }

    @Override
    public String getName() throws RemoteException {
        int jahr = this.getJahr();
        Integer nr = this.ka.getNummer();
        StringBuilder sb = new StringBuilder();
        sb.append(jahr);
        if (nr != null) {
            sb.append("-");
            sb.append(nr);
        }
        return i18n.tr("Empfangsquittung f\u00fcr Kontoauszug {0}", sb.toString());
    }

    private int getJahr() {
        try {
            Integer jahr = this.ka.getJahr();
            if (jahr != null) {
                return jahr;
            }
            Calendar cal = Calendar.getInstance();
            List<Date> dates = Arrays.asList(this.ka.getVon(), this.ka.getErstellungsdatum(), this.ka.getAusfuehrungsdatum());
            for (Date d : dates) {
                if (d == null) continue;
                cal.setTime(d);
                return cal.get(1);
            }
            Logger.warn((String)"unable to determine year for account statements");
            return cal.get(1);
        }
        catch (Exception e) {
            Logger.error((String)"unable to determine year for account statements", (Throwable)e);
            Calendar cal = Calendar.getInstance();
            return cal.get(1);
        }
    }

    @Override
    protected void markExecuted() throws RemoteException, ApplicationException {
        this.ka.setQuittiertAm(new Date());
        this.ka.store();
        Application.getMessagingFactory().sendMessage((Message)new ObjectChangedMessage((GenericObject)this.ka));
        Logger.info((String)("marked account statement for range " + this.ka.getVon() + " - " + this.ka.getBis() + " as received, receipt: " + this.ka.getQuittungscode()));
    }

    @Override
    protected String markFailed(String error) throws RemoteException, ApplicationException {
        String msg = i18n.tr("Fehler beim Quittieren der elektronischen Kontoausz\u00fcge: {0}", error);
        this.ka.getKonto().addToProtokoll(msg, 2);
        return msg;
    }
}

