/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server.hbci;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.messaging.SaldoMessage;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.server.Converter;
import de.willuhn.jameica.hbci.server.hbci.AbstractHBCIJob;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import org.kapott.hbci.GV_Result.GVRSaldoReq;
import org.kapott.hbci.structures.Saldo;
import org.kapott.hbci.structures.Value;

public class HBCISaldoJob
extends AbstractHBCIJob {
    private Konto konto = null;

    public HBCISaldoJob(Konto konto) throws ApplicationException, RemoteException {
        try {
            if (konto == null) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie ein Konto aus"));
            }
            if (konto.isNewObject()) {
                konto.store();
            }
            this.konto = konto;
            String curr = konto.getWaehrung();
            if (curr == null || curr.length() == 0) {
                konto.setWaehrung(HBCIProperties.CURRENCY_DEFAULT_DE);
            }
            this.setJobParam("my", Converter.HibiscusKonto2HBCIKonto(konto));
        }
        catch (ApplicationException | RemoteException e) {
            throw e;
        }
        catch (Throwable t) {
            Logger.error((String)("error while executing job " + this.getIdentifier()), (Throwable)t);
            throw new ApplicationException(i18n.tr("Fehler beim Erstellen des Auftrags. Fehlermeldung: {0}", t.getMessage()), t);
        }
    }

    @Override
    protected HibiscusDBObject getContext() {
        return this.konto;
    }

    @Override
    public String getIdentifier() {
        return "SaldoReq";
    }

    @Override
    public String getName() throws RemoteException {
        return i18n.tr("Saldo-Abruf {0}", this.konto.getLongName());
    }

    @Override
    protected void markExecuted() throws RemoteException, ApplicationException {
        GVRSaldoReq result = (GVRSaldoReq)this.getJobResult();
        this.konto.addToProtokoll(i18n.tr("Saldo abgerufen"), 1);
        GVRSaldoReq.Info[] info = result.getEntries();
        if (info == null || info.length == 0) {
            throw new ApplicationException(i18n.tr("Keine Saldo-Informationen erhalten"));
        }
        Saldo saldo = info[0].ready;
        Value avail = info[0].available;
        this.konto.setSaldo(saldo.value.getDoubleValue());
        if (avail != null) {
            this.konto.setSaldoAvailable(avail.getDoubleValue());
        }
        this.konto.store();
        Application.getMessagingFactory().sendMessage((Message)new SaldoMessage((GenericObject)this.konto));
        Logger.info((String)"saldo fetched successfully");
    }

    @Override
    protected String markFailed(String error) throws RemoteException, ApplicationException {
        String msg = i18n.tr("Fehler beim Abrufen das Saldos: {0}", error);
        this.konto.addToProtokoll(msg, 2);
        return msg;
    }
}

