/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server.hbci;

import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.hbci.rmi.SepaDauerauftrag;
import de.willuhn.jameica.hbci.rmi.Turnus;
import de.willuhn.jameica.hbci.server.Converter;
import de.willuhn.jameica.hbci.server.hbci.AbstractHBCIJob;
import de.willuhn.jameica.hbci.server.hbci.tests.CanTermDelRestriction;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kapott.hbci.GV.HBCIJob;
import org.kapott.hbci.structures.Konto;

public class HBCISepaDauerauftragDeleteJob
extends AbstractHBCIJob {
    private SepaDauerauftrag dauerauftrag = null;
    private de.willuhn.jameica.hbci.rmi.Konto konto = null;
    private Date date = null;

    public HBCISepaDauerauftragDeleteJob(SepaDauerauftrag auftrag, Date date) throws RemoteException, ApplicationException {
        try {
            Turnus turnus;
            if (auftrag == null) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen SEPA-Dauerauftrag aus"));
            }
            if (!auftrag.isActive()) {
                throw new ApplicationException(i18n.tr("Dauerauftrag liegt nicht bei der Bank vor und muss daher nicht online gel\u00f6scht werden"));
            }
            if (auftrag.isNewObject()) {
                auftrag.store();
            }
            this.dauerauftrag = auftrag;
            this.konto = auftrag.getKonto();
            this.date = date;
            String orderID = this.dauerauftrag.getOrderID();
            if (StringUtils.trimToEmpty((String)orderID).equals("9999999999")) {
                this.setJobParam("orderid", "");
            } else {
                this.setJobParam("orderid", orderID);
            }
            Konto own = Converter.HibiscusKonto2HBCIKonto(this.konto);
            own.name = HBCIProperties.replace(own.name, HBCIProperties.TEXT_REPLACEMENTS_SEPA);
            this.setJobParam("src", own);
            Konto k = new Konto();
            k.bic = this.dauerauftrag.getGegenkontoBLZ();
            k.iban = this.dauerauftrag.getGegenkontoNummer();
            k.name = this.dauerauftrag.getGegenkontoName();
            this.setJobParam("dst", k);
            String curr = this.konto.getWaehrung();
            if (curr == null || curr.length() == 0) {
                curr = HBCIProperties.CURRENCY_DEFAULT_DE;
            }
            this.setJobParam("btg", this.dauerauftrag.getBetrag(), curr);
            this.setJobParamUsage(this.dauerauftrag);
            this.setJobParam("firstdate", this.dauerauftrag.getErsteZahlung());
            Date letzteZahlung = this.dauerauftrag.getLetzteZahlung();
            if (letzteZahlung != null) {
                this.setJobParam("lastdate", letzteZahlung);
            }
            this.setJobParam("timeunit", (turnus = this.dauerauftrag.getTurnus()).getZeiteinheit() == 2 ? "M" : "W");
            this.setJobParam("turnus", turnus.getIntervall());
            this.setJobParam("execday", turnus.getTag());
        }
        catch (ApplicationException | RemoteException e) {
            throw e;
        }
        catch (Throwable t) {
            Logger.error((String)("error while executing job " + this.getIdentifier()), (Throwable)t);
            throw new ApplicationException(i18n.tr("Fehler beim Erstellen des Auftrags. Fehlermeldung: {0}", t.getMessage()), t);
        }
    }

    @Override
    protected HibiscusDBObject getContext() {
        return this.dauerauftrag;
    }

    @Override
    public void setJob(HBCIJob job) throws RemoteException, ApplicationException {
        if (this.date != null) {
            Properties p = job.getJobRestrictions();
            Logger.info((String)("target date for DauerSepaDel: " + this.date.toString()));
            new CanTermDelRestriction(p).test();
            this.setJobParam("date", this.date);
        }
        super.setJob(job);
    }

    @Override
    public String getIdentifier() {
        return "DauerSEPADel";
    }

    @Override
    public String getName() throws RemoteException {
        return i18n.tr("SEPA-Dauerauftrag an {0} l\u00f6schen", this.dauerauftrag.getGegenkontoName());
    }

    @Override
    protected void markExecuted() throws RemoteException, ApplicationException {
        this.dauerauftrag.delete();
        this.konto.addToProtokoll(i18n.tr("SEPA-Dauerauftrag an {0} gel\u00f6scht", this.dauerauftrag.getGegenkontoName()), 1);
        Logger.info((String)"sepa-dauerauftrag deleted successfully");
    }

    @Override
    protected String markFailed(String error) throws RemoteException, ApplicationException {
        String msg = i18n.tr("Fehler beim L\u00f6schen des SEPA-Dauerauftrages an {0}: {1}", new String[]{this.dauerauftrag.getGegenkontoName(), error});
        this.konto.addToProtokoll(msg, 2);
        return msg;
    }
}

