/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server.hbci;

import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaDauerauftrag;
import de.willuhn.jameica.hbci.server.Converter;
import de.willuhn.jameica.hbci.server.hbci.AbstractHBCIJob;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kapott.hbci.GV_Result.GVRDauerList;

public class HBCISepaDauerauftragListJob
extends AbstractHBCIJob {
    private Konto konto = null;

    public HBCISepaDauerauftragListJob(Konto konto) throws ApplicationException, RemoteException {
        try {
            if (konto == null) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie ein Konto aus"));
            }
            if (konto.isNewObject()) {
                konto.store();
            }
            this.konto = konto;
            org.kapott.hbci.structures.Konto own = Converter.HibiscusKonto2HBCIKonto(konto);
            own.name = HBCIProperties.replace(own.name, HBCIProperties.TEXT_REPLACEMENTS_SEPA);
            this.setJobParam("src", own);
        }
        catch (ApplicationException | RemoteException e) {
            throw e;
        }
        catch (Throwable t) {
            Logger.error((String)("error while executing job " + this.getIdentifier()), (Throwable)t);
            throw new ApplicationException(i18n.tr("Fehler beim Erstellen des Auftrags. Fehlermeldung: {0}", t.getMessage()), t);
        }
    }

    @Override
    public String getIdentifier() {
        return "DauerSEPAList";
    }

    @Override
    protected HibiscusDBObject getContext() {
        return this.konto;
    }

    @Override
    public String getName() throws RemoteException {
        return i18n.tr("Abruf SEPA-Dauerauftr\u00e4ge {0}", this.konto.getLongName());
    }

    @Override
    protected void markExecuted() throws RemoteException, ApplicationException {
        GVRDauerList result = (GVRDauerList)this.getJobResult();
        DBIterator existing = this.konto.getSepaDauerauftraege();
        GVRDauerList.Dauer[] lines = result.getEntries();
        SepaDauerauftrag remote = null;
        SepaDauerauftrag local = null;
        HashMap<SepaDauerauftrag, Boolean> matches = new HashMap<SepaDauerauftrag, Boolean>();
        Logger.info((String)("checking for new and changed entries [received lines: " + lines.length + "]"));
        int i = 0;
        while (i < lines.length) {
            try {
                remote = this.create(lines[i]);
                local = this.find(existing, remote);
                if (local != null) {
                    Logger.info((String)("found a local copy. order id: " + remote.getOrderID() + ". Checking for modifications"));
                    matches.put(local, Boolean.TRUE);
                    if (remote.getChecksum() != local.getChecksum()) {
                        Logger.info((String)"modifications found, updating local copy");
                        local.overwrite(remote);
                        this.store(local);
                        Application.getMessagingFactory().sendMessage((Message)new ObjectChangedMessage((GenericObject)local));
                    }
                } else {
                    Logger.info((String)("no local copy found. adding sepa-dauerauftrag order id: " + remote.getOrderID()));
                    this.store(remote);
                    Application.getMessagingFactory().sendMessage((Message)new ImportMessage((GenericObject)remote));
                }
            }
            catch (Exception e) {
                Logger.error((String)"error while checking sepa-dauerauftrag, skipping this one", (Throwable)e);
            }
            ++i;
        }
        Logger.info((String)"checking for deletable entries");
        existing.begin();
        while (existing.hasNext()) {
            local = (SepaDauerauftrag)existing.next();
            if (!local.isActive()) {
                Logger.info((String)("skipping [id: " + local.getID() + "] - not yet submitted"));
                continue;
            }
            if (matches.containsKey(local)) {
                Logger.info((String)("skipping [id: " + local.getID() + ", order id: " + local.getOrderID() + "] - just matched"));
                continue;
            }
            Logger.info((String)("sepa-dauerauftrag order id: " + local.getOrderID() + " does no longer exist online, can be deleted"));
            local.delete();
        }
        Application.getMessagingFactory().sendMessage((Message)new ObjectChangedMessage((GenericObject)this.konto));
        this.konto.addToProtokoll(i18n.tr("SEPA-Dauerauftr\u00e4ge abgerufen"), 1);
        Logger.info((String)"sepa-dauerauftrag list fetched successfully");
    }

    private SepaDauerauftrag find(DBIterator existing, SepaDauerauftrag remote) throws RemoteException {
        existing.begin();
        while (existing.hasNext()) {
            SepaDauerauftrag local = (SepaDauerauftrag)existing.next();
            if (!local.isActive()) continue;
            String idLocal = StringUtils.trimToEmpty((String)local.getOrderID());
            String idRemote = StringUtils.trimToEmpty((String)remote.getOrderID());
            if (idRemote.length() == 0) {
                idRemote = "9999999999";
            }
            if (!idLocal.equals(idRemote)) continue;
            if (!idLocal.equals("9999999999")) {
                return local;
            }
            if (local.getChecksum() != remote.getChecksum()) continue;
            return local;
        }
        return null;
    }

    private SepaDauerauftrag create(GVRDauerList.Dauer remote) throws RemoteException, ApplicationException {
        SepaDauerauftrag auftrag = Converter.HBCIDauer2HibiscusSepaDauerauftrag(remote);
        auftrag.setKonto(this.konto);
        return auftrag;
    }

    private void store(SepaDauerauftrag auftrag) {
        try {
            auftrag.store();
        }
        catch (Exception e) {
            try {
                Logger.error((String)("unable to store dauerauftrag " + auftrag.getOrderID() + ", skipping"), (Throwable)e);
                this.konto.addToProtokoll(i18n.tr("Speichern des SEPA-Dauerauftrages fehlgeschlagen: {0}", e.getMessage()), 2);
            }
            catch (Exception e2) {
                Logger.error((String)"unable to log error", (Throwable)e2);
            }
        }
    }

    @Override
    protected String markFailed(String error) throws RemoteException, ApplicationException {
        String msg = i18n.tr("Fehler beim Abrufen der SEPA-Dauerauftr\u00e4ge: {0}", error);
        this.konto.addToProtokoll(msg, 2);
        return msg;
    }
}

