/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server.hbci;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaDauerauftrag;
import de.willuhn.jameica.hbci.rmi.Turnus;
import de.willuhn.jameica.hbci.server.Converter;
import de.willuhn.jameica.hbci.server.hbci.AbstractHBCIJob;
import de.willuhn.jameica.hbci.server.hbci.tests.PreTimeRestriction;
import de.willuhn.jameica.hbci.server.hbci.tests.TurnusRestriction;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kapott.hbci.GV.HBCIJob;
import org.kapott.hbci.GV_Result.GVRDauerEdit;
import org.kapott.hbci.GV_Result.GVRDauerNew;
import org.kapott.hbci.GV_Result.HBCIJobResult;

public class HBCISepaDauerauftragStoreJob
extends AbstractHBCIJob {
    private SepaDauerauftrag dauerauftrag = null;
    private Konto konto = null;
    private boolean active = false;

    public HBCISepaDauerauftragStoreJob(SepaDauerauftrag auftrag) throws ApplicationException, RemoteException {
        try {
            Turnus turnus;
            Date letzteZahlung;
            if (auftrag == null) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen SEPA-Dauerauftrag aus"));
            }
            if (auftrag.isNewObject()) {
                auftrag.store();
            }
            this.dauerauftrag = auftrag;
            this.konto = auftrag.getKonto();
            this.active = auftrag.isActive();
            if (!this.active && this.dauerauftrag.getBetrag() > Settings.getUeberweisungLimit()) {
                throw new ApplicationException(i18n.tr("Auftragslimit \u00fcberschritten: {0} ", String.valueOf(HBCI.DECIMALFORMAT.format(Settings.getUeberweisungLimit())) + " " + this.konto.getWaehrung()));
            }
            if (this.active) {
                String orderID = auftrag.getOrderID();
                if (StringUtils.trimToEmpty((String)orderID).equals("9999999999")) {
                    this.setJobParam("orderid", "");
                } else {
                    this.setJobParam("orderid", orderID);
                }
            }
            org.kapott.hbci.structures.Konto own = Converter.HibiscusKonto2HBCIKonto(this.konto);
            own.name = HBCIProperties.replace(own.name, HBCIProperties.TEXT_REPLACEMENTS_SEPA);
            this.setJobParam("src", own);
            org.kapott.hbci.structures.Konto k = new org.kapott.hbci.structures.Konto();
            k.bic = this.dauerauftrag.getGegenkontoBLZ();
            k.iban = this.dauerauftrag.getGegenkontoNummer();
            k.name = this.dauerauftrag.getGegenkontoName();
            this.setJobParam("dst", k);
            String curr = this.konto.getWaehrung();
            if (curr == null || curr.length() == 0) {
                curr = HBCIProperties.CURRENCY_DEFAULT_DE;
            }
            this.setJobParam("btg", this.dauerauftrag.getBetrag(), curr);
            this.setJobParamUsage(this.dauerauftrag);
            this.setJobParam("firstdate", this.dauerauftrag.getErsteZahlung());
            String purp = this.dauerauftrag.getPurposeCode();
            if (purp != null && purp.length() > 0) {
                this.setJobParam("purposecode", purp);
            }
            if ((letzteZahlung = this.dauerauftrag.getLetzteZahlung()) != null) {
                this.setJobParam("lastdate", letzteZahlung);
            }
            this.setJobParam("timeunit", (turnus = this.dauerauftrag.getTurnus()).getZeiteinheit() == 2 ? "M" : "W");
            this.setJobParam("turnus", turnus.getIntervall());
            this.setJobParam("execday", turnus.getTag());
        }
        catch (ApplicationException | RemoteException e) {
            throw e;
        }
        catch (Throwable t) {
            Logger.error((String)("error while executing job " + this.getIdentifier()), (Throwable)t);
            throw new ApplicationException(i18n.tr("Fehler beim Erstellen des Auftrags. Fehlermeldung: {0}", t.getMessage()), t);
        }
    }

    @Override
    protected HibiscusDBObject getContext() {
        return this.dauerauftrag;
    }

    @Override
    public void setJob(HBCIJob job) throws RemoteException, ApplicationException {
        Properties p = job.getJobRestrictions();
        Turnus turnus = this.dauerauftrag.getTurnus();
        new TurnusRestriction(turnus, p).test();
        if (!this.active) {
            new PreTimeRestriction(this.dauerauftrag.getErsteZahlung(), p).test();
        }
        super.setJob(job);
    }

    @Override
    public String getIdentifier() {
        if (this.active) {
            return "DauerSEPAEdit";
        }
        return "DauerSEPANew";
    }

    @Override
    public String getName() throws RemoteException {
        String empfName = this.dauerauftrag.getGegenkontoName();
        if (this.active) {
            return i18n.tr("SEPA-Dauerauftrag an {0} aktualisieren", empfName);
        }
        return i18n.tr("SEPA-Dauerauftrag an {0}", empfName);
    }

    @Override
    protected void markExecuted() throws RemoteException, ApplicationException {
        String empfName = this.dauerauftrag.getGegenkontoName();
        if (this.dauerauftrag.isActive()) {
            this.konto.addToProtokoll(i18n.tr("SEPA-Dauerauftrag aktualisiert an {0}", empfName), 1);
        } else {
            this.konto.addToProtokoll(i18n.tr("SEPA-Dauerauftrag ausgef\u00fchrt an {0} ", empfName), 1);
        }
        String orderID = null;
        HBCIJobResult result = this.getJobResult();
        orderID = result instanceof GVRDauerNew ? ((GVRDauerNew)result).getOrderId() : ((GVRDauerEdit)result).getOrderId();
        if (StringUtils.trimToNull((String)orderID) == null) {
            Logger.warn((String)"got no order id for this job, using placeholder id 9999999999");
            this.konto.addToProtokoll(i18n.tr("Keine Order-ID f\u00fcr SEPA-Dauerauftrag von Bank erhalten", empfName), 2);
            orderID = "9999999999";
        }
        this.dauerauftrag.setOrderID(orderID);
        this.dauerauftrag.store();
        Application.getMessagingFactory().sendMessage((Message)new ObjectChangedMessage((GenericObject)this.dauerauftrag));
        Logger.info((String)"dauerauftrag submitted successfully");
    }

    @Override
    protected String markFailed(String error) throws RemoteException, ApplicationException {
        String msg = i18n.tr("Fehler beim Ausf\u00fchren des SEPA-Dauerauftrages an {0}: {1}", new String[]{this.dauerauftrag.getGegenkontoName(), error});
        this.konto.addToProtokoll(msg, 2);
        return msg;
    }
}

