/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server.hbci;

import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.rmi.ObjectNotFoundException;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.rmi.HibiscusAddress;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaLastSequenceType;
import de.willuhn.jameica.hbci.rmi.SepaLastType;
import de.willuhn.jameica.hbci.rmi.SepaLastschrift;
import de.willuhn.jameica.hbci.server.Converter;
import de.willuhn.jameica.hbci.server.hbci.AbstractHBCIJob;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.kapott.hbci.GV_Result.AbstractGVRLastSEPA;

public class HBCISepaLastschriftJob
extends AbstractHBCIJob {
    private SepaLastschrift lastschrift = null;
    private SepaLastType type = null;
    private Konto konto = null;

    public HBCISepaLastschriftJob(SepaLastschrift lastschrift) throws ApplicationException, RemoteException {
        try {
            Date targetDate;
            String purp;
            String pmtInfId;
            String endToEndId;
            if (lastschrift == null) {
                throw new ApplicationException(i18n.tr("Bitte geben Sie einen Auftrag an"));
            }
            if (lastschrift.isNewObject()) {
                lastschrift.store();
            }
            if (lastschrift.ausgefuehrt()) {
                throw new ApplicationException(i18n.tr("Auftrag wurde bereits ausgef\u00fchrt"));
            }
            this.lastschrift = lastschrift;
            this.konto = this.lastschrift.getKonto();
            this.type = this.lastschrift.getType();
            if (this.lastschrift.getBetrag() > Settings.getUeberweisungLimit()) {
                throw new ApplicationException(i18n.tr("Auftragslimit \u00fcberschritten: {0} ", String.valueOf(HBCI.DECIMALFORMAT.format(Settings.getUeberweisungLimit())) + " " + this.konto.getWaehrung()));
            }
            org.kapott.hbci.structures.Konto own = Converter.HibiscusKonto2HBCIKonto(this.konto);
            own.name = HBCIProperties.replace(own.name, HBCIProperties.TEXT_REPLACEMENTS_SEPA);
            this.setJobParam("src", own);
            org.kapott.hbci.structures.Konto k = new org.kapott.hbci.structures.Konto();
            k.bic = lastschrift.getGegenkontoBLZ();
            k.iban = lastschrift.getGegenkontoNummer();
            k.name = lastschrift.getGegenkontoName();
            this.setJobParam("dst", k);
            String curr = this.konto.getWaehrung();
            if (curr == null || curr.length() == 0) {
                curr = HBCIProperties.CURRENCY_DEFAULT_DE;
            }
            this.setJobParam("btg", lastschrift.getBetrag(), curr);
            String zweck = lastschrift.getZweck();
            if (zweck != null && zweck.length() > 0) {
                this.setJobParam("usage", zweck);
            }
            if ((endToEndId = lastschrift.getEndtoEndId()) != null && endToEndId.trim().length() > 0) {
                this.setJobParam("endtoendid", endToEndId);
            }
            if ((pmtInfId = lastschrift.getPmtInfId()) != null && pmtInfId.trim().length() > 0) {
                this.setJobParam("pmtinfid", pmtInfId);
            }
            if ((purp = lastschrift.getPurposeCode()) != null && purp.length() > 0) {
                this.setJobParam("purposecode", purp);
            }
            this.setJobParam("mandateid", lastschrift.getMandateId());
            this.setJobParam("manddateofsig", lastschrift.getSignatureDate());
            this.setJobParam("creditorid", lastschrift.getCreditorId());
            this.setJobParam("sequencetype", lastschrift.getSequenceType().name());
            if (this.type != null) {
                this.setJobParam("type", this.type.name());
            }
            if ((targetDate = lastschrift.getTargetDate()) != null) {
                this.setJobParam("targetdate", targetDate);
            }
        }
        catch (ApplicationException | RemoteException e) {
            throw e;
        }
        catch (Throwable t) {
            Logger.error((String)("error while executing job " + this.getIdentifier()), (Throwable)t);
            throw new ApplicationException(i18n.tr("Fehler beim Erstellen des Auftrags. Fehlermeldung: {0}", t.getMessage()), t);
        }
    }

    @Override
    protected HibiscusDBObject getContext() {
        return this.lastschrift;
    }

    @Override
    public String getIdentifier() {
        if (this.type != null) {
            return this.type.getJobName();
        }
        return SepaLastType.DEFAULT.getJobName();
    }

    @Override
    public String getName() throws RemoteException {
        return i18n.tr("SEPA-Lastschrift an {0} (IBAN: {1})", new String[]{this.lastschrift.getGegenkontoName(), this.lastschrift.getGegenkontoNummer()});
    }

    @Override
    protected void markExecuted() throws RemoteException, ApplicationException {
        AbstractGVRLastSEPA result = (AbstractGVRLastSEPA)this.getJobResult();
        String orderId = result.getOrderId();
        Logger.info((String)("orderid for job: " + orderId));
        this.lastschrift.setOrderId(orderId);
        this.lastschrift.store();
        this.lastschrift.setAusgefuehrt(true);
        String id = StringUtils.trimToNull((String)MetaKey.ADDRESS_ID.get(this.lastschrift));
        if (id != null) {
            try {
                SepaLastSequenceType type;
                HibiscusAddress ha = (HibiscusAddress)Settings.getDBService().createObject(HibiscusAddress.class, id);
                String seqCode = StringUtils.trimToNull((String)MetaKey.SEPA_SEQUENCE_CODE.get(ha));
                if (seqCode != null && (type = SepaLastSequenceType.valueOf(seqCode)) == SepaLastSequenceType.FRST) {
                    Logger.debug((String)("auto-switching sequence-code for address-id" + id + " from FRST to RCUR"));
                    MetaKey.SEPA_SEQUENCE_CODE.set(ha, SepaLastSequenceType.RCUR.name());
                }
            }
            catch (IllegalArgumentException ie) {
                Logger.error((String)"unable to determine enum value of SepaLastSequenceType", (Throwable)ie);
            }
            catch (ObjectNotFoundException e) {
                Logger.info((String)("address-id " + id + " no longer exists, unable to auto-switch sequence-code"));
            }
            catch (RemoteException re) {
                Logger.error((String)("unable to to auto-switch sequence-code for address-id" + id), (Throwable)re);
            }
        }
        Application.getMessagingFactory().sendMessage((Message)new ObjectChangedMessage((GenericObject)this.lastschrift));
        this.konto.addToProtokoll(i18n.tr("SEPA-Lastschrift (Order-ID: {0}) eingereicht f\u00fcr: {1}", new String[]{orderId, this.lastschrift.getGegenkontoNummer()}), 1);
        Logger.info((String)"sepa direct debit submitted successfully");
    }

    @Override
    protected String markFailed(String error) throws ApplicationException, RemoteException {
        String msg = i18n.tr("Fehler beim Einziehen der SEPA-Lastschrift von {0}: {1}", new String[]{this.lastschrift.getGegenkontoName(), error});
        this.konto.addToProtokoll(msg, 2);
        return msg;
    }

    @Override
    protected void markCancelled() throws RemoteException, ApplicationException {
        String msg = i18n.tr("Ausf\u00fchrung der SEPA-Lastschrift {0} abgebrochen", this.lastschrift.getGegenkontoName());
        this.konto.addToProtokoll(msg, 2);
    }
}

