/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server.hbci;

import de.willuhn.datasource.rmi.ObjectNotFoundException;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.rmi.HibiscusAddress;
import de.willuhn.jameica.hbci.rmi.SepaLastSequenceType;
import de.willuhn.jameica.hbci.rmi.SepaLastType;
import de.willuhn.jameica.hbci.rmi.SepaSammelLastBuchung;
import de.willuhn.jameica.hbci.rmi.SepaSammelLastschrift;
import de.willuhn.jameica.hbci.server.hbci.AbstractHBCISepaSammelTransferJob;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class HBCISepaSammelLastschriftJob
extends AbstractHBCISepaSammelTransferJob<SepaSammelLastschrift> {
    private SepaLastType type = null;

    public HBCISepaSammelLastschriftJob(SepaSammelLastschrift lastschrift) throws ApplicationException, RemoteException {
        super(lastschrift);
        Date targetDate;
        this.type = lastschrift.getType();
        List buchungen = lastschrift.getBuchungen();
        int i = 0;
        while (i < buchungen.size()) {
            SepaSammelLastBuchung b = (SepaSammelLastBuchung)buchungen.get(i);
            Integer idx = i;
            this.setJobParam("mandateid", idx, b.getMandateId());
            this.setJobParam("manddateofsig", idx, b.getSignatureDate());
            this.setJobParam("creditorid", idx, b.getCreditorId());
            String purp = b.getPurposeCode();
            if (purp != null && purp.length() > 0) {
                this.setJobParam("purposecode", idx, purp);
            }
            ++i;
        }
        this.setJobParam("sequencetype", lastschrift.getSequenceType().name());
        if (this.type != null) {
            this.setJobParam("type", this.type.name());
        }
        if ((targetDate = lastschrift.getTargetDate()) != null) {
            this.setJobParam("targetdate", targetDate);
        }
    }

    @Override
    public String getIdentifier() {
        if (this.type != null) {
            return this.type.getMultiJobName();
        }
        return SepaLastType.DEFAULT.getMultiJobName();
    }

    @Override
    public String getName() throws RemoteException {
        return i18n.tr("SEPA-Sammellastschrift {0}", ((SepaSammelLastschrift)this.getSammelTransfer()).getBezeichnung());
    }

    @Override
    protected void markExecuted() throws RemoteException, ApplicationException {
        super.markExecuted();
        List buchungen = ((SepaSammelLastschrift)this.getSammelTransfer()).getBuchungen();
        for (SepaSammelLastBuchung b : buchungen) {
            String id = StringUtils.trimToNull((String)MetaKey.ADDRESS_ID.get(b));
            if (id == null) continue;
            try {
                SepaLastSequenceType type;
                HibiscusAddress ha = (HibiscusAddress)Settings.getDBService().createObject(HibiscusAddress.class, id);
                String seqCode = StringUtils.trimToNull((String)MetaKey.SEPA_SEQUENCE_CODE.get(ha));
                if (seqCode == null || (type = SepaLastSequenceType.valueOf(seqCode)) != SepaLastSequenceType.FRST) continue;
                Logger.debug((String)("auto-switching sequence-code for address-id" + id + " from FRST to RCUR"));
                MetaKey.SEPA_SEQUENCE_CODE.set(ha, SepaLastSequenceType.RCUR.name());
            }
            catch (IllegalArgumentException ie) {
                Logger.error((String)"unable to determine enum value of SepaLastSequenceType", (Throwable)ie);
            }
            catch (ObjectNotFoundException e) {
                Logger.info((String)("address-id " + id + " no longer exists, unable to auto-switch sequence-code"));
            }
            catch (RemoteException re) {
                Logger.error((String)("unable to to auto-switch sequence-code for address-id" + id), (Throwable)re);
            }
        }
    }
}

