/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server.hbci;

import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.pseudo.PseudoIterator;
import de.willuhn.io.IOUtil;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.myema.FibuTransfer;
import de.willuhn.jameica.hbci.rmi.HibiscusDBObject;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.server.Converter;
import de.willuhn.jameica.hbci.server.KontoUtil;
import de.willuhn.jameica.hbci.server.hbci.AbstractHBCIJob;
import de.willuhn.jameica.hbci.server.hbci.rewriter.RewriterRegistry;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.plugin.PluginResources;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kapott.hbci.GV_Result.GVRKUms;

public class HBCIUmsatzJob
extends AbstractHBCIJob {
    private static final Settings settings = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getSettings();
    private Konto konto = null;
    private Date saldoDatum = null;

    public HBCIUmsatzJob(Konto konto) throws ApplicationException, RemoteException {
        try {
            PluginResources res = Application.getPluginLoader().getPlugin(HBCI.class).getResources();
            if (konto == null) {
                throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie ein Konto aus"));
            }
            if (konto.isNewObject()) {
                konto.store();
            }
            this.konto = konto;
            String curr = konto.getWaehrung();
            if (curr == null || curr.length() == 0) {
                konto.setWaehrung(HBCIProperties.CURRENCY_DEFAULT_DE);
            }
            this.setJobParam("my", Converter.HibiscusKonto2HBCIKonto(konto));
            this.saldoDatum = konto.getSaldoDatum();
            if (this.saldoDatum != null) {
                Date now;
                int offset = res.getSettings().getInt("umsatz.startdate.offset", 0);
                if (offset != 0) {
                    Logger.info((String)("using custom offset for startdate: " + offset));
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(this.saldoDatum);
                    cal.add(5, offset);
                    this.saldoDatum = cal.getTime();
                }
                if (this.saldoDatum.after(now = new Date())) {
                    Logger.warn((String)("future start date " + this.saldoDatum + " given. this is not allowed, changing to current date " + now));
                    this.saldoDatum = now;
                } else {
                    int timeRange = KontoUtil.getUmsaetzeTimeRange(konto, true);
                    if (timeRange > 0) {
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(now);
                        cal.add(5, -timeRange);
                        Date earliestDate = cal.getTime();
                        if (this.saldoDatum.before(earliestDate)) {
                            Logger.warn((String)("start date " + this.saldoDatum + " is more than " + timeRange + " days ago. this is not allowed, changing to earliest date " + earliestDate));
                            this.saldoDatum = earliestDate;
                        }
                    }
                }
                this.saldoDatum = DateUtil.startOfDay((Date)this.saldoDatum);
                Logger.info((String)("startdate: " + HBCI.LONGDATEFORMAT.format(this.saldoDatum)));
                this.setJobParam("startdate", this.saldoDatum);
            }
        }
        catch (ApplicationException | RemoteException e) {
            throw e;
        }
        catch (Throwable t) {
            Logger.error((String)("error while executing job " + this.getIdentifier()), (Throwable)t);
            throw new ApplicationException(i18n.tr("Fehler beim Erstellen des Auftrags. Fehlermeldung: {0}", t.getMessage()), t);
        }
    }

    @Override
    protected HibiscusDBObject getContext() {
        return this.konto;
    }

    @Override
    public String getIdentifier() {
        return KontoUtil.useCamt(this.konto, true) ? "KUmsAllCamt" : "KUmsAll";
    }

    @Override
    public String getName() throws RemoteException {
        return i18n.tr("Umsatzabruf {0}", this.konto.getLongName());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void markExecuted() throws RemoteException, ApplicationException {
        block30: {
            block28: {
                block29: {
                    block27: {
                        block26: {
                            this.konto.addToProtokoll(HBCIUmsatzJob.i18n.tr("Ums\u00e4tze abgerufen"), 1);
                            duplicates = new HashMap<Umsatz, Integer>();
                            fetchUnbooked = HBCIUmsatzJob.settings.getBoolean("umsatz.fetchnotbooked", true);
                            result = (GVRKUms)this.getJobResult();
                            booked = result.getFlatData();
                            unbooked = fetchUnbooked != false ? result.getFlatDataUnbooked() : null;
                            d = this.getMergeWindow(booked, unbooked);
                            umsatzList = new ArrayList<Umsatz>();
                            existing = this.konto.getUmsaetze(d, null);
                            if (booked == null || booked.size() <= 0) break block26;
                            this.dumpCamt(result.camtBooked, true);
                            created = 0;
                            skipped = 0;
                            Logger.info((String)"applying booked entries");
                            rewriter = RewriterRegistry.getRewriter(this.konto.getBLZ(), this.konto.getKontonummer());
                            i = 0;
                            while (i < booked.size()) {
                                umsatz = Converter.HBCIUmsatz2HibiscusUmsatz((GVRKUms.UmsLine)booked.get(i));
                                umsatz.setKonto(this.konto);
                                if (rewriter != null) {
                                    try {
                                        rewriter.rewrite(umsatz);
                                    }
                                    catch (Exception e) {
                                        Logger.error((String)"error while rewriting umsatz", (Throwable)e);
                                    }
                                }
                                fromDB = null;
                                counter = 0;
                                existing.begin();
                                j = 0;
                                while (j < existing.size()) {
                                    dbObject = existing.next();
                                    if (dbObject.equals((GenericObject)umsatz)) {
                                        ++counter;
                                        fromDB = (Umsatz)dbObject;
                                    }
                                    ++j;
                                }
                                if (fromDB == null) ** GOTO lbl-1000
                                countInCurrentJobResult = (Integer)duplicates.get(fromDB);
                                if (countInCurrentJobResult == null) {
                                    duplicates.put(fromDB, 1);
                                    ++skipped;
                                } else if (countInCurrentJobResult <= counter) {
                                    duplicates.put(fromDB, countInCurrentJobResult + 1);
                                    ++skipped;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    try {
                                        umsatz.store();
                                        Application.getMessagingFactory().sendMessage((Message)new ImportMessage((GenericObject)umsatz));
                                        ++created;
                                        umsatzList.add(umsatz);
                                    }
                                    catch (Exception e2) {
                                        Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(HBCIUmsatzJob.i18n.tr("Nicht alle empfangenen Ums\u00e4tze konnten gespeichert werden. Bitte pr\u00fcfen Sie das System-Protokoll"), 1));
                                        Logger.error((String)"error while adding umsatz, skipping this one", (Throwable)e2);
                                    }
                                }
                                ++i;
                            }
                            if (umsatzList.size() > 0) {
                                FibuTransfer.execute(umsatzList.toArray(new Umsatz[umsatzList.size()]), false);
                            }
                            Logger.info((String)("done. new entries: " + created + ", skipped entries (already in database): " + skipped));
                            break block27;
                        }
                        Logger.info((String)"got no new booked entries");
                    }
                    duplicates.clear();
                    if (!fetchUnbooked) break block28;
                    existingUnbooked = this.konto.getUmsaetze(null, null);
                    existingUnbooked.addFilter("flags = 2");
                    if (unbooked == null || unbooked.size() <= 0) break block29;
                    this.dumpCamt(result.camtNotBooked, false);
                    fetched = new ArrayList<Umsatz>();
                    created = 0;
                    skipped = 0;
                    Logger.info((String)"applying not-booked (vorgemerkte) entries");
                    i = 0;
                    while (i < unbooked.size()) {
                        umsatz = Converter.HBCIUmsatz2HibiscusUmsatz((GVRKUms.UmsLine)unbooked.get(i));
                        umsatz.setFlags(2);
                        umsatz.setSaldo(0.0);
                        umsatz.setKonto(this.konto);
                        fetched.add(umsatz);
                        fromDB = null;
                        counter = 0;
                        existingUnbooked.begin();
                        j = 0;
                        while (j < existingUnbooked.size()) {
                            dbObject = existingUnbooked.next();
                            if (dbObject.equals((GenericObject)umsatz)) {
                                ++counter;
                                fromDB = (Umsatz)dbObject;
                            }
                            ++j;
                        }
                        if (fromDB == null) ** GOTO lbl-1000
                        countInCurrentJobResult = (Integer)duplicates.get(fromDB);
                        if (countInCurrentJobResult == null) {
                            duplicates.put(fromDB, 1);
                            ++skipped;
                        } else if (countInCurrentJobResult <= counter) {
                            duplicates.put(fromDB, countInCurrentJobResult + 1);
                            ++skipped;
                        } else lbl-1000:
                        // 2 sources

                        {
                            try {
                                umsatz.store();
                                Application.getMessagingFactory().sendMessage((Message)new ImportMessage((GenericObject)umsatz));
                                ++created;
                            }
                            catch (Exception e2) {
                                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(HBCIUmsatzJob.i18n.tr("Nicht alle empfangenen Ums\u00e4tze konnten gespeichert werden. Bitte pr\u00fcfen Sie das System-Protokoll"), 1));
                                Logger.error((String)"error while adding umsatz, skipping this one", (Throwable)e2);
                            }
                        }
                        ++i;
                    }
                    Logger.info((String)"clean obsolete notbooked entries");
                    newList = PseudoIterator.fromArray((GenericObject[])fetched.toArray(new Umsatz[0]));
                    deleted = 0;
                    existingUnbooked.begin();
                    while (existingUnbooked.hasNext()) {
                        u = (Umsatz)existingUnbooked.next();
                        if (!u.hasFlag(2) || newList.contains((GenericObject)u) != null) continue;
                        u.delete();
                        ++deleted;
                    }
                    Logger.info((String)("removed entries: " + deleted));
                    Logger.info((String)("done. new entries: " + created + ", skipped entries (already in database): " + skipped));
                    break block30;
                }
                Logger.info((String)"got no new not-booked (vorgemerkte) entries");
                Logger.info((String)"clean obsolete not-booked entries");
                current = DateUtil.startOfDay((Date)new Date());
                count = 0;
                existingUnbooked.begin();
                while (existingUnbooked.hasNext()) {
                    u = (Umsatz)existingUnbooked.next();
                    if (!u.hasFlag(2)) continue;
                    test = u.getDatum();
                    if (test == null) {
                        test = u.getValuta();
                    }
                    if (test == null) {
                        Logger.warn((String)"notbooked entry contains no date, skipping");
                        continue;
                    }
                    if (!test.before(current)) continue;
                    u.delete();
                    ++count;
                }
                Logger.info((String)("removed entries: " + count));
                break block30;
            }
            Logger.info((String)"fetching of not-booked (vorgemerkte) entries disabled");
        }
        Logger.info((String)"umsatz list fetched successfully");
    }

    private void dumpCamt(List<String> camt, boolean booked) {
        if (camt == null || camt.size() == 0) {
            return;
        }
        try {
            String storeCamt = StringUtils.trimToNull((String)settings.getString("umsatz.camt.path", null));
            if (storeCamt == null) {
                return;
            }
            Logger.info((String)("dump CAMT data into " + storeCamt));
            File dir = new File(storeCamt);
            if (!dir.exists() && !dir.mkdirs()) {
                Logger.warn((String)("unable to create folder " + dir));
                return;
            }
            if (!dir.canWrite()) {
                Logger.warn((String)("unable to write into folder " + dir));
                return;
            }
            Date date = new Date();
            for (String data : camt) {
                File f = this.createFile(dir, date, booked);
                Logger.info((String)("dump CAMT data into " + f));
                BufferedOutputStream os = null;
                try {
                    os = new BufferedOutputStream(new FileOutputStream(f));
                    ((OutputStream)os).write(data.getBytes("ISO-8859-1"));
                }
                catch (Throwable throwable) {
                    IOUtil.close((Closeable[])new Closeable[]{os});
                    throw throwable;
                }
                IOUtil.close((Closeable[])new Closeable[]{os});
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to dump raw CAMt data", (Throwable)e);
        }
    }

    private File createFile(File dir, Date date, boolean booked) throws IOException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd.HH-mm-ss.SSS");
        File f = null;
        int i = 0;
        while (i < 1000) {
            f = new File(dir, String.valueOf(df.format(date)) + "-" + (booked ? "booked" : "notbooked") + (i > 0 ? "-" + i : "") + ".xml");
            if (!f.exists()) {
                return f;
            }
            ++i;
        }
        throw new IOException("cannot create file " + f + ", already exists");
    }

    @Override
    protected String markFailed(String error) throws RemoteException, ApplicationException {
        String msg = i18n.tr("Umsatzabruf fehlgeschlagen: {0}", error);
        this.konto.addToProtokoll(msg, 2);
        return msg;
    }

    private Date getMergeWindow(List<GVRKUms.UmsLine> booked, List<GVRKUms.UmsLine> unbooked) {
        Date d = null;
        String basedOn = null;
        if (booked != null && booked.size() > 0) {
            for (GVRKUms.UmsLine line : booked) {
                if (line.bdate == null || d != null && !line.bdate.before(d)) continue;
                d = line.bdate;
                basedOn = "fetched booked entries";
            }
        }
        if (unbooked != null && unbooked.size() > 0) {
            for (GVRKUms.UmsLine line : unbooked) {
                if (line.bdate == null || d != null && !line.bdate.before(d)) continue;
                d = line.bdate;
                basedOn = "fetched not-booked entries";
            }
        }
        if (d == null && this.saldoDatum != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.saldoDatum);
            cal.add(5, settings.getInt("umsatz.mergewindow.offset", -30));
            d = cal.getTime();
            basedOn = "last sync";
        }
        if (d == null) {
            Logger.info((String)"merge window: not set");
        } else {
            Logger.info((String)("merge window: " + d + " - now (based on " + basedOn + ")"));
        }
        return d;
    }
}

