/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server.hbci.rewriter;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.jameica.hbci.server.hbci.rewriter.UmsatzRewriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Lifecycle(value=Lifecycle.Type.CONTEXT)
public class DeutscheBankUmsatzRewriter
implements UmsatzRewriter {
    @Override
    public List<String> getBlzList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("50070024");
        list.add("10070024");
        list.add("60070070");
        list.add("62070081");
        list.add("10070848");
        list.add("26570090");
        list.add("25770024");
        list.add("54570024");
        list.add("76026000");
        list.add("10077777");
        return list;
    }

    @Override
    public void rewrite(Umsatz u) throws Exception {
        String name = u.getGegenkontoName();
        if (name != null && name.length() > 0) {
            return;
        }
        String kto = u.getGegenkontoNummer();
        if (kto != null && kto.length() > 0) {
            return;
        }
        String blz = u.getGegenkontoBLZ();
        if (blz != null && blz.length() > 0) {
            return;
        }
        String[] s = VerwendungszweckUtil.toArray(u);
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(s));
        if (lines.size() == 0) {
            return;
        }
        int i = 0;
        while (i < lines.size()) {
            if (this.applyGegenkonto(u, (String)lines.get(i))) {
                u.setZweck(null);
                u.setZweck2(null);
                u.setWeitereVerwendungszwecke(null);
                if (lines.size() < 2) {
                    return;
                }
                u.setGegenkontoName(((String)lines.get(1)).trim());
                if (i >= 2) {
                    ArrayList list = new ArrayList(lines.subList(2, i));
                    if (list.size() == 0) {
                        return;
                    }
                    u.setZweck(((String)list.remove(0)).trim());
                    if (list.size() == 0) {
                        return;
                    }
                    u.setZweck2(((String)list.remove(0)).trim());
                    if (list.size() == 0) {
                        return;
                    }
                    u.setWeitereVerwendungszwecke(list.toArray(new String[0]));
                }
            }
            ++i;
        }
    }

    private boolean applyGegenkonto(Umsatz u, String s) throws RemoteException {
        if (s == null || s.length() == 0 || u == null) {
            return false;
        }
        String gk = s.trim();
        if (!gk.matches("^KTO([ ]{1,7})[0-9]{3,10} BLZ [0-9]{8}")) {
            return false;
        }
        String[] sl = (gk = gk.replaceAll("[a-zA-Z]", "").trim()).split(" {1,7}");
        if (sl.length != 2) {
            return false;
        }
        u.setGegenkontoNummer(sl[0].trim());
        u.setGegenkontoBLZ(sl[1].trim());
        return true;
    }
}

