/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server.hbci.rewriter;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.jameica.hbci.server.hbci.rewriter.UmsatzRewriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Lifecycle(value=Lifecycle.Type.CONTEXT)
public class NetbankUmsatzRewriter
implements UmsatzRewriter {
    @Override
    public List<String> getBlzList() {
        ArrayList<String> list = new ArrayList<String>();
        return list;
    }

    @Override
    public void rewrite(Umsatz u) throws Exception {
        String name = u.getGegenkontoName();
        if (name != null && name.length() > 0) {
            return;
        }
        String kto = u.getGegenkontoNummer();
        if (kto != null && kto.length() > 0) {
            return;
        }
        String blz = u.getGegenkontoBLZ();
        if (blz != null && blz.length() > 0) {
            return;
        }
        String[] s = VerwendungszweckUtil.toArray(u);
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(s));
        if (lines.size() == 0) {
            return;
        }
        u.setZweck(null);
        u.setZweck2(null);
        u.setWeitereVerwendungszwecke(null);
        u.setGegenkontoName(((String)lines.remove(0)).trim());
        if (lines.size() == 0) {
            return;
        }
        if (this.applyGegenkonto(u, ((String)lines.get(lines.size() - 1)).trim())) {
            lines.remove(lines.size() - 1);
            if (lines.size() == 0) {
                return;
            }
        }
        u.setZweck(((String)lines.remove(0)).trim());
        if (lines.size() == 0) {
            return;
        }
        u.setZweck2(((String)lines.remove(0)).trim());
        if (lines.size() == 0) {
            return;
        }
        u.setWeitereVerwendungszwecke(lines.toArray(new String[0]));
    }

    private boolean applyGegenkonto(Umsatz u, String s) throws RemoteException {
        if (s == null || s.length() == 0 || u == null) {
            return false;
        }
        String gk = s.trim();
        if (!gk.matches("^KTO/BLZ [0-9]{3,10}/[0-9]{8}")) {
            return false;
        }
        gk = gk.replaceAll("KTO/BLZ", "").replaceAll("[^0-9/]", "");
        String[] sl = gk.split("/");
        u.setGegenkontoNummer(sl[0]);
        u.setGegenkontoBLZ(sl[1]);
        return true;
    }
}

