/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server.hbci.rewriter;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.server.hbci.rewriter.UmsatzRewriter;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ClassFinder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RewriterRegistry {
    private static final Settings settings = new Settings(RewriterRegistry.class);
    private static Map<String, Class<UmsatzRewriter>> umsatzRewriters = null;

    public static synchronized UmsatzRewriter getRewriter(String blz, String konto) {
        Class<UmsatzRewriter> c;
        if (blz == null) {
            return null;
        }
        if (settings.getBoolean("blacklist.blz." + blz, false)) {
            Logger.info((String)"BLZ blacklisted for rewriters, skip rewriting");
            return null;
        }
        if (konto != null && settings.getBoolean("blacklist.konto." + konto, false)) {
            Logger.info((String)"Konto blacklisted for rewriters, skip rewriting");
            return null;
        }
        BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        if (umsatzRewriters == null) {
            umsatzRewriters = new HashMap<String, Class<UmsatzRewriter>>();
            try {
                Class[] classes;
                ClassFinder finder = Application.getPluginLoader().getManifest(HBCI.class).getClassLoader().getClassFinder();
                Class[] classArray = classes = finder.findImplementors(UmsatzRewriter.class);
                int n = classes.length;
                int n2 = 0;
                while (n2 < n) {
                    Class c2 = classArray[n2];
                    try {
                        UmsatzRewriter u = (UmsatzRewriter)service.get(c2);
                        List<String> blzList = u.getBlzList();
                        for (String s : blzList) {
                            umsatzRewriters.put(s, c2);
                        }
                    }
                    catch (Exception e) {
                        Logger.error((String)("unable to load rewriter " + c2.getName() + ", skipping"), (Throwable)e);
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                Logger.warn((String)"no umsatz rewriters found");
            }
        }
        if ((c = umsatzRewriters.get(blz)) == null) {
            return null;
        }
        return (UmsatzRewriter)service.get(c);
    }
}

