/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server.hbci.tests;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.server.hbci.tests.Restriction;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;

public class PreTimeRestriction
implements Restriction {
    private Properties p = null;
    private Date date = null;
    private I18N i18n;

    public PreTimeRestriction(Date ersteZahlung, Properties jobRestrictions) {
        this.date = DateUtil.startOfDay((Date)ersteZahlung);
        this.p = jobRestrictions;
        this.i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    }

    @Override
    public void test() throws ApplicationException {
        this.testMin();
        this.testMax();
    }

    private void testMin() throws ApplicationException {
        String min = this.p.getProperty("minpretime");
        if (min == null || min.length() == 0) {
            return;
        }
        Logger.debug((String)("testing first payment date " + this.date.toString() + " against restriction \"minpretime\": " + min));
        int i = 0;
        try {
            i = Integer.parseInt(min);
        }
        catch (NumberFormatException e) {
            Logger.warn((String)("unable to parse job restriction value for \"minpretime\": " + min));
            return;
        }
        Calendar cal = Calendar.getInstance(Application.getConfig().getLocale());
        cal.add(5, i);
        Date test = DateUtil.startOfDay((Date)cal.getTime());
        if (this.date.before(test)) {
            throw new ApplicationException(this.i18n.tr("Das Datum der Zahlung muss mindestens {0} Tag(e) in der Zukunft liegen", min));
        }
    }

    private void testMax() throws ApplicationException {
        String max = this.p.getProperty("maxpretime");
        if (max == null || max.length() == 0) {
            return;
        }
        Logger.debug((String)("testing first payment date " + this.date.toString() + " against restriction \"maxpretime\": " + max));
        int i = 0;
        try {
            i = Integer.parseInt(max);
        }
        catch (NumberFormatException e) {
            Logger.warn((String)("unable to parse job restriction value for \"maxpretime\": " + max));
            return;
        }
        Calendar cal = Calendar.getInstance(Application.getConfig().getLocale());
        cal.add(5, i);
        Date test = DateUtil.endOfDay((Date)cal.getTime());
        if (!this.date.before(test)) {
            throw new ApplicationException(this.i18n.tr("Das Datum der Zahlung darf h\u00f6chstens {0} Tag(e) in der Zukunft liegen", max));
        }
    }
}

