/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.server.hbci.tests;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.rmi.Turnus;
import de.willuhn.jameica.hbci.server.hbci.tests.Restriction;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Properties;

public class TurnusRestriction
implements Restriction {
    private Turnus turnus = null;
    private Properties p = null;
    private I18N i18n;

    public TurnusRestriction(Turnus turnus, Properties jobRestrictions) {
        this.turnus = turnus;
        this.p = jobRestrictions;
        this.i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    }

    @Override
    public void test() throws ApplicationException {
        try {
            this.testTurnusDays();
            this.testTurnusMonths();
        }
        catch (RemoteException e) {
            Logger.error((String)"error while performing turnus restriction test", (Throwable)e);
            throw new ApplicationException(this.i18n.tr("Fehler beim Testen des Zahlungsturnus auf G\u00fcltigkeit"));
        }
    }

    private void testTurnusMonths() throws ApplicationException, RemoteException {
        if (this.turnus.getZeiteinheit() != 2) {
            return;
        }
        String turnusMonths = this.p.getProperty("turnusmonths");
        if (turnusMonths == null || turnusMonths.length() == 0 || turnusMonths.equals("00")) {
            return;
        }
        int test = this.turnus.getIntervall();
        Logger.debug((String)("testing interval " + test + " against restriction \"turnusmonths\": " + turnusMonths));
        int i = 0;
        while (i < turnusMonths.length()) {
            try {
                if (test == Integer.parseInt(turnusMonths.substring(i, i + 2))) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            i += 2;
        }
        throw new ApplicationException(this.i18n.tr("Turnus mit einem Intervall von {0} Monaten wird von Ihrer Bank nicht unterst\u00fctzt", "" + test));
    }

    private void testTurnusDays() throws ApplicationException, RemoteException {
        if (this.turnus.getZeiteinheit() != 2) {
            return;
        }
        String days = this.p.getProperty("dayspermonth");
        if (days == null || days.length() == 0 || days.equals("00")) {
            return;
        }
        int test = this.turnus.getTag();
        Logger.debug((String)("testing interval " + test + " against restriction \"dayspermonth\": " + days));
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < days.length()) {
            try {
                int d = Integer.parseInt(days.substring(i, i + 2));
                sb.append("," + d);
                if (test == d) {
                    return;
                }
            }
            catch (Exception d) {
                // empty catch block
            }
            i += 2;
        }
        if (test == HBCIProperties.HBCI_LAST_OF_MONTH) {
            throw new ApplicationException(this.i18n.tr("Zahlungen zum Monatsletzten werden von Ihrer Bank nicht unterst\u00fctzt"));
        }
        String s = sb.toString().substring(1);
        String[] values = new String[]{"" + test, s};
        throw new ApplicationException(this.i18n.tr("Zahlungen am {0}. des Monats werden von Ihrer Bank nicht unterst\u00fctzt. Erlaubte Werte: {1}", values));
    }
}

